/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.util.Consumer;

public class SafepointManager {
    private final RubyContext context;
    @CompilerDirectives.CompilationFinal
    private Assumption assumption = Truffle.getRuntime().createAssumption();
    private CyclicBarrier barrier;
    private int liveThreads = 1;
    private Consumer<RubyThread> action;

    public SafepointManager(RubyContext context) {
        this.context = context;
    }

    public synchronized void enterThread() {
        CompilerAsserts.neverPartOfCompilation();
        ++this.liveThreads;
    }

    public synchronized void leaveThread() {
        CompilerAsserts.neverPartOfCompilation();
        this.poll();
        --this.liveThreads;
    }

    public void poll() {
        try {
            this.assumption.check();
        }
        catch (InvalidAssumptionException e) {
            this.assumptionInvalidated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assumptionInvalidated() {
        this.waitOnBarrier();
        try {
            this.action.accept(this.context.getThreadManager().getCurrentThread());
        }
        finally {
            this.waitOnBarrier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pauseAllThreadsAndExecute(Consumer<RubyThread> action) {
        CompilerDirectives.transferToInterpreter();
        this.action = action;
        this.barrier = new CyclicBarrier(this.liveThreads);
        this.assumption.invalidate();
        this.context.getThreadManager().interruptAllThreads();
        this.waitOnBarrier();
        this.assumption = Truffle.getRuntime().createAssumption();
        try {
            action.accept(this.context.getThreadManager().getCurrentThread());
        }
        finally {
            this.waitOnBarrier();
        }
    }

    public synchronized void pauseAllThreadsAndExecuteSignalHandler(Consumer<RubyThread> action) {
        CompilerDirectives.transferToInterpreter();
        this.action = action;
        this.barrier = new CyclicBarrier(this.liveThreads + 1);
        this.assumption.invalidate();
        this.context.getThreadManager().interruptAllThreads();
        this.waitOnBarrierNoGlobalLock();
        this.assumption = Truffle.getRuntime().createAssumption();
        this.waitOnBarrierNoGlobalLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnBarrier() {
        RubyThread runningThread = this.context.getThreadManager().leaveGlobalLock();
        Thread.interrupted();
        try {
            this.waitOnBarrierNoGlobalLock();
        }
        finally {
            this.context.getThreadManager().enterGlobalLock(runningThread);
        }
    }

    private void waitOnBarrierNoGlobalLock() {
        while (true) {
            try {
                this.barrier.await();
            }
            catch (BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

