/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyFiber;

public class FiberManager {
    private final RubyFiber rootFiber;
    private RubyFiber currentFiber;
    private final Set<RubyFiber> runningFibers = Collections.newSetFromMap(new ConcurrentHashMap());

    public FiberManager(RubyContext context) {
        this.currentFiber = this.rootFiber = new RubyFiber(context.getCoreLibrary().getFiberClass(), this, context.getThreadManager());
    }

    public RubyFiber getCurrentFiber() {
        return this.currentFiber;
    }

    public void setCurrentFiber(RubyFiber fiber2) {
        this.currentFiber = fiber2;
    }

    public void registerFiber(RubyFiber fiber2) {
        this.runningFibers.add(fiber2);
    }

    public void unregisterFiber(RubyFiber fiber2) {
        this.runningFibers.remove(fiber2);
    }

    public void shutdown() {
        for (RubyFiber fiber2 : this.runningFibers) {
            fiber2.shutdown();
        }
    }
}

