/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyFile;

public class FeatureManager {
    private RubyContext context;

    public FeatureManager(RubyContext context) {
        this.context = context;
    }

    public boolean require(String path2, String feature, RubyNode currentNode) throws IOException {
        RubyConstant dataConstantBefore = ModuleOperations.lookupConstant(this.context, LexicalScope.NONE, this.context.getCoreLibrary().getObjectClass(), "DATA");
        try {
            if (path2 != null) {
                if (this.requireInPath(path2, feature, currentNode)) {
                    boolean bl = true;
                    return bl;
                }
            } else {
                if (feature.equals("zlib")) {
                    this.context.getWarnings().warn("zlib not yet implemented");
                    boolean bl = true;
                    return bl;
                }
                if (feature.equals("enumerator")) {
                    this.context.getWarnings().warn("enumerator not yet implemented");
                    boolean bl = true;
                    return bl;
                }
                if (feature.equals("rbconfig")) {
                    boolean bl = true;
                    return bl;
                }
                if (feature.equals("thread")) {
                    boolean bl = true;
                    return bl;
                }
                if (feature.equals("time")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.requireFile(feature, currentNode)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.requireFile(feature + ".rb", currentNode)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.requireInPath(this.context.getRuntime().getCurrentDirectory(), feature, currentNode)) {
                    boolean bl = true;
                    return bl;
                }
                for (Object pathObject : this.context.getCoreLibrary().getLoadPath().slowToArray()) {
                    String loadPath = pathObject.toString();
                    if (!this.requireInPath(loadPath, feature, currentNode)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            throw new RaiseException(this.context.getCoreLibrary().loadErrorCannotLoad(feature, currentNode));
        }
        finally {
            if (dataConstantBefore == null) {
                this.context.getCoreLibrary().getObjectClass().removeConstant(currentNode, "DATA");
            } else {
                this.context.getCoreLibrary().getObjectClass().setConstant(currentNode, "DATA", dataConstantBefore.getValue());
            }
        }
    }

    private boolean requireInPath(String path2, String feature, RubyNode currentNode) throws IOException {
        if (this.requireFile(new File(path2, feature).getPath(), currentNode)) {
            return true;
        }
        return this.requireFile(new File(path2, feature).getPath() + ".rb", currentNode);
    }

    private boolean requireFile(String fileName, RubyNode currentNode) throws IOException {
        if ((fileName = fileName.replace('\\', '/')).startsWith("core:/")) {
            for (Object loaded : Arrays.asList(this.context.getCoreLibrary().getLoadedFeatures().slowToArray())) {
                if (!loaded.toString().equals(fileName)) continue;
                return true;
            }
            String coreFileName = fileName.substring("core:/".length());
            if (this.context.getRuntime().getLoadService().getClassPathResource(this.context.getRuntime().getJRubyClassLoader(), coreFileName) == null) {
                return false;
            }
            this.context.getCoreLibrary().loadRubyCore(coreFileName);
            this.context.getCoreLibrary().getLoadedFeatures().slowPush(this.context.makeString(fileName));
            return true;
        }
        File file2 = new File(fileName);
        if (!file2.isFile()) {
            return false;
        }
        String expandedPath = RubyFile.expandPath(fileName);
        for (Object loaded : Arrays.asList(this.context.getCoreLibrary().getLoadedFeatures().slowToArray())) {
            if (!loaded.toString().equals(expandedPath)) continue;
            return true;
        }
        this.context.getCoreLibrary().getLoadedFeatures().slowPush(this.context.makeString(expandedPath));
        this.context.loadFile(fileName, currentNode);
        return true;
    }
}

