/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.MethodLike;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class InternalMethod
implements MethodLike {
    private final SharedMethodInfo sharedMethodInfo;
    private final String name;
    private final RubyModule declaringModule;
    private final Visibility visibility;
    private final boolean undefined;
    private final CallTarget callTarget;
    private final MaterializedFrame declarationFrame;

    public InternalMethod(SharedMethodInfo sharedMethodInfo, String name2, RubyModule declaringModule, Visibility visibility, boolean undefined, CallTarget callTarget, MaterializedFrame declarationFrame) {
        this.sharedMethodInfo = sharedMethodInfo;
        this.declaringModule = declaringModule;
        this.name = name2;
        this.visibility = visibility;
        this.undefined = undefined;
        this.callTarget = callTarget;
        this.declarationFrame = declarationFrame;
    }

    @Override
    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    @Override
    public RubyModule getDeclaringModule() {
        return this.declaringModule;
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public MaterializedFrame getDeclarationFrame() {
        return this.declarationFrame;
    }

    public CallTarget getCallTarget() {
        return this.callTarget;
    }

    public InternalMethod withDeclaringModule(RubyModule newDeclaringModule) {
        if (newDeclaringModule == this.declaringModule) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.name, newDeclaringModule, this.visibility, this.undefined, this.callTarget, this.declarationFrame);
    }

    public InternalMethod withNewName(String newName) {
        return new InternalMethod(this.sharedMethodInfo, newName, this.declaringModule, this.visibility, this.undefined, this.callTarget, this.declarationFrame);
    }

    public InternalMethod withVisibility(Visibility newVisibility) {
        if (newVisibility == this.visibility) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.name, this.declaringModule, newVisibility, this.undefined, this.callTarget, this.declarationFrame);
    }

    public InternalMethod undefined() {
        return new InternalMethod(this.sharedMethodInfo, this.name, this.declaringModule, this.visibility, true, this.callTarget, this.declarationFrame);
    }

    public boolean isVisibleTo(Node currentNode, RubyClass callerClass) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: {
                for (RubyModule ancestor : callerClass.ancestors()) {
                    if (ancestor != this.declaringModule && ancestor.getMetaClass() != this.declaringModule) continue;
                    return true;
                }
                return false;
            }
            case PRIVATE: {
                return false;
            }
        }
        throw new UnsupportedOperationException(this.visibility.name());
    }

    public String toString() {
        return this.sharedMethodInfo.toString();
    }
}

