/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.CoreLibrary;

public class StringFormatter {
    @CompilerDirectives.TruffleBoundary
    public static String format(RubyContext context, String format, List<Object> values2) {
        PrintStream printStream;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            printStream = new PrintStream((OutputStream)byteArray, false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        StringFormatter.format(context, printStream, format, values2);
        try {
            return byteArray.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void format(RubyContext context, PrintStream stream, String format, List<Object> values2) {
        int n = 0;
        int v = 0;
        while (n < format.length()) {
            char c = format.charAt(n);
            ++n;
            if (c == '%') {
                int lengthModifier;
                int precision;
                int width;
                String flagChars = "0";
                boolean zeroPad = false;
                while (n < format.length() && "0".indexOf(format.charAt(n)) != -1) {
                    switch (format.charAt(n)) {
                        case '0': {
                            zeroPad = true;
                            break;
                        }
                    }
                    ++n;
                }
                if (n < format.length() && Character.isDigit(format.charAt(n))) {
                    int widthStart = n;
                    while (Character.isDigit(format.charAt(n))) {
                        ++n;
                    }
                    width = Integer.parseInt(format.substring(widthStart, n));
                } else {
                    width = 0;
                }
                if (format.charAt(n) == '.') {
                    int precisionStart = ++n;
                    while (Character.isDigit(format.charAt(n))) {
                        ++n;
                    }
                    precision = Integer.parseInt(format.substring(precisionStart, n));
                } else {
                    precision = 5;
                }
                if (format.charAt(n) == ' ') {
                    int lengthStart = ++n;
                    while (Character.isDigit(format.charAt(n))) {
                        ++n;
                    }
                    lengthModifier = Integer.parseInt(format.substring(lengthStart, n));
                } else {
                    lengthModifier = 0;
                }
                char type2 = format.charAt(n);
                ++n;
                StringBuilder formatBuilder = new StringBuilder();
                formatBuilder.append("%");
                if (width > 0) {
                    if (zeroPad) {
                        formatBuilder.append("0");
                    }
                    formatBuilder.append(width);
                }
                switch (type2) {
                    case '%': {
                        stream.print("%");
                        break;
                    }
                    case 's': {
                        formatBuilder.append("s");
                        assert (formatBuilder.toString().equals("%s"));
                        stream.print(DebugOperations.send(context, values2.get(v), "to_s", null, new Object[0]));
                        break;
                    }
                    case 'X': 
                    case 'd': 
                    case 'x': {
                        long longValue;
                        if (lengthModifier != 0) {
                            formatBuilder.append(" ");
                            formatBuilder.append(lengthModifier);
                        }
                        formatBuilder.append(type2);
                        Object value2 = values2.get(v);
                        if (value2 instanceof Integer) {
                            longValue = ((Integer)value2).intValue();
                        } else if (value2 instanceof Long) {
                            longValue = (Long)value2;
                        } else {
                            throw new UnsupportedOperationException();
                        }
                        stream.printf(formatBuilder.toString(), longValue);
                        break;
                    }
                    case 'f': {
                        formatBuilder.append(".");
                        formatBuilder.append(precision);
                        formatBuilder.append("f");
                        double value3 = CoreLibrary.toDouble(values2.get(v));
                        stream.printf(formatBuilder.toString(), value3);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Kernel#sprintf error -- unknown format: " + type2);
                    }
                }
                if (type2 == '%') continue;
                ++v;
                continue;
            }
            stream.print(c);
        }
    }
}

