/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.RubyEncoding;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;

public class RubyString
extends RubyBasicObject
implements CodeRangeable {
    private ByteList bytes;

    public RubyString(RubyClass stringClass, ByteList bytes2) {
        super(stringClass);
        this.bytes = bytes2;
    }

    public static RubyString fromJavaString(RubyClass stringClass, String string2) {
        return new RubyString(stringClass, new ByteList(RubyEncoding.encodeUTF8(string2), USASCIIEncoding.INSTANCE, false));
    }

    public static RubyString fromJavaString(RubyClass stringClass, String string2, Encoding encoding2) {
        return new RubyString(stringClass, new ByteList(RubyEncoding.encodeUTF8(string2), encoding2, false));
    }

    public static RubyString fromByteList(RubyClass stringClass, ByteList bytes2) {
        return new RubyString(stringClass, bytes2);
    }

    public void set(ByteList bytes2) {
        this.bytes = bytes2;
    }

    public void forceEncoding(Encoding encoding2) {
        this.bytes.setEncoding(encoding2);
    }

    public ByteList getBytes() {
        return this.bytes;
    }

    public static String ljust(String string2, int length2, String padding) {
        StringBuilder builder = new StringBuilder();
        builder.append(string2);
        int n = 0;
        while (builder.length() < length2) {
            builder.append(padding.charAt(n));
            if (++n != padding.length()) continue;
            n = 0;
        }
        return builder.toString();
    }

    public static String rjust(String string2, int length2, String padding) {
        StringBuilder builder = new StringBuilder();
        int n = 0;
        while (builder.length() + string2.length() < length2) {
            builder.append(padding.charAt(n));
            if (++n != padding.length()) continue;
            n = 0;
        }
        builder.append(string2);
        return builder.toString();
    }

    public int count(RubyString[] otherStrings) {
        if (this.bytes.getRealSize() == 0) {
            return 0;
        }
        RubyString otherStr = otherStrings[0];
        Encoding enc = otherStr.getBytes().getEncoding();
        boolean[] table = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(otherStr.getBytes(), this.getContext().getRuntime(), table, null, true, enc);
        for (int i2 = 1; i2 < otherStrings.length; ++i2) {
            otherStr = otherStrings[i2];
            tables = StringSupport.trSetupTable(otherStr.getBytes(), this.getContext().getRuntime(), table, tables, false, enc);
        }
        return StringSupport.countCommon19(this.getBytes(), this.getContext().getRuntime(), table, tables, enc);
    }

    public RubyString dump() {
        ByteList outputBytes = StringSupport.dumpCommon(this.getContext().getRuntime(), this.bytes);
        RubyString result2 = this.getContext().makeString(outputBytes);
        return result2;
    }

    public boolean equals(Object other) {
        RubyNode.notDesignedForCompilation();
        if (other == this) {
            return true;
        }
        if (other instanceof String || other instanceof RubyString) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        RubyNode.notDesignedForCompilation();
        return Helpers.decodeByteList(this.getContext().getRuntime(), this.bytes);
    }

    public int hashCode() {
        RubyNode.notDesignedForCompilation();
        return this.bytes.hashCode();
    }

    public int length() {
        return StringSupport.strLengthFromRubyString(this);
    }

    public int normaliseIndex(int index2) {
        return RubyArray.normaliseIndex(this.bytes.length(), index2);
    }

    public int clampExclusiveIndex(int index2) {
        return RubyArray.clampExclusiveIndex(this.bytes.length(), index2);
    }

    @Override
    public int getCodeRange() {
        return 32;
    }

    @Override
    public int scanForCodeRange() {
        return this.getCodeRange();
    }

    @Override
    public boolean isCodeRangeValid() {
        return true;
    }

    @Override
    public final void setCodeRange(int codeRange) {
    }

    @Override
    public final void clearCodeRange() {
    }

    @Override
    public final void modify(int length2) {
        this.bytes.ensure(length2);
        this.bytes.invalidate();
    }

    @Override
    public Encoding checkEncoding(ByteListHolder other) {
        return this.bytes.getEncoding();
    }

    @Override
    public ByteList getByteList() {
        return this.bytes;
    }

    public static class StringAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyString(rubyClass, new ByteList());
        }
    }
}

