/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

public class RubyFile
extends RubyBasicObject {
    private final Reader reader;
    private final Writer writer;

    public RubyFile(RubyClass rubyClass, Reader reader, Writer writer) {
        super(rubyClass);
        this.reader = reader;
        this.writer = writer;
    }

    public void close() {
        RubyNode.notDesignedForCompilation();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String expandPath(String fileName) {
        return RubyFile.expandPath(fileName, null);
    }

    public static String expandPath(String fileName, String dir) {
        RubyNode.notDesignedForCompilation();
        try {
            return new File(dir, fileName).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RubyFile open(RubyContext context, String fileName, String mode2) {
        OutputStreamWriter writer;
        InputStreamReader reader;
        RubyNode.notDesignedForCompilation();
        if (mode2.equals("r") || mode2.equals("rb")) {
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            writer = null;
        } else if (mode2.equals("w") || mode2.equals("wb")) {
            reader = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else if (mode2.equals("a") || mode2.equals("ab")) {
            reader = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        RubyFile file2 = new RubyFile(context.getCoreLibrary().getFileClass(), reader, writer);
        return file2;
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }
}

