/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.nodes.ControlFlowException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.FiberManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class RubyFiber
extends RubyBasicObject {
    private final FiberManager fiberManager;
    private final ThreadManager threadManager;
    private BlockingQueue<FiberMessage> messageQueue = new ArrayBlockingQueue<FiberMessage>(1);
    public RubyFiber lastResumedByFiber = null;

    public RubyFiber(RubyClass rubyClass, FiberManager fiberManager, ThreadManager threadManager) {
        super(rubyClass);
        this.fiberManager = fiberManager;
        this.threadManager = threadManager;
    }

    public void initialize(RubyProc block) {
        RubyNode.notDesignedForCompilation();
        final RubyFiber finalFiber = this;
        final RubyProc finalBlock = block;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RubyFiber.this.fiberManager.registerFiber(finalFiber);
                try {
                    try {
                        Object arg2 = finalFiber.waitForResume();
                        Object result2 = finalBlock.rootCall(arg2);
                        finalFiber.lastResumedByFiber.resume(finalFiber, result2);
                    }
                    catch (FiberExitException fiberExitException) {
                        // empty catch block
                    }
                }
                finally {
                    RubyFiber.this.fiberManager.unregisterFiber(finalFiber);
                }
            }
        }).start();
    }

    public Object waitForResume() {
        RubyNode.notDesignedForCompilation();
        FiberMessage message2 = null;
        do {
            try {
                message2 = this.messageQueue.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (message2 == null);
        if (message2 instanceof FiberExitMessage) {
            throw new FiberExitException();
        }
        FiberResumeMessage resumeMessage = (FiberResumeMessage)message2;
        this.threadManager.enterGlobalLock(resumeMessage.getThread());
        this.fiberManager.setCurrentFiber(this);
        this.lastResumedByFiber = resumeMessage.getSendingFiber();
        return resumeMessage.getArg();
    }

    public void resume(RubyFiber sendingFiber, Object ... args2) {
        RubyNode.notDesignedForCompilation();
        Object arg2 = args2.length == 0 ? this.getContext().getCoreLibrary().getNilObject() : (args2.length == 1 ? args2[0] : RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), args2));
        RubyThread runningThread = this.threadManager.leaveGlobalLock();
        this.messageQueue.add(new FiberResumeMessage(runningThread, sendingFiber, arg2));
    }

    public void shutdown() {
        RubyNode.notDesignedForCompilation();
        this.messageQueue.add(new FiberExitMessage());
    }

    public static class FiberAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyFiber(rubyClass, context.getFiberManager(), context.getThreadManager());
        }
    }

    public static class FiberExitException
    extends ControlFlowException {
        private static final long serialVersionUID = 1522270454305076317L;
    }

    private static class FiberExitMessage
    implements FiberMessage {
        private FiberExitMessage() {
        }
    }

    private static class FiberResumeMessage
    implements FiberMessage {
        private final RubyThread thread;
        private final RubyFiber sendingFiber;
        private final Object arg;

        public FiberResumeMessage(RubyThread thread2, RubyFiber sendingFiber, Object arg2) {
            this.thread = thread2;
            this.sendingFiber = sendingFiber;
            this.arg = arg2;
        }

        public RubyThread getThread() {
            return this.thread;
        }

        public RubyFiber getSendingFiber() {
            return this.sendingFiber;
        }

        public Object getArg() {
            return this.arg;
        }
    }

    private static interface FiberMessage {
    }
}

