/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class RubyOperations
extends ObjectType {
    private final RubyContext context;

    public RubyOperations(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public void setInstanceVariable(RubyBasicObject receiver2, Object name2, Object value2) {
        Shape shape = receiver2.getDynamicObject().getShape();
        Property property = shape.getProperty(name2);
        if (property != null) {
            property.setGeneric(receiver2.getDynamicObject(), value2, null);
        } else {
            receiver2.getDynamicObject().define(name2, value2, 0);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setInstanceVariables(RubyBasicObject receiver2, Map<Object, Object> instanceVariables) {
        for (Map.Entry<Object, Object> entry : instanceVariables.entrySet()) {
            this.setInstanceVariable(receiver2, entry.getKey(), entry.getValue());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object getInstanceVariable(RubyBasicObject receiver2, Object name2) {
        Shape shape = receiver2.getDynamicObject().getShape();
        Property property = shape.getProperty(name2);
        if (property != null) {
            return property.get(receiver2.getDynamicObject(), false);
        }
        return this.context.getCoreLibrary().getNilObject();
    }

    @CompilerDirectives.TruffleBoundary
    public Map<Object, Object> getInstanceVariables(RubyBasicObject receiver2) {
        Shape shape = receiver2.getDynamicObject().getShape();
        LinkedHashMap<Object, Object> vars = new LinkedHashMap<Object, Object>();
        List<Property> properties = shape.getPropertyList();
        for (Property property : properties) {
            if (property.getKey() == RubyBasicObject.OBJECT_ID_IDENTIFIER) continue;
            vars.put((String)property.getKey(), property.get(receiver2.getDynamicObject(), false));
        }
        return vars;
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] getFieldNames(RubyBasicObject receiver2) {
        List<Object> keys2 = receiver2.getDynamicObject().getShape().getKeyList();
        return keys2.toArray(new Object[keys2.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isFieldDefined(RubyBasicObject receiver2, String name2) {
        return receiver2.getDynamicObject().getShape().hasProperty(name2);
    }

    @Override
    public boolean equals(DynamicObject dynamicObject, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode(DynamicObject dynamicObject) {
        throw new UnsupportedOperationException();
    }
}

