/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.BytesDecoder;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.TruffleHooks;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveManager;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyOperations;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.subsystems.AtExitManager;
import org.jruby.truffle.runtime.subsystems.FeatureManager;
import org.jruby.truffle.runtime.subsystems.FiberManager;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.subsystems.SafepointManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.truffle.runtime.subsystems.TraceManager;
import org.jruby.truffle.runtime.subsystems.Warnings;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.ByteList;

public class RubyContext
extends ExecutionContext {
    private final Ruby runtime;
    private final TranslatorDriver translator;
    private final CoreLibrary coreLibrary;
    private final FeatureManager featureManager;
    private final TraceManager traceManager;
    private final ObjectSpaceManager objectSpaceManager;
    private final ThreadManager threadManager;
    private final FiberManager fiberManager;
    private final AtExitManager atExitManager;
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable(this);
    private final Shape emptyShape;
    private final Warnings warnings;
    private final SafepointManager safepointManager;
    private final Random random = new Random();
    private final LexicalScope rootLexicalScope;
    private final CompilerOptions compilerOptions;
    private final RubiniusPrimitiveManager rubiniusPrimitiveManager;
    private final AtomicLong nextObjectID = new AtomicLong(6L);
    private final ThreadLocal<Queue<Object>> throwTags = new ThreadLocal<Queue<Object>>(){

        @Override
        protected Queue<Object> initialValue() {
            return new ArrayDeque<Object>();
        }
    };

    public RubyContext(Ruby runtime) {
        assert (runtime != null);
        this.compilerOptions = Truffle.getRuntime().createCompilerOptions();
        if (this.compilerOptions.supportsOption("MinTimeThreshold")) {
            this.compilerOptions.setOption("MinTimeThreshold", 100000000);
        }
        if (this.compilerOptions.supportsOption("MinInliningMaxCallerSize")) {
            this.compilerOptions.setOption("MinInliningMaxCallerSize", 5000);
        }
        this.safepointManager = new SafepointManager(this);
        this.runtime = runtime;
        this.translator = new TranslatorDriver();
        this.warnings = new Warnings(this);
        this.objectSpaceManager = new ObjectSpaceManager(this);
        this.emptyShape = RubyBasicObject.LAYOUT.createShape(new RubyOperations(this));
        this.coreLibrary = new CoreLibrary(this);
        this.coreLibrary.initialize();
        this.featureManager = new FeatureManager(this);
        this.traceManager = new TraceManager();
        this.atExitManager = new AtExitManager();
        this.threadManager = new ThreadManager(this);
        this.fiberManager = new FiberManager(this);
        this.rootLexicalScope = new LexicalScope(null, this.coreLibrary.getObjectClass());
        this.rubiniusPrimitiveManager = RubiniusPrimitiveManager.create();
    }

    public Shape getEmptyShape() {
        return this.emptyShape;
    }

    public static String checkInstanceVariableName(RubyContext context, String name2, RubyNode currentNode) {
        RubyNode.notDesignedForCompilation();
        if (!name2.startsWith("@")) {
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name2, currentNode));
        }
        return name2;
    }

    public static String checkClassVariableName(RubyContext context, String name2, RubyNode currentNode) {
        RubyNode.notDesignedForCompilation();
        if (!name2.startsWith("@@")) {
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name2, currentNode));
        }
        return name2;
    }

    public void loadFile(String fileName, RubyNode currentNode) {
        if (new File(fileName).isAbsolute()) {
            this.loadFileAbsolute(fileName, currentNode);
        } else {
            this.loadFileAbsolute(this.getRuntime().getCurrentDirectory() + File.separator + fileName, currentNode);
        }
    }

    private void loadFileAbsolute(String fileName, RubyNode currentNode) {
        byte[] bytes2;
        try {
            bytes2 = Files.readAllBytes(Paths.get(fileName, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Source source2 = Source.fromBytes(bytes2, fileName, new BytesDecoder.UTF8BytesDecoder());
        this.load(source2, currentNode, NodeWrapper.IDENTITY);
    }

    public void load(Source source2, RubyNode currentNode, final NodeWrapper nodeWrapper) {
        final NodeWrapper loadWrapper = new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), "load", node);
            }
        };
        NodeWrapper composed = new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return nodeWrapper.wrap(loadWrapper.wrap(node));
            }
        };
        this.execute(this, source2, UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.TOP_LEVEL, this.coreLibrary.getMainObject(), null, currentNode, composed);
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @CompilerDirectives.TruffleBoundary
    public org.jruby.truffle.runtime.core.RubySymbol newSymbol(String name2) {
        return this.symbolTable.getSymbol(name2);
    }

    @CompilerDirectives.TruffleBoundary
    public org.jruby.truffle.runtime.core.RubySymbol newSymbol(ByteList name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public Object eval(ByteList code, RubyNode currentNode) {
        Source source2 = Source.fromText(code, "(eval)");
        return this.execute(this, source2, code.getEncoding(), TranslatorDriver.ParserContext.TOP_LEVEL, this.coreLibrary.getMainObject(), null, currentNode, NodeWrapper.IDENTITY);
    }

    public Object eval(ByteList code, Object self2, RubyNode currentNode) {
        Source source2 = Source.fromText(code, "(eval)");
        return this.execute(this, source2, code.getEncoding(), TranslatorDriver.ParserContext.TOP_LEVEL, self2, null, currentNode, NodeWrapper.IDENTITY);
    }

    public Object eval(ByteList code, RubyBinding binding2, RubyNode currentNode) {
        Source source2 = Source.fromText(code, "(eval)");
        return this.execute(this, source2, code.getEncoding(), TranslatorDriver.ParserContext.TOP_LEVEL, binding2.getSelf(), binding2.getFrame(), currentNode, NodeWrapper.IDENTITY);
    }

    public Object execute(RubyContext context, Source source2, Encoding defaultEncoding, TranslatorDriver.ParserContext parserContext, Object self2, MaterializedFrame parentFrame, RubyNode currentNode, NodeWrapper wrapper) {
        RubyRootNode rootNode = this.translator.parse(context, source2, defaultEncoding, parserContext, parentFrame, currentNode, wrapper);
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
        return callTarget.call(RubyArguments.pack(null, parentFrame, self2, null, new Object[0]));
    }

    public long getNextObjectID() {
        long id2 = this.nextObjectID.getAndAdd(2L);
        if (id2 < 0L) {
            this.nextObjectID.set(Long.MIN_VALUE);
            throw new RuntimeException("Object IDs exhausted");
        }
        return id2;
    }

    public void shutdown() {
        this.atExitManager.run();
        this.threadManager.leaveGlobalLock();
        this.objectSpaceManager.shutdown();
        if (this.fiberManager != null) {
            this.fiberManager.shutdown();
        }
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(String string2) {
        return org.jruby.truffle.runtime.core.RubyString.fromJavaString(this.coreLibrary.getStringClass(), string2);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(String string2, Encoding encoding2) {
        return org.jruby.truffle.runtime.core.RubyString.fromJavaString(this.coreLibrary.getStringClass(), string2, encoding2);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(char string2) {
        return this.makeString(Character.toString(string2));
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(ByteList bytes2) {
        return org.jruby.truffle.runtime.core.RubyString.fromByteList(this.coreLibrary.getStringClass(), bytes2);
    }

    public IRubyObject toJRuby(Object object) {
        RubyNode.notDesignedForCompilation();
        if (object instanceof RubyNilClass) {
            return this.runtime.getNil();
        }
        if (object == this.getCoreLibrary().getKernelModule()) {
            return this.runtime.getKernel();
        }
        if (object == this.getCoreLibrary().getMainObject()) {
            return this.runtime.getTopSelf();
        }
        if (object instanceof Boolean) {
            return this.runtime.newBoolean((Boolean)object);
        }
        if (object instanceof Integer) {
            return this.runtime.newFixnum((Integer)object);
        }
        if (object instanceof Long) {
            return this.runtime.newFixnum((Long)object);
        }
        if (object instanceof Double) {
            return this.runtime.newFloat((Double)object);
        }
        if (object instanceof org.jruby.truffle.runtime.core.RubyString) {
            return this.toJRuby((org.jruby.truffle.runtime.core.RubyString)object);
        }
        if (object instanceof org.jruby.truffle.runtime.core.RubyArray) {
            return this.toJRuby((org.jruby.truffle.runtime.core.RubyArray)object);
        }
        throw this.getRuntime().newRuntimeError("cannot pass " + object + " to JRuby");
    }

    public RubyArray toJRuby(org.jruby.truffle.runtime.core.RubyArray array) {
        RubyNode.notDesignedForCompilation();
        Object[] objects = array.slowToArray();
        IRubyObject[] store = new IRubyObject[objects.length];
        for (int n = 0; n < objects.length; ++n) {
            store[n] = this.toJRuby(objects[n]);
        }
        return this.runtime.newArray(store);
    }

    public RubyString toJRuby(org.jruby.truffle.runtime.core.RubyString string2) {
        return this.runtime.newString(string2.getBytes().dup());
    }

    public Object toTruffle(IRubyObject object) {
        RubyNode.notDesignedForCompilation();
        if (object == this.runtime.getTopSelf()) {
            return this.getCoreLibrary().getMainObject();
        }
        if (object == this.runtime.getKernel()) {
            return this.getCoreLibrary().getKernelModule();
        }
        if (object instanceof RubyNil) {
            return this.getCoreLibrary().getNilObject();
        }
        if (object instanceof RubyBoolean.True) {
            return true;
        }
        if (object instanceof RubyBoolean.False) {
            return false;
        }
        if (object instanceof RubyFixnum) {
            long value2 = ((RubyFixnum)object).getLongValue();
            if (value2 < Integer.MIN_VALUE || value2 > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException();
            }
            return (int)value2;
        }
        if (object instanceof RubyFloat) {
            return ((RubyFloat)object).getDoubleValue();
        }
        if (object instanceof RubyString) {
            return this.toTruffle((RubyString)object);
        }
        if (object instanceof RubySymbol) {
            return this.getSymbolTable().getSymbol(object.toString());
        }
        if (object instanceof RubyArray) {
            RubyArray jrubyArray = (RubyArray)object;
            Object[] truffleArray = new Object[jrubyArray.size()];
            for (int n = 0; n < truffleArray.length; ++n) {
                truffleArray[n] = this.toTruffle((IRubyObject)jrubyArray.get(n));
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.coreLibrary.getArrayClass(), truffleArray, truffleArray.length);
        }
        throw object.getRuntime().newRuntimeError("cannot pass " + object.inspect() + " to Truffle");
    }

    public org.jruby.truffle.runtime.core.RubyString toTruffle(RubyString string2) {
        return new org.jruby.truffle.runtime.core.RubyString(this.getCoreLibrary().getStringClass(), string2.getByteList().dup());
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public CoreLibrary getCoreLibrary() {
        return this.coreLibrary;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public ObjectSpaceManager getObjectSpaceManager() {
        return this.objectSpaceManager;
    }

    public FiberManager getFiberManager() {
        return this.fiberManager;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public TranslatorDriver getTranslator() {
        return this.translator;
    }

    public AtExitManager getAtExitManager() {
        return this.atExitManager;
    }

    @Override
    public String getLanguageShortName() {
        return "ruby";
    }

    public TruffleHooks getHooks() {
        return (TruffleHooks)this.runtime.getInstanceConfig().getTruffleHooks();
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public Queue<Object> getThrowTags() {
        return this.throwTags.get();
    }

    public SafepointManager getSafepointManager() {
        return this.safepointManager;
    }

    public Random getRandom() {
        return this.random;
    }

    public LexicalScope getRootLexicalScope() {
        return this.rootLexicalScope;
    }

    @Override
    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public RubiniusPrimitiveManager getRubiniusPrimitiveManager() {
        return this.rubiniusPrimitiveManager;
    }
}

