/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.MethodLike;
import org.jruby.truffle.runtime.util.ArrayUtils;

public final class RubyArguments {
    public static final int METHOD_INDEX = 0;
    public static final int DECLARATION_FRAME_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int BLOCK_INDEX = 3;
    public static final int RUNTIME_ARGUMENT_COUNT = 4;

    public static Object[] pack(MethodLike method, MaterializedFrame declarationFrame, Object self2, RubyProc block, Object[] arguments) {
        Object[] packed = new Object[arguments.length + 4];
        packed[0] = method;
        packed[1] = declarationFrame;
        packed[2] = self2;
        packed[3] = block;
        RubyArguments.arraycopy(arguments, 0, packed, 4, arguments.length);
        return packed;
    }

    public static MethodLike getMethod(Object[] arguments) {
        return (MethodLike)arguments[0];
    }

    public static Object getSelf(Object[] arguments) {
        return arguments[2];
    }

    public static RubyProc getBlock(Object[] arguments) {
        return (RubyProc)arguments[3];
    }

    public static Object[] extractUserArguments(Object[] arguments) {
        return ArrayUtils.extractRange(arguments, 4, arguments.length);
    }

    public static Object[] concatUserArguments(Object o, Object[] arguments) {
        Object[] concatenatedArguments;
        if (o instanceof Object[]) {
            Object[] concatArray = (Object[])o;
            concatenatedArguments = new Object[concatArray.length + arguments.length - 4];
            RubyArguments.arraycopy(concatArray, 0, concatenatedArguments, 0, concatArray.length);
            RubyArguments.arraycopy(arguments, 4, concatenatedArguments, concatArray.length, RubyArguments.getUserArgumentsCount(arguments));
        } else {
            concatenatedArguments = new Object[1 + arguments.length - 4];
            concatenatedArguments[0] = o;
            RubyArguments.arraycopy(arguments, 4, concatenatedArguments, 1, RubyArguments.getUserArgumentsCount(arguments));
        }
        return concatenatedArguments;
    }

    public static int getUserArgumentsCount(Object[] internalArguments) {
        return internalArguments.length - 4;
    }

    public static Object getUserArgument(Object[] internalArguments, int index2) {
        return internalArguments[4 + index2];
    }

    public static MaterializedFrame getDeclarationFrame(Object[] arguments) {
        return (MaterializedFrame)arguments[1];
    }

    @ExplodeLoop
    public static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            dest[destPos + i2] = src[srcPos + i2];
        }
    }

    public static MaterializedFrame getDeclarationFrame(VirtualFrame frame, int level2) {
        assert (level2 > 0);
        MaterializedFrame parentFrame = RubyArguments.getDeclarationFrame(frame.getArguments());
        return RubyArguments.getDeclarationFrame(parentFrame, level2 - 1);
    }

    @ExplodeLoop
    private static MaterializedFrame getDeclarationFrame(MaterializedFrame frame, int level2) {
        assert (frame != null);
        assert (level2 >= 0);
        MaterializedFrame parentFrame = frame;
        for (int n = 0; n < level2; ++n) {
            parentFrame = RubyArguments.getDeclarationFrame(parentFrame.getArguments());
        }
        return parentFrame;
    }
}

