/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.RubyTime;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.TimeOperations;

class RubyTimeToDateTimeNode
extends Node {
    private final RubyContext context;
    @Node.Child
    private ReadHeadObjectFieldNode readIsGMTNode = new ReadHeadObjectFieldNode("@is_gmt");
    @Node.Child
    private ReadHeadObjectFieldNode readOffsetNode = new ReadHeadObjectFieldNode("@offset");

    public RubyTimeToDateTimeNode(RubyContext context, SourceSection sourceSection) {
        this.context = context;
    }

    public DateTime toDateTime(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyTime time) {
        Object isGMTObject = this.readIsGMTNode.execute(time);
        boolean isGMT = isGMTObject instanceof Boolean && (Boolean)isGMTObject != false;
        return this.toDateTime(time.getSeconds(), time.getNanoseconds(), isGMT, this.readOffsetNode.execute(time));
    }

    @CompilerDirectives.TruffleBoundary
    private DateTime toDateTime(long seconds, long nanoseconds, boolean isGMT, Object offset2) {
        DateTimeZone dateTimeZone = isGMT ? DateTimeZone.UTC : RubyTime.getLocalTimeZone(this.context.getRuntime());
        return new DateTime(TimeOperations.secondsAndNanosecondsToMiliseconds(seconds, nanoseconds), dateTimeZone);
    }
}

