/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.nodes.rubinius.FixnumPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.TimePrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.TypePrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.VMPrimitiveNodesFactory;

public class RubiniusPrimitiveManager {
    private final Map<String, RubiniusPrimitiveConstructor> primitives;

    private RubiniusPrimitiveManager(Map<String, RubiniusPrimitiveConstructor> primitives) {
        this.primitives = primitives;
    }

    public RubiniusPrimitiveConstructor getPrimitive(String name2) {
        RubiniusPrimitiveConstructor constructor2 = this.primitives.get(name2);
        if (constructor2 == null) {
            throw new RuntimeException(String.format("Rubinius primitive %s not found", name2));
        }
        return constructor2;
    }

    public static RubiniusPrimitiveManager create() {
        ArrayList<NodeFactory<RubiniusPrimitiveNode>> nodeFactories = new ArrayList<NodeFactory<RubiniusPrimitiveNode>>();
        nodeFactories.addAll(TimePrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(TypePrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(StringPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(VMPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(FixnumPrimitiveNodesFactory.getFactories());
        HashMap<String, RubiniusPrimitiveConstructor> primitives = new HashMap<String, RubiniusPrimitiveConstructor>();
        for (NodeFactory nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class<?> nodeClass = generatedBy.value();
            RubiniusPrimitive annotation2 = nodeClass.getAnnotation(RubiniusPrimitive.class);
            primitives.put(annotation2.name(), new RubiniusPrimitiveConstructor(annotation2, nodeFactory));
        }
        return new RubiniusPrimitiveManager(primitives);
    }
}

