/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyString;

public abstract class FixnumPrimitiveNodes {

    @RubiniusPrimitive(name="fixnum_coerce")
    public static abstract class FixnumCoercePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private DoesRespondDispatchHeadNode toFRespond;
        @Node.Child
        private CallDispatchHeadNode toF;

        public FixnumCoercePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toFRespond = new DoesRespondDispatchHeadNode(context, false, false, MissingBehavior.RETURN_MISSING, null);
            this.toF = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public FixnumCoercePrimitiveNode(FixnumCoercePrimitiveNode prev) {
            super(prev);
            this.toFRespond = prev.toFRespond;
            this.toF = prev.toF;
        }

        @Specialization
        public RubyArray coerce(int a, int b2) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new int[]{b2, a}, 2);
        }

        @Specialization
        public RubyArray coerce(int a, RubyString b2) {
            try {
                return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new double[]{Double.parseDouble(b2.toString()), a}, 2);
            }
            catch (NumberFormatException e) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("invalid value for Float", this));
            }
        }

        @Specialization(guards={"!isRubyString(arguments[1])", "!isRubyNilObject(arguments[1])"})
        public RubyArray coerce(VirtualFrame frame, int a, Object b2) {
            if (this.toFRespond.doesRespondTo(frame, "to_f", b2)) {
                Object bFloat = this.toF.call(frame, b2, "to_f", null, new Object[0]);
                if (bFloat instanceof Double) {
                    return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new double[]{(Double)bFloat, a}, 2);
                }
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("?", this));
            }
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("?", this));
        }
    }
}

