/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldNode;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class ReadLongObjectFieldNode
extends ReadObjectFieldChainNode {
    private final Shape objectLayout;
    private final LongLocation storageLocation;

    public ReadLongObjectFieldNode(Shape objectLayout, LongLocation storageLocation, ReadObjectFieldNode next2) {
        super(next2);
        this.objectLayout = objectLayout;
        this.storageLocation = storageLocation;
    }

    @Override
    public long executeLong(RubyBasicObject object) throws UnexpectedResultException {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.executeLong(object);
        }
        boolean bl = condition = object.getObjectLayout() == this.objectLayout;
        if (condition) {
            return this.storageLocation.getLong(object.getDynamicObject(), this.objectLayout);
        }
        return this.next.executeLong(object);
    }

    @Override
    public Object execute(RubyBasicObject object) {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.execute(object);
        }
        boolean bl = condition = object.getObjectLayout() == this.objectLayout;
        if (condition) {
            return this.storageLocation.get(object.getDynamicObject(), this.objectLayout);
        }
        return this.next.execute(object);
    }
}

