/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Iterator;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;

public class DefineOrGetModuleNode
extends RubyNode {
    protected final String name;
    @Node.Child
    private RubyNode lexicalParentModule;

    public DefineOrGetModuleNode(RubyContext context, SourceSection sourceSection, String name2, RubyNode lexicalParent) {
        super(context, sourceSection);
        this.name = name2;
        this.lexicalParentModule = lexicalParent;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyModule definingModule;
        DefineOrGetModuleNode.notDesignedForCompilation();
        RubyModule lexicalParent = this.getLexicalParentModule(frame);
        RubyConstant constant = this.lookupForExistingModule(frame, lexicalParent);
        if (constant == null) {
            definingModule = new RubyModule(this.getContext(), lexicalParent, this.name, this);
        } else {
            Object module = constant.getValue();
            if (!(module instanceof RubyModule) || !((RubyModule)module).isOnlyAModule()) {
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(this.name, "module", this));
            }
            definingModule = (RubyModule)module;
        }
        return definingModule;
    }

    protected RubyModule getLexicalParentModule(VirtualFrame frame) {
        RubyModule lexicalParent;
        try {
            lexicalParent = this.lexicalParentModule.executeRubyModule(frame);
        }
        catch (UnexpectedResultException e) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(e.getResult().toString(), "module", this));
        }
        return lexicalParent;
    }

    protected RubyConstant lookupForExistingModule(VirtualFrame frame, RubyModule lexicalParent) {
        RubyConstant constant = lexicalParent.getConstants().get(this.name);
        RubyClass objectClass = this.getContext().getCoreLibrary().getObjectClass();
        if (constant == null && lexicalParent == objectClass) {
            RubyModule included2;
            Iterator<RubyModule> i$ = objectClass.includedModules().iterator();
            while (i$.hasNext() && (constant = (included2 = i$.next()).getConstants().get(this.name)) == null) {
            }
        }
        if (constant != null && !constant.isVisibleTo(this.getContext(), LexicalScope.NONE, lexicalParent)) {
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateConstant(lexicalParent, this.name, this));
        }
        return constant;
    }
}

