/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=WriteLocalVariableNode.class)
public final class WriteLocalVariableNodeFactory
extends NodeFactoryBase<WriteLocalVariableNode> {
    private static WriteLocalVariableNodeFactory instance;

    private WriteLocalVariableNodeFactory() {
        super(WriteLocalVariableNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, FrameSlot.class, RubyNode.class}});
    }

    @Override
    public WriteLocalVariableNode createNode(Object ... arguments) {
        if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof FrameSlot) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
            return WriteLocalVariableNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (FrameSlot)arguments[2], (RubyNode)arguments[3]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static WriteLocalVariableNode create(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, RubyNode rhs) {
        return WriteLocalVariableUninitializedNode.create0(context, sourceSection, frameSlot, rhs);
    }

    public static NodeFactory<WriteLocalVariableNode> getInstance() {
        if (instance == null) {
            instance = new WriteLocalVariableNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class WriteLocalVariablePolymorphicNode
    extends WriteLocalVariableBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> rhsPolymorphicType;

        WriteLocalVariablePolymorphicNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object rhsValue;
            try {
                rhsValue = this.rhsPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.rhs.executeBoolean(frameValue)) : (this.rhsPolymorphicType == Integer.TYPE ? Integer.valueOf(this.rhs.executeIntegerFixnum(frameValue)) : (this.rhsPolymorphicType == Long.TYPE ? Long.valueOf(this.rhs.executeLongFixnum(frameValue)) : (this.rhsPolymorphicType == Double.TYPE ? Double.valueOf(this.rhs.executeFloat(frameValue)) : this.rhs.execute(frameValue))));
            }
            catch (UnexpectedResultException ex) {
                this.rhsPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.rhsPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            return this.next0.executeChained0(frameValue, rhsValue);
        }
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLocalVariableObjectNode
    extends WriteLocalVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLocalVariableObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        WriteLocalVariableObjectNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object rhsValue = this.rhs.execute(frameValue);
            if (super.isObjectKind()) {
                return super.doObject(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, rhsValue, "One of guards [isObjectKind] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (super.isObjectKind()) {
                return super.doObject(frameValue, rhsValue);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLocalVariableNode create0(WriteLocalVariableNode current2) {
            return new WriteLocalVariableObjectNode((WriteLocalVariableBaseNode)current2);
        }
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLocalVariableDoubleNode
    extends WriteLocalVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLocalVariableDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        WriteLocalVariableDoubleNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value2;
            try {
                value2 = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            double rhsValue;
            try {
                rhsValue = this.rhs.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof double"));
            }
            if (super.isFloatKind()) {
                return super.doFloat(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, rhsValue, "One of guards [isFloatKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(rhsValue) && super.isFloatKind()) {
                double rhsValueCast = RubyTypesGen.RUBYTYPES.asDouble(rhsValue);
                return super.doFloat(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLocalVariableNode create0(WriteLocalVariableNode current2) {
            return new WriteLocalVariableDoubleNode((WriteLocalVariableBaseNode)current2);
        }
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLocalVariableLongNode
    extends WriteLocalVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLocalVariableLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        WriteLocalVariableLongNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value2;
            try {
                value2 = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long rhsValue;
            try {
                rhsValue = this.rhs.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof long"));
            }
            if (super.isLongFixnumKind()) {
                return super.doLongFixnum(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, rhsValue, "One of guards [isLongFixnumKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(rhsValue) && super.isLongFixnumKind()) {
                long rhsValueCast = RubyTypesGen.RUBYTYPES.asLong(rhsValue);
                return super.doLongFixnum(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLocalVariableNode create0(WriteLocalVariableNode current2) {
            return new WriteLocalVariableLongNode((WriteLocalVariableBaseNode)current2);
        }
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLocalVariableIntNode
    extends WriteLocalVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLocalVariableIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        WriteLocalVariableIntNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value2;
            try {
                value2 = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int rhsValue;
            try {
                rhsValue = this.rhs.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof int"));
            }
            if (super.isFixnumKind()) {
                return super.doFixnum(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, rhsValue, "One of guards [isFixnumKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(rhsValue) && super.isFixnumKind()) {
                int rhsValueCast = RubyTypesGen.RUBYTYPES.asInteger(rhsValue);
                return super.doFixnum(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLocalVariableNode create0(WriteLocalVariableNode current2) {
            return new WriteLocalVariableIntNode((WriteLocalVariableBaseNode)current2);
        }
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLocalVariableBooleanNode
    extends WriteLocalVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLocalVariableBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        WriteLocalVariableBooleanNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value2;
            try {
                value2 = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean rhsValue;
            try {
                rhsValue = this.rhs.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof boolean"));
            }
            if (super.isBooleanKind()) {
                return super.doFixnum(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, rhsValue, "One of guards [isBooleanKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(rhsValue) && super.isBooleanKind()) {
                boolean rhsValueCast = RubyTypesGen.RUBYTYPES.asBoolean(rhsValue);
                return super.doFixnum(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLocalVariableNode create0(WriteLocalVariableNode current2) {
            return new WriteLocalVariableBooleanNode((WriteLocalVariableBaseNode)current2);
        }
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class WriteLocalVariableUninitializedNode
    extends WriteLocalVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLocalVariableUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        WriteLocalVariableUninitializedNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, RubyNode rhs) {
            super(context, sourceSection, frameSlot, rhs);
        }

        WriteLocalVariableUninitializedNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object rhsValue = this.rhs.execute(frameValue);
            return this.executeUninitialized0(frameValue, rhsValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, rhsValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object rhsValue) {
            WriteLocalVariableBaseNode newNode = this.specialize0(rhsValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                WriteLocalVariableBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.rhs}, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, rhsValue);
        }

        static WriteLocalVariableNode create0(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, RubyNode rhs) {
            return new WriteLocalVariableUninitializedNode(context, sourceSection, frameSlot, rhs);
        }
    }

    @GeneratedBy(value=WriteLocalVariableNode.class)
    private static abstract class WriteLocalVariableBaseNode
    extends WriteLocalVariableNode
    implements DSLNode {
        @Node.Child
        protected RubyNode rhs;
        @Node.Child
        protected WriteLocalVariableBaseNode next0;

        WriteLocalVariableBaseNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, RubyNode rhs) {
            super(context, sourceSection, frameSlot);
            this.rhs = rhs;
        }

        WriteLocalVariableBaseNode(WriteLocalVariableBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object rhsValue, String reason2) {
            String message2;
            WriteLocalVariableBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            WriteLocalVariableBaseNode newNode = this.specialize0(rhsValue);
            if (newNode == null) {
                newNode = new WriteLocalVariableUninitializedNode(this);
                ((WriteLocalVariableUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = WriteLocalVariableBaseNode.createInfo0(reason2, rhsValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new WriteLocalVariableUninitializedNode(this), new WriteLocalVariablePolymorphicNode(this), (WriteLocalVariableBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, rhsValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final WriteLocalVariableBaseNode specialize0(Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(rhsValue) && super.isBooleanKind()) {
                return (WriteLocalVariableBaseNode)WriteLocalVariableBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(rhsValue) && super.isFixnumKind()) {
                return (WriteLocalVariableBaseNode)WriteLocalVariableIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(rhsValue) && super.isLongFixnumKind()) {
                return (WriteLocalVariableBaseNode)WriteLocalVariableLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(rhsValue) && super.isFloatKind()) {
                return (WriteLocalVariableBaseNode)WriteLocalVariableDoubleNode.create0(this);
            }
            if (super.isObjectKind()) {
                return (WriteLocalVariableBaseNode)WriteLocalVariableObjectNode.create0(this);
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.rhs = other == null ? null : ((WriteLocalVariableBaseNode)other).rhs;
            this.next0 = newNext == null ? null : (WriteLocalVariableBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object rhsValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("rhsValue").append(" = ").append(rhsValue);
                if (rhsValue != null) {
                    builder.append(" (").append(rhsValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

