/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;

public class ReadKeywordArgumentNode
extends RubyNode {
    private final int minimum;
    private final String name;
    @Node.Child
    private RubyNode defaultValue;

    public ReadKeywordArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String name2, RubyNode defaultValue) {
        super(context, sourceSection);
        this.minimum = minimum;
        this.name = name2;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ReadKeywordArgumentNode.notDesignedForCompilation();
        RubyHash hash2 = this.getKeywordsHash(frame);
        if (hash2 == null) {
            return this.defaultValue.execute(frame);
        }
        Object value2 = null;
        for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
            if (!keyValue.getKey().toString().equals(this.name)) continue;
            value2 = keyValue.getValue();
            break;
        }
        if (value2 == null) {
            return this.defaultValue.execute(frame);
        }
        return value2;
    }

    private RubyHash getKeywordsHash(VirtualFrame frame) {
        if (RubyArguments.getUserArgumentsCount(frame.getArguments()) <= this.minimum) {
            return null;
        }
        Object lastArgument = RubyArguments.getUserArgument(frame.getArguments(), RubyArguments.getUserArgumentsCount(frame.getArguments()) - 1);
        if (lastArgument instanceof RubyHash) {
            return (RubyHash)lastArgument;
        }
        return null;
    }
}

