/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class MethodDefinitionNode
extends RubyNode {
    private final String name;
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTarget;
    private final boolean requiresDeclarationFrame;

    public MethodDefinitionNode(RubyContext context, SourceSection sourceSection, String name2, SharedMethodInfo sharedMethodInfo, boolean requiresDeclarationFrame, CallTarget callTarget) {
        super(context, sourceSection);
        this.name = name2;
        this.sharedMethodInfo = sharedMethodInfo;
        this.requiresDeclarationFrame = requiresDeclarationFrame;
        this.callTarget = callTarget;
    }

    public InternalMethod executeMethod(VirtualFrame frame) {
        MethodDefinitionNode.notDesignedForCompilation();
        MaterializedFrame declarationFrame = this.requiresDeclarationFrame ? frame.materialize() : null;
        return this.executeMethod(frame, declarationFrame);
    }

    public InternalMethod executeMethod(VirtualFrame frame, MaterializedFrame declarationFrame) {
        MethodDefinitionNode.notDesignedForCompilation();
        return new InternalMethod(this.sharedMethodInfo, this.name, null, null, false, this.callTarget, declarationFrame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeMethod(frame);
    }

    public String getName() {
        return this.name;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }
}

