/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.literal.RangeLiteralNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyRange;

@GeneratedBy(value=RangeLiteralNode.class)
public final class RangeLiteralNodeFactory
extends NodeFactoryBase<RangeLiteralNode> {
    private static RangeLiteralNodeFactory instance;

    private RangeLiteralNodeFactory() {
        super(RangeLiteralNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, Boolean.TYPE, RubyNode.class, RubyNode.class}});
    }

    @Override
    public RangeLiteralNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || !(arguments[2] instanceof Boolean) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return RangeLiteralNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (Boolean)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static RangeLiteralNode create(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin2, RubyNode end2) {
        return RangeLiteralUninitializedNode.create0(context, sourceSection, excludeEnd, begin2, end2);
    }

    public static NodeFactory<RangeLiteralNode> getInstance() {
        if (instance == null) {
            instance = new RangeLiteralNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class RangeLiteralPolymorphicNode
    extends RangeLiteralBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> beginPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> endPolymorphicType;

        RangeLiteralPolymorphicNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object endValue;
            Object beginValue;
            try {
                beginValue = this.beginPolymorphicType == Integer.TYPE ? Integer.valueOf(this.begin.executeIntegerFixnum(frameValue)) : (this.beginPolymorphicType == Long.TYPE ? Long.valueOf(this.begin.executeLongFixnum(frameValue)) : this.begin.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                Object endValue2 = this.end.execute(frameValue);
                this.beginPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult(), endValue2);
            }
            try {
                endValue = this.endPolymorphicType == Integer.TYPE ? Integer.valueOf(this.end.executeIntegerFixnum(frameValue)) : (this.endPolymorphicType == Long.TYPE ? Long.valueOf(this.end.executeLongFixnum(frameValue)) : this.end.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                this.endPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, beginValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, beginValue, endValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.beginPolymorphicType = types[0];
            this.endPolymorphicType = types[1];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            return this.next0.executeChained0(frameValue, beginValue, endValue);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class RangeLiteralObjectNode
    extends RangeLiteralBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(RangeLiteralObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

        RangeLiteralObjectNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object beginValue = this.begin.execute(frameValue);
            Object endValue = this.end.execute(frameValue);
            return super.doRange(beginValue, endValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            return super.doRange(beginValue, endValue);
        }

        static RangeLiteralNode create0(RangeLiteralNode current2) {
            return new RangeLiteralObjectNode((RangeLiteralBaseNode)current2);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class RangeLiteralLongFixnumRangeLongLongNode
    extends RangeLiteralBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(RangeLiteralLongFixnumRangeLongLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

        RangeLiteralLongFixnumRangeLongLongNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyRange.LongFixnumRange value2;
            try {
                value2 = this.executeLongFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            long endValue;
            long beginValue;
            try {
                beginValue = this.begin.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue2 = this.end.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.rewrite0(frameValue, ex.getResult(), endValue2, "Expected beginValue instanceof long"));
            }
            try {
                endValue = this.end.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.rewrite0(frameValue, beginValue, ex.getResult(), "Expected endValue instanceof long"));
            }
            return super.doRange(beginValue, endValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(beginValue) && RubyTypesGen.RUBYTYPES.isLong(endValue)) {
                long beginValueCast = RubyTypesGen.RUBYTYPES.asLong(beginValue);
                long endValueCast = RubyTypesGen.RUBYTYPES.asLong(endValue);
                return super.doRange(beginValueCast, endValueCast);
            }
            return this.next0.executeChained0(frameValue, beginValue, endValue);
        }

        static RangeLiteralNode create0(RangeLiteralNode current2) {
            return new RangeLiteralLongFixnumRangeLongLongNode((RangeLiteralBaseNode)current2);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class RangeLiteralLongFixnumRangeLongIntNode
    extends RangeLiteralBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(RangeLiteralLongFixnumRangeLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

        RangeLiteralLongFixnumRangeLongIntNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyRange.LongFixnumRange value2;
            try {
                value2 = this.executeLongFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            int endValue;
            long beginValue;
            try {
                beginValue = this.begin.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue2 = this.end.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.rewrite0(frameValue, ex.getResult(), endValue2, "Expected beginValue instanceof long"));
            }
            try {
                endValue = this.end.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.rewrite0(frameValue, beginValue, ex.getResult(), "Expected endValue instanceof int"));
            }
            return super.doRange(beginValue, endValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(beginValue) && RubyTypesGen.RUBYTYPES.isInteger(endValue)) {
                long beginValueCast = RubyTypesGen.RUBYTYPES.asLong(beginValue);
                int endValueCast = RubyTypesGen.RUBYTYPES.asInteger(endValue);
                return super.doRange(beginValueCast, endValueCast);
            }
            return this.next0.executeChained0(frameValue, beginValue, endValue);
        }

        static RangeLiteralNode create0(RangeLiteralNode current2) {
            return new RangeLiteralLongFixnumRangeLongIntNode((RangeLiteralBaseNode)current2);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class RangeLiteralLongFixnumRangeIntLongNode
    extends RangeLiteralBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(RangeLiteralLongFixnumRangeIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

        RangeLiteralLongFixnumRangeIntLongNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyRange.LongFixnumRange value2;
            try {
                value2 = this.executeLongFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            long endValue;
            int beginValue;
            try {
                beginValue = this.begin.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue2 = this.end.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.rewrite0(frameValue, ex.getResult(), endValue2, "Expected beginValue instanceof int"));
            }
            try {
                endValue = this.end.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.rewrite0(frameValue, beginValue, ex.getResult(), "Expected endValue instanceof long"));
            }
            return super.doRange(beginValue, endValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(beginValue) && RubyTypesGen.RUBYTYPES.isLong(endValue)) {
                int beginValueCast = RubyTypesGen.RUBYTYPES.asInteger(beginValue);
                long endValueCast = RubyTypesGen.RUBYTYPES.asLong(endValue);
                return super.doRange(beginValueCast, endValueCast);
            }
            return this.next0.executeChained0(frameValue, beginValue, endValue);
        }

        static RangeLiteralNode create0(RangeLiteralNode current2) {
            return new RangeLiteralLongFixnumRangeIntLongNode((RangeLiteralBaseNode)current2);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class RangeLiteralIntegerFixnumRangeIntIntNode
    extends RangeLiteralBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(RangeLiteralIntegerFixnumRangeIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

        RangeLiteralIntegerFixnumRangeIntIntNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyRange.IntegerFixnumRange value2;
            try {
                value2 = this.executeIntegerFixnumRange(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frameValue) throws UnexpectedResultException {
            int endValue;
            int beginValue;
            try {
                beginValue = this.begin.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue2 = this.end.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectIntegerFixnumRange(this.rewrite0(frameValue, ex.getResult(), endValue2, "Expected beginValue instanceof int"));
            }
            try {
                endValue = this.end.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectIntegerFixnumRange(this.rewrite0(frameValue, beginValue, ex.getResult(), "Expected endValue instanceof int"));
            }
            return super.doRange(beginValue, endValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(beginValue) && RubyTypesGen.RUBYTYPES.isInteger(endValue)) {
                int beginValueCast = RubyTypesGen.RUBYTYPES.asInteger(beginValue);
                int endValueCast = RubyTypesGen.RUBYTYPES.asInteger(endValue);
                return super.doRange(beginValueCast, endValueCast);
            }
            return this.next0.executeChained0(frameValue, beginValue, endValue);
        }

        static RangeLiteralNode create0(RangeLiteralNode current2) {
            return new RangeLiteralIntegerFixnumRangeIntIntNode((RangeLiteralBaseNode)current2);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class RangeLiteralUninitializedNode
    extends RangeLiteralBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(RangeLiteralUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

        RangeLiteralUninitializedNode(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin2, RubyNode end2) {
            super(context, sourceSection, excludeEnd, begin2, end2);
        }

        RangeLiteralUninitializedNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object beginValue = this.begin.execute(frameValue);
            Object endValue = this.end.execute(frameValue);
            return this.executeUninitialized0(frameValue, beginValue, endValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeUninitialized0(frameValue, beginValue, endValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object beginValue, Object endValue) {
            RangeLiteralBaseNode newNode = this.specialize0(beginValue, endValue);
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, beginValue, endValue);
        }

        static RangeLiteralNode create0(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin2, RubyNode end2) {
            return new RangeLiteralUninitializedNode(context, sourceSection, excludeEnd, begin2, end2);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    private static abstract class RangeLiteralBaseNode
    extends RangeLiteralNode
    implements DSLNode {
        @Node.Child
        protected RubyNode begin;
        @Node.Child
        protected RubyNode end;
        @Node.Child
        protected RangeLiteralBaseNode next0;

        RangeLiteralBaseNode(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin2, RubyNode end2) {
            super(context, sourceSection, excludeEnd);
            this.begin = begin2;
            this.end = end2;
        }

        RangeLiteralBaseNode(RangeLiteralBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

        protected final Object rewrite0(VirtualFrame frameValue, Object beginValue, Object endValue, String reason2) {
            String message2;
            RangeLiteralBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            RangeLiteralBaseNode newNode = this.specialize0(beginValue, endValue);
            if (newNode == null) {
                newNode = new RangeLiteralUninitializedNode(this);
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = RangeLiteralBaseNode.createInfo0(reason2, beginValue, endValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new RangeLiteralUninitializedNode(this), new RangeLiteralPolymorphicNode(this), (RangeLiteralBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, beginValue, endValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final RangeLiteralBaseNode specialize0(Object beginValue, Object endValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(beginValue)) {
                if (RubyTypesGen.RUBYTYPES.isInteger(endValue)) {
                    return (RangeLiteralBaseNode)RangeLiteralIntegerFixnumRangeIntIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(endValue)) {
                    return (RangeLiteralBaseNode)RangeLiteralLongFixnumRangeIntLongNode.create0(this);
                }
            }
            if (RubyTypesGen.RUBYTYPES.isLong(beginValue)) {
                if (RubyTypesGen.RUBYTYPES.isInteger(endValue)) {
                    return (RangeLiteralBaseNode)RangeLiteralLongFixnumRangeLongIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(endValue)) {
                    return (RangeLiteralBaseNode)RangeLiteralLongFixnumRangeLongLongNode.create0(this);
                }
            }
            return (RangeLiteralBaseNode)RangeLiteralObjectNode.create0(this);
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.begin = null;
                this.end = null;
            } else {
                RangeLiteralBaseNode otherCast = (RangeLiteralBaseNode)other;
                this.begin = otherCast.begin;
                this.end = otherCast.end;
            }
            this.next0 = newNext == null ? null : (RangeLiteralBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object beginValue, Object endValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("beginValue").append(" = ").append(beginValue);
                if (beginValue != null) {
                    builder.append(" (").append(beginValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("endValue").append(" = ").append(endValue);
                if (endValue != null) {
                    builder.append(" (").append(endValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

