/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayAllocationSite;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

public abstract class ArrayLiteralNode
extends RubyNode {
    @Node.Children
    protected final RubyNode[] values;

    public ArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values2) {
        super(context, sourceSection);
        this.values = values2;
    }

    protected RubyArray makeGeneric(VirtualFrame frame, Object[] alreadyExecuted) {
        CompilerAsserts.neverPartOfCompilation();
        this.replace(new ObjectArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
        Object[] executedValues = new Object[this.values.length];
        for (int n = 0; n < this.values.length; ++n) {
            executedValues[n] = n < alreadyExecuted.length ? alreadyExecuted[n] : this.values[n].execute(frame);
        }
        return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), executedValues);
    }

    @Override
    public abstract RubyArray executeArray(VirtualFrame var1);

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (RubyNode value2 : this.values) {
            value2.executeVoid(frame);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeArray(frame);
    }

    @Override
    @ExplodeLoop
    public Object isDefined(VirtualFrame frame) {
        for (RubyNode value2 : this.values) {
            if (value2.isDefined(frame) != this.getContext().getCoreLibrary().getNilObject()) continue;
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return super.isDefined(frame);
    }

    public RubyNode[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public static class UninitialisedArrayLiteralNode
    extends ArrayLiteralNode {
        public UninitialisedArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values2) {
            super(context, sourceSection, values2);
        }

        @Override
        @ExplodeLoop
        public RubyArray executeArray(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            RubyArray array = RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), executedValues);
            Object store = array.getStore();
            if (store == null) {
                this.replace(new EmptyArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            }
            if (store instanceof int[]) {
                this.replace(new IntegerFixnumArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else if (store instanceof long[]) {
                this.replace(new LongFixnumArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else if (store instanceof double[]) {
                this.replace(new FloatArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else {
                this.replace(new ObjectArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            }
            return array;
        }
    }

    public static class ObjectArrayLiteralNode
    extends ArrayLiteralNode {
        public ObjectArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values2) {
            super(context, sourceSection, values2);
        }

        @Override
        @ExplodeLoop
        public RubyArray executeArray(VirtualFrame frame) {
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), executedValues, this.values.length);
        }
    }

    public static class LongFixnumArrayLiteralNode
    extends ArrayLiteralNode {
        public LongFixnumArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values2) {
            super(context, sourceSection, values2);
        }

        @Override
        @ExplodeLoop
        public RubyArray executeArray(VirtualFrame frame) {
            long[] executedValues = new long[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeLongFixnum(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), executedValues, this.values.length);
        }

        private RubyArray makeGeneric(VirtualFrame frame, long[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i2 = 0; i2 < n; ++i2) {
                executedObjects[i2] = executedValues[i2];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    public static class IntegerFixnumArrayLiteralNode
    extends ArrayLiteralNode {
        private final ArrayAllocationSite arrayAllocationSite = new ArrayAllocationSite();

        public IntegerFixnumArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values2) {
            super(context, sourceSection, values2);
        }

        @Override
        @ExplodeLoop
        public RubyArray executeArray(VirtualFrame frame) {
            if (this.arrayAllocationSite.hasConvertedIntToLong()) {
                long[] executedValues = new long[this.values.length];
                for (int n = 0; n < this.values.length; ++n) {
                    try {
                        executedValues[n] = this.values[n].executeLongFixnum(frame);
                        continue;
                    }
                    catch (UnexpectedResultException e) {
                        return this.makeGeneric(frame, executedValues, n);
                    }
                }
                return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayAllocationSite, executedValues, this.values.length);
            }
            int[] executedValues = new int[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeIntegerFixnum(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayAllocationSite, executedValues, this.values.length);
        }

        private RubyArray makeGeneric(VirtualFrame frame, int[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i2 = 0; i2 < n; ++i2) {
                executedObjects[i2] = executedValues[i2];
            }
            return this.makeGeneric(frame, executedObjects);
        }

        private RubyArray makeGeneric(VirtualFrame frame, long[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i2 = 0; i2 < n; ++i2) {
                executedObjects[i2] = executedValues[i2];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    public static class FloatArrayLiteralNode
    extends ArrayLiteralNode {
        public FloatArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values2) {
            super(context, sourceSection, values2);
        }

        @Override
        @ExplodeLoop
        public RubyArray executeArray(VirtualFrame frame) {
            double[] executedValues = new double[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeFloat(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), executedValues, this.values.length);
        }

        private RubyArray makeGeneric(VirtualFrame frame, double[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i2 = 0; i2 < n; ++i2) {
                executedObjects[i2] = executedValues[i2];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    public static class EmptyArrayLiteralNode
    extends ArrayLiteralNode {
        public EmptyArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values2) {
            super(context, sourceSection, values2);
        }

        @Override
        public RubyArray executeArray(VirtualFrame frame) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }
    }
}

