/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.HashSearchResult;

public class FindEntryNode
extends RubyNode {
    @Node.Child
    CallDispatchHeadNode hashNode;
    @Node.Child
    CallDispatchHeadNode eqlNode;

    public FindEntryNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
    }

    public HashSearchResult search(VirtualFrame frame, RubyHash hash2, Object key2) {
        int hashed;
        Object hashValue = this.hashNode.call(frame, key2, "hash", null, new Object[0]);
        if (hashValue instanceof Integer) {
            hashed = (Integer)hashValue;
        } else if (hashValue instanceof Long) {
            hashed = (int)((Long)hashValue).longValue();
        } else {
            throw new UnsupportedOperationException();
        }
        Entry[] entries2 = (Entry[])hash2.getStore();
        int index2 = HashOperations.getIndex(hashed, entries2.length);
        Entry previousEntry = null;
        for (Entry entry = entries2[index2]; entry != null; entry = entry.getNextInLookup()) {
            if (this.eqlNode.callBoolean(frame, key2, "eql?", null, entry.getKey())) {
                return new HashSearchResult(index2, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashSearchResult(index2, previousEntry, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

