/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.globals.GetFromThreadLocalNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=GetFromThreadLocalNode.class)
public final class GetFromThreadLocalNodeFactory
extends NodeFactoryBase<GetFromThreadLocalNode> {
    private static GetFromThreadLocalNodeFactory instance;

    private GetFromThreadLocalNodeFactory() {
        super(GetFromThreadLocalNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    @Override
    public GetFromThreadLocalNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return GetFromThreadLocalNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static GetFromThreadLocalNode create(RubyContext context, SourceSection sourceSection, RubyNode value2) {
        return GetFromThreadLocalUninitializedNode.create0(context, sourceSection, value2);
    }

    public static NodeFactory<GetFromThreadLocalNode> getInstance() {
        if (instance == null) {
            instance = new GetFromThreadLocalNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=GetFromThreadLocalNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class GetFromThreadLocalPolymorphicNode
    extends GetFromThreadLocalBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> valuePolymorphicType;

        GetFromThreadLocalPolymorphicNode(GetFromThreadLocalBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object valueValue;
            try {
                valueValue = this.valuePolymorphicType == ThreadLocal.class ? RubyTypesGen.RUBYTYPES.expectThreadLocal(this.value.execute(frameValue)) : this.value.execute(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.valuePolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, valueValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.valuePolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object valueValue) {
            return this.next0.executeChained0(frameValue, valueValue);
        }
    }

    @GeneratedBy(value=GetFromThreadLocalNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class GetFromThreadLocalObjectNode
    extends GetFromThreadLocalBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GetFromThreadLocalObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        GetFromThreadLocalObjectNode(GetFromThreadLocalBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object valueValue = this.value.execute(frameValue);
            if (!super.isThreadLocal(valueValue)) {
                return super.get(valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, valueValue, "One of guards [!isThreadLocal] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object valueValue) {
            if (!super.isThreadLocal(valueValue)) {
                return super.get(valueValue);
            }
            return this.next0.executeChained0(frameValue, valueValue);
        }

        static GetFromThreadLocalNode create0(GetFromThreadLocalNode current2) {
            return new GetFromThreadLocalObjectNode((GetFromThreadLocalBaseNode)current2);
        }
    }

    @GeneratedBy(value=GetFromThreadLocalNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class GetFromThreadLocalThreadLocalNode
    extends GetFromThreadLocalBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GetFromThreadLocalThreadLocalNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ThreadLocal.class}, 0, 0);

        GetFromThreadLocalThreadLocalNode(GetFromThreadLocalBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            ThreadLocal valueValue;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectThreadLocal(this.value.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected valueValue instanceof ThreadLocal");
            }
            return super.get(valueValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isThreadLocal(valueValue)) {
                ThreadLocal valueValueCast = RubyTypesGen.RUBYTYPES.asThreadLocal(valueValue);
                return super.get(valueValueCast);
            }
            return this.next0.executeChained0(frameValue, valueValue);
        }

        static GetFromThreadLocalNode create0(GetFromThreadLocalNode current2) {
            return new GetFromThreadLocalThreadLocalNode((GetFromThreadLocalBaseNode)current2);
        }
    }

    @GeneratedBy(value=GetFromThreadLocalNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class GetFromThreadLocalUninitializedNode
    extends GetFromThreadLocalBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GetFromThreadLocalUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        GetFromThreadLocalUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode value2) {
            super(context, sourceSection, value2);
        }

        GetFromThreadLocalUninitializedNode(GetFromThreadLocalBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object valueValue = this.value.execute(frameValue);
            return this.executeUninitialized0(frameValue, valueValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object valueValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, valueValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object valueValue) {
            GetFromThreadLocalBaseNode newNode = this.specialize0(valueValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                GetFromThreadLocalBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.value}, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, valueValue);
        }

        static GetFromThreadLocalNode create0(RubyContext context, SourceSection sourceSection, RubyNode value2) {
            return new GetFromThreadLocalUninitializedNode(context, sourceSection, value2);
        }
    }

    @GeneratedBy(value=GetFromThreadLocalNode.class)
    private static abstract class GetFromThreadLocalBaseNode
    extends GetFromThreadLocalNode
    implements DSLNode {
        @Node.Child
        protected RubyNode value;
        @Node.Child
        protected GetFromThreadLocalBaseNode next0;

        GetFromThreadLocalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode value2) {
            super(context, sourceSection);
            this.value = value2;
        }

        GetFromThreadLocalBaseNode(GetFromThreadLocalBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object valueValue, String reason2) {
            String message2;
            GetFromThreadLocalBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            GetFromThreadLocalBaseNode newNode = this.specialize0(valueValue);
            if (newNode == null) {
                newNode = new GetFromThreadLocalUninitializedNode(this);
                ((GetFromThreadLocalUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = GetFromThreadLocalBaseNode.createInfo0(reason2, valueValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new GetFromThreadLocalUninitializedNode(this), new GetFromThreadLocalPolymorphicNode(this), (GetFromThreadLocalBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, valueValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final GetFromThreadLocalBaseNode specialize0(Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isThreadLocal(valueValue)) {
                return (GetFromThreadLocalBaseNode)GetFromThreadLocalThreadLocalNode.create0(this);
            }
            if (!super.isThreadLocal(valueValue)) {
                return (GetFromThreadLocalBaseNode)GetFromThreadLocalObjectNode.create0(this);
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.value = other == null ? null : ((GetFromThreadLocalBaseNode)other).value;
            this.next0 = newNext == null ? null : (GetFromThreadLocalBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object valueValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("valueValue").append(" = ").append(valueValue);
                if (valueValue != null) {
                    builder.append(" (").append(valueValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

