/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.conversion.ToJavaStringNode;
import org.jruby.truffle.nodes.conversion.ToJavaStringNodeFactory;
import org.jruby.truffle.nodes.conversion.ToSymbolNode;
import org.jruby.truffle.nodes.conversion.ToSymbolNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class UncachedDispatchNode
extends DispatchNode {
    private final boolean ignoreVisibility;
    @Node.Child
    private IndirectCallNode callNode;
    @Node.Child
    private ToSymbolNode toSymbolNode;
    @Node.Child
    private ToJavaStringNode toJavaStringNode;
    private final BranchProfile constantMissingProfile = BranchProfile.create();
    private final BranchProfile methodMissingProfile = BranchProfile.create();

    public UncachedDispatchNode(RubyContext context, boolean ignoreVisibility, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        this.ignoreVisibility = ignoreVisibility;
        this.callNode = Truffle.getRuntime().createIndirectCallNode();
        this.toSymbolNode = ToSymbolNodeFactory.create(context, null, null);
        this.toJavaStringNode = ToJavaStringNodeFactory.create(context, null, null);
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object name2, Object blockObject, Object argumentsObjects) {
        DispatchAction dispatchAction = this.getDispatchAction();
        if (dispatchAction == DispatchAction.READ_CONSTANT) {
            RubyConstant constant = this.lookupConstant((RubyModule)receiverObject, this.toJavaStringNode.executeJavaString(frame, name2), this.ignoreVisibility);
            if (constant != null) {
                return constant.getValue();
            }
            this.constantMissingProfile.enter();
            RubyClass callerClass = this.ignoreVisibility ? null : this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
            InternalMethod missingMethod = this.lookup(callerClass, receiverObject, "const_missing", this.ignoreVisibility);
            if (missingMethod == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #const_missing", this));
            }
            return this.callNode.call(frame, missingMethod.getCallTarget(), RubyArguments.pack(missingMethod, missingMethod.getDeclarationFrame(), receiverObject, null, new Object[]{this.toSymbolNode.executeRubySymbol(frame, name2)}));
        }
        RubyClass callerClass = this.ignoreVisibility ? null : this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        InternalMethod method = this.lookup(callerClass, receiverObject, this.toJavaStringNode.executeJavaString(frame, name2), this.ignoreVisibility);
        if (method != null) {
            if (dispatchAction == DispatchAction.CALL_METHOD) {
                return this.callNode.call(frame, method.getCallTarget(), RubyArguments.pack(method, method.getDeclarationFrame(), receiverObject, (RubyProc)blockObject, CompilerDirectives.unsafeCast(argumentsObjects, Object[].class, true)));
            }
            if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
                return true;
            }
            throw new UnsupportedOperationException();
        }
        this.methodMissingProfile.enter();
        InternalMethod missingMethod = this.lookup(callerClass, receiverObject, "method_missing", true);
        if (missingMethod == null) {
            if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
                return false;
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #method_missing", this));
        }
        if (dispatchAction == DispatchAction.CALL_METHOD) {
            Object[] argumentsObjectsArray = CompilerDirectives.unsafeCast(argumentsObjects, Object[].class, true);
            Object[] modifiedArgumentsObjects = new Object[1 + argumentsObjectsArray.length];
            modifiedArgumentsObjects[0] = this.toSymbolNode.executeRubySymbol(frame, name2);
            RubyArguments.arraycopy(argumentsObjectsArray, 0, modifiedArgumentsObjects, 1, argumentsObjectsArray.length);
            return this.callNode.call(frame, missingMethod.getCallTarget(), RubyArguments.pack(missingMethod, missingMethod.getDeclarationFrame(), receiverObject, (RubyProc)blockObject, modifiedArgumentsObjects));
        }
        if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
            return false;
        }
        throw new UnsupportedOperationException();
    }
}

