/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.ast.Node;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Truffle::Debug")
public abstract class TruffleDebugNodes {

    @CoreMethod(names={"tree"}, onSingleton=true)
    public static abstract class TreeNode
    extends CoreMethodNode {
        public TreeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TreeNode(TreeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString tree() {
            TreeNode.notDesignedForCompilation();
            return this.getContext().makeString(NodeUtil.printCompactTreeToString(Truffle.getRuntime().getCallerFrame().getCallNode().getRootNode()));
        }
    }

    @CoreMethod(names={"parse_tree"}, onSingleton=true)
    public static abstract class ParseTreeNode
    extends CoreMethodNode {
        public ParseTreeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ParseTreeNode(ParseTreeNode prev) {
            super(prev);
        }

        @Specialization
        public Object parseTree() {
            ParseTreeNode.notDesignedForCompilation();
            Node parseTree = RubyCallStack.getCallingMethod().getSharedMethodInfo().getParseTree();
            if (parseTree == null) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return this.getContext().makeString(parseTree.toString(true, 0));
        }
    }

    @CoreMethod(names={"panic"}, onSingleton=true)
    public static abstract class PanicNode
    extends CoreMethodNode {
        public PanicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PanicNode(PanicNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass doPanic() {
            DebugOperations.panic(this.getContext(), this, null);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodNode {
        public JavaClassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public JavaClassOfNode(JavaClassOfNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString javaClassOf(Object value2) {
            JavaClassOfNode.notDesignedForCompilation();
            return this.getContext().makeString(value2.getClass().getName());
        }
    }

    @CoreMethod(names={"full_tree"}, onSingleton=true)
    public static abstract class FullTreeNode
    extends CoreMethodNode {
        public FullTreeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FullTreeNode(FullTreeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString fullTree() {
            FullTreeNode.notDesignedForCompilation();
            return this.getContext().makeString(NodeUtil.printTreeToString(Truffle.getRuntime().getCallerFrame().getCallNode().getRootNode()));
        }
    }

    @CoreMethod(names={"flush_stdout"}, onSingleton=true)
    public static abstract class FlushStdoutNode
    extends CoreMethodNode {
        public FlushStdoutNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FlushStdoutNode(FlushStdoutNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass flush() {
            this.getContext().getRuntime().getOut().flush();
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"dump_call_stack"}, onSingleton=true)
    public static abstract class DumpCallStackNode
    extends CoreMethodNode {
        public DumpCallStackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DumpCallStackNode(DumpCallStackNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass dumpCallStack() {
            DumpCallStackNode.notDesignedForCompilation();
            for (String line : Backtrace.DEBUG_FORMATTER.format(this.getContext(), null, RubyCallStack.getBacktrace(this))) {
                System.err.println(line);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }
}

