/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.ast.ArgsNode;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="Proc")
public abstract class ProcNodes {

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodNode {
        public ParametersNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ParametersNode(ParametersNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyArray parameters(RubyProc proc) {
            ArgsNode argsNode = proc.getSharedMethodInfo().getParseTree().findFirstChild(ArgsNode.class);
            String[] parameters2 = Helpers.encodeParameterList(argsNode).split(";");
            return (RubyArray)this.getContext().toTruffle(Helpers.parameterListToParameters(this.getContext().getRuntime(), parameters2, proc.getType() == RubyProc.Type.LAMBDA));
        }
    }

    @CoreMethod(names={"lambda?"})
    public static abstract class LambdaNode
    extends CoreMethodNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LambdaNode(LambdaNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lambda(RubyProc proc) {
            return proc.getType() == RubyProc.Type.LAMBDA;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyProc proc, RubyProc block) {
            proc.initialize(block.getSharedMethodInfo(), block.getCallTargetForProcs(), block.getCallTargetForProcs(), block.getCallTargetForMethods(), block.getDeclarationFrame(), block.getDeclaringModule(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"call", "[]"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class CallNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        public CallNode(CallNode prev) {
            super(prev);
            this.yieldNode = prev.yieldNode;
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyProc proc, Object[] args2, UndefinedPlaceholder block) {
            return this.yieldNode.dispatch(frame, proc, args2);
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyProc proc, Object[] args2, RubyProc block) {
            return this.yieldNode.dispatchWithModifiedBlock(frame, proc, block, args2);
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BindingNode(BindingNode prev) {
            super(prev);
        }

        @Specialization
        public Object binding(RubyProc proc) {
            if (!RubyProc.PROC_BINDING) {
                this.getContext().getWarnings().warn("Proc#binding disabled, returning nil. Use -Xtruffle.proc.binding=true to enable it.");
                return this.getContext().getCoreLibrary().getNilObject();
            }
            MaterializedFrame frame = proc.getDeclarationFrame();
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ArityNode(ArityNode prev) {
            super(prev);
        }

        @Specialization
        public int arity(RubyProc proc) {
            return 1;
        }
    }
}

