/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=MethodNodes.class)
public final class MethodNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(CallNodeFactory.getInstance(), NameNodeFactory.getInstance());
    }

    @GeneratedBy(value=MethodNodes.NameNode.class)
    public static final class NameNodeFactory
    extends NodeFactoryBase<MethodNodes.NameNode> {
        private static NameNodeFactory nameNodeFactoryInstance;

        private NameNodeFactory() {
            super(MethodNodes.NameNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MethodNodes.NameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NameNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.NameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NameUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.NameNode> getInstance() {
            if (nameNodeFactoryInstance == null) {
                nameNodeFactoryInstance = new NameNodeFactory();
            }
            return nameNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NamePolymorphicNode
        extends NameBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NamePolymorphicNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NameRubyMethodNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            NameRubyMethodNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.name(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.name(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.NameNode create0(MethodNodes.NameNode current2) {
                return new NameRubyMethodNode((NameBaseNode)current2);
            }
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NameUninitializedNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NameUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NameUninitializedNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NameBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.NameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NameUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        private static abstract class NameBaseNode
        extends MethodNodes.NameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NameBaseNode next0;

            NameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NameBaseNode(NameBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                NameBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NameUninitializedNode(this);
                    ((NameUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = NameBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new NameUninitializedNode(this), new NamePolymorphicNode(this), (NameBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NameBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (NameBaseNode)NameRubyMethodNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NameBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NameBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.CallNode.class)
    public static final class CallNodeFactory
    extends NodeFactoryBase<MethodNodes.CallNode> {
        private static CallNodeFactory callNodeFactoryInstance;

        private CallNodeFactory() {
            super(MethodNodes.CallNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MethodNodes.CallNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CallNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.CallNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CallUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.CallNode> getInstance() {
            if (callNodeFactoryInstance == null) {
                callNodeFactoryInstance = new CallNodeFactory();
            }
            return callNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CallPolymorphicNode
        extends CallBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            CallPolymorphicNode(CallBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CallRubyMethodNode
        extends CallBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class, Object[].class}, 0, 0);

            CallRubyMethodNode(CallBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMethod");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.call(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.call(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MethodNodes.CallNode create0(MethodNodes.CallNode current2) {
                return new CallRubyMethodNode((CallBaseNode)current2);
            }
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CallUninitializedNode
        extends CallBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CallUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CallUninitializedNode(CallBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CallBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CallBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MethodNodes.CallNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CallUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        private static abstract class CallBaseNode
        extends MethodNodes.CallNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CallBaseNode next0;

            CallBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CallBaseNode(CallBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CallBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CallBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CallUninitializedNode(this);
                    ((CallUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = CallBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new CallUninitializedNode(this), new CallPolymorphicNode(this), (CallBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CallBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (CallBaseNode)CallRubyMethodNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CallBaseNode otherCast = (CallBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CallBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

