/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyMath;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.dispatch.UseMethodMissingException;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;

@CoreClass(name="Math")
public abstract class MathNodes {

    protected static abstract class SimpleDyadicMathNode
    extends CoreMethodNode {
        @Node.Child
        protected KernelNodes.IsANode isANode;
        @Node.Child
        protected CallDispatchHeadNode floatANode;
        @Node.Child
        protected CallDispatchHeadNode floatBNode;

        protected SimpleDyadicMathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.floatANode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
            this.floatBNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        protected SimpleDyadicMathNode(SimpleDyadicMathNode prev) {
            super(prev);
            this.isANode = prev.isANode;
            this.floatANode = prev.floatANode;
            this.floatBNode = prev.floatBNode;
        }

        protected double doFunction(double a, double b2) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double function(int a, int b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(int a, long b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(int a, RubyBignum b2) {
            return this.doFunction(a, b2.doubleValue());
        }

        @Specialization
        public double function(int a, double b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(long a, int b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(long a, long b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(long a, RubyBignum b2) {
            return this.doFunction(a, b2.doubleValue());
        }

        @Specialization
        public double function(long a, double b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(RubyBignum a, int b2) {
            return this.doFunction(a.doubleValue(), b2);
        }

        @Specialization
        public double function(RubyBignum a, long b2) {
            return this.doFunction(a.doubleValue(), b2);
        }

        @Specialization
        public double function(RubyBignum a, RubyBignum b2) {
            return this.doFunction(a.doubleValue(), b2.doubleValue());
        }

        @Specialization
        public double function(RubyBignum a, double b2) {
            return this.doFunction(a.doubleValue(), b2);
        }

        @Specialization
        public double function(double a, int b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(double a, long b2) {
            return this.doFunction(a, b2);
        }

        @Specialization
        public double function(double a, RubyBignum b2) {
            return this.doFunction(a, b2.doubleValue());
        }

        @Specialization
        public double function(double a, double b2) {
            return this.doFunction(a, b2);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a, Object b2) {
            if (this.isANode.executeIsA(frame, a, this.getContext().getCoreLibrary().getNumericClass()) && this.isANode.executeIsA(frame, b2, this.getContext().getCoreLibrary().getNumericClass())) {
                try {
                    return this.doFunction(this.floatANode.callFloat(frame, a, "to_f", null, new Object[0]), this.floatBNode.callFloat(frame, b2, "to_f", null, new Object[0]));
                }
                catch (UseMethodMissingException e) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
        }
    }

    protected static abstract class SimpleMonadicMathNode
    extends CoreMethodNode {
        @Node.Child
        private KernelNodes.IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatNode;

        protected SimpleMonadicMathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.floatNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        protected SimpleMonadicMathNode(SimpleMonadicMathNode prev) {
            super(prev);
            this.isANode = prev.isANode;
            this.floatNode = prev.floatNode;
        }

        protected double doFunction(double a) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double function(int a) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(long a) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(RubyBignum a) {
            return this.doFunction(a.doubleValue());
        }

        @Specialization
        public double function(double a) {
            return this.doFunction(a);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a) {
            if (this.isANode.executeIsA(frame, a, this.getContext().getCoreLibrary().getNumericClass())) {
                try {
                    return this.doFunction(this.floatNode.callFloat(frame, a, "to_f", null, new Object[0]));
                }
                catch (UseMethodMissingException e) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
        }
    }

    @CoreMethod(names={"sqrt"}, isModuleFunction=true, required=1)
    public static abstract class SqrtNode
    extends SimpleMonadicMathNode {
        public SqrtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SqrtNode(SqrtNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.sqrt(a);
        }
    }

    @CoreMethod(names={"tanh"}, isModuleFunction=true, required=1)
    public static abstract class TanHNode
    extends SimpleMonadicMathNode {
        public TanHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TanHNode(TanHNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.tanh(a);
        }
    }

    @CoreMethod(names={"tan"}, isModuleFunction=true, required=1)
    public static abstract class TanNode
    extends SimpleMonadicMathNode {
        public TanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TanNode(TanNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.tan(a);
        }
    }

    @CoreMethod(names={"sinh"}, isModuleFunction=true, required=1)
    public static abstract class SinHNode
    extends SimpleMonadicMathNode {
        public SinHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SinHNode(SinHNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.sinh(a);
        }
    }

    @CoreMethod(names={"sin"}, isModuleFunction=true, required=1)
    public static abstract class SinNode
    extends SimpleMonadicMathNode {
        public SinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SinNode(SinNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.sin(a);
        }
    }

    @CoreMethod(names={"log2"}, isModuleFunction=true, required=1)
    public static abstract class Log2Node
    extends SimpleMonadicMathNode {
        private final double LOG2 = Math.log(2.0);

        public Log2Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public Log2Node(Log2Node prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log2", this));
            }
            return Math.log(a) / this.LOG2;
        }
    }

    @CoreMethod(names={"log10"}, isModuleFunction=true, required=1)
    public static abstract class Log10Node
    extends SimpleMonadicMathNode {
        public Log10Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public Log10Node(Log10Node prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log10", this));
            }
            return Math.log10(a);
        }
    }

    @CoreMethod(names={"log"}, isModuleFunction=true, required=1, optional=1)
    public static abstract class LogNode
    extends SimpleDyadicMathNode {
        public LogNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LogNode(LogNode prev) {
            super(prev);
        }

        @Specialization
        public double function(int a, UndefinedPlaceholder b2) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(long a, UndefinedPlaceholder b2) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(RubyBignum a, UndefinedPlaceholder b2) {
            return this.doFunction(a.doubleValue());
        }

        @Specialization
        public double function(double a, UndefinedPlaceholder b2) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(VirtualFrame frame, Object a, UndefinedPlaceholder b2) {
            if (this.isANode.executeIsA(frame, a, this.getContext().getCoreLibrary().getNumericClass())) {
                try {
                    return this.doFunction(this.floatANode.callFloat(frame, a, "to_f", null, new Object[0]));
                }
                catch (UseMethodMissingException e) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
        }

        private double doFunction(double a) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log", this));
            }
            return Math.log(a);
        }

        @Override
        protected double doFunction(double a, double b2) {
            if (a < 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log", this));
            }
            return Math.log(a) / Math.log(b2);
        }
    }

    @CoreMethod(names={"lgamma"}, isModuleFunction=true, required=1)
    public static abstract class LGammaNode
    extends CoreMethodNode {
        @Node.Child
        private KernelNodes.IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatNode;

        public LGammaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.floatNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        public LGammaNode(LGammaNode prev) {
            super(prev);
            this.isANode = prev.isANode;
            this.floatNode = prev.floatNode;
        }

        @Specialization
        public RubyArray lgamma(int a) {
            return this.lgamma((double)a);
        }

        @Specialization
        public RubyArray lgamma(long a) {
            return this.lgamma((double)a);
        }

        @Specialization
        public RubyArray lgamma(RubyBignum a) {
            return this.lgamma(a.doubleValue());
        }

        @Specialization
        public RubyArray lgamma(double a) {
            if (a < 0.0 && Double.isInfinite(a)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("log2", this));
            }
            RubyMath.NemesLogGamma l = new RubyMath.NemesLogGamma(a);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{l.value, l.sign}, 2);
        }

        @Fallback
        public RubyArray lgamma(VirtualFrame frame, Object a) {
            if (this.isANode.executeIsA(frame, a, this.getContext().getCoreLibrary().getNumericClass())) {
                try {
                    return this.lgamma(this.floatNode.callFloat(frame, a, "to_f", null, new Object[0]));
                }
                catch (UseMethodMissingException e) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
        }
    }

    @CoreMethod(names={"ldexp"}, isModuleFunction=true, required=2)
    public static abstract class LdexpNode
    extends CoreMethodNode {
        @Node.Child
        private KernelNodes.IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatANode;
        @Node.Child
        private CallDispatchHeadNode integerBNode;

        protected LdexpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.floatANode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
            this.integerBNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        protected LdexpNode(LdexpNode prev) {
            super(prev);
            this.isANode = prev.isANode;
            this.floatANode = prev.floatANode;
            this.integerBNode = prev.integerBNode;
        }

        @Specialization
        public double function(int a, int b2) {
            return this.function((double)a, b2);
        }

        @Specialization
        public double function(int a, long b2) {
            return this.function((double)a, b2);
        }

        @Specialization
        public double function(int a, double b2) {
            return this.function((double)a, b2);
        }

        @Specialization
        public double function(long a, int b2) {
            return this.function((double)a, b2);
        }

        @Specialization
        public double function(long a, long b2) {
            return this.function((double)a, b2);
        }

        @Specialization
        public double function(long a, double b2) {
            return this.function((double)a, b2);
        }

        @Specialization
        public double function(RubyBignum a, int b2) {
            return this.function(a.doubleValue(), b2);
        }

        @Specialization
        public double function(RubyBignum a, long b2) {
            return this.function(a.doubleValue(), b2);
        }

        @Specialization
        public double function(RubyBignum a, double b2) {
            return this.function(a.doubleValue(), b2);
        }

        @Specialization
        public double function(double a, int b2) {
            return this.function(a, (double)b2);
        }

        @Specialization
        public double function(double a, long b2) {
            return this.function(a, (double)b2);
        }

        @Specialization
        public double function(double a, double b2) {
            if (Double.isNaN(b2)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError("float", Double.toString(b2), "integer", this));
            }
            return a * Math.pow(2.0, b2);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a, Object b2) {
            if (this.isANode.executeIsA(frame, a, this.getContext().getCoreLibrary().getNumericClass())) {
                try {
                    return this.function(this.floatANode.callFloat(frame, a, "to_f", null, new Object[0]), this.integerBNode.callLongFixnum(frame, b2, "to_int", null, new Object[0]));
                }
                catch (UseMethodMissingException e) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getIntegerClass().getName(), (Node)this));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
        }
    }

    @CoreMethod(names={"hypot"}, isModuleFunction=true, required=2)
    public static abstract class HypotNode
    extends SimpleDyadicMathNode {
        public HypotNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HypotNode(HypotNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a, double b2) {
            return Math.hypot(a, b2);
        }
    }

    @CoreMethod(names={"gamma"}, isModuleFunction=true, required=1)
    public static abstract class GammaNode
    extends SimpleMonadicMathNode {
        public GammaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GammaNode(GammaNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            if (a == -1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("gamma", this));
            }
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (Double.isInfinite(a)) {
                if (a > 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("gamma", this));
            }
            double result2 = RubyMath.nemes_gamma(a);
            if (Double.isInfinite(result2)) {
                result2 = a < 0.0 ? Double.NaN : (a == 0.0 && 1.0 / a < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (Double.isNaN(a)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("gamma", this));
            }
            return result2;
        }
    }

    @CoreMethod(names={"frexp"}, isModuleFunction=true, required=1)
    public static abstract class FrExpNode
    extends CoreMethodNode {
        @Node.Child
        private KernelNodes.IsANode isANode;
        @Node.Child
        private CallDispatchHeadNode floatNode;

        public FrExpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.floatNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        }

        public FrExpNode(FrExpNode prev) {
            super(prev);
            this.isANode = prev.isANode;
            this.floatNode = prev.floatNode;
        }

        @Specialization
        public RubyArray frexp(int a) {
            return this.frexp((double)a);
        }

        @Specialization
        public RubyArray frexp(long a) {
            return this.frexp((double)a);
        }

        @Specialization
        public RubyArray frexp(RubyBignum a) {
            return this.frexp(a.doubleValue());
        }

        @Specialization
        public RubyArray frexp(double a) {
            double mantissa = a;
            int sign2 = 1;
            long exponent2 = 0L;
            if (!Double.isInfinite(mantissa) && mantissa != 0.0) {
                if (mantissa < 0.0) {
                    mantissa = -mantissa;
                    sign2 = -1;
                }
                while (mantissa < 0.5) {
                    mantissa *= 2.0;
                    --exponent2;
                }
                while (mantissa >= 1.0) {
                    mantissa *= 0.5;
                    ++exponent2;
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{(double)sign2 * mantissa, exponent2}, 2);
        }

        @Fallback
        public RubyArray frexp(VirtualFrame frame, Object a) {
            if (this.isANode.executeIsA(frame, a, this.getContext().getCoreLibrary().getNumericClass())) {
                try {
                    return this.frexp(this.floatNode.callFloat(frame, a, "to_f", null, new Object[0]));
                }
                catch (UseMethodMissingException e) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(a).getName(), this.getContext().getCoreLibrary().getFloatClass().getName(), (Node)this));
        }
    }

    @CoreMethod(names={"exp"}, isModuleFunction=true, required=1)
    public static abstract class ExpNode
    extends SimpleMonadicMathNode {
        public ExpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExpNode(ExpNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.exp(a);
        }
    }

    @CoreMethod(names={"erfc"}, isModuleFunction=true, required=1)
    public static abstract class ErfcNode
    extends SimpleMonadicMathNode {
        public ErfcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ErfcNode(ErfcNode prev) {
            super(prev);
        }

        @Override
        public double doFunction(double a) {
            return ErfcNode.erfc(a);
        }

        public static double erfc(double a) {
            double y = Math.abs(a);
            if (a <= -6.013687357) {
                return 2.0;
            }
            if (y < 1.49012E-8) {
                return 1.0 - 2.0 * a / 1.772453850905516;
            }
            double ysq = y * y;
            if (y < 1.0) {
                return 1.0 - a * (1.0 + RubyMath.chebylevSerie(2.0 * ysq - 1.0, RubyMath.ERFC_COEF));
            }
            if (y <= 4.0) {
                double result2 = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie((8.0 / ysq - 5.0) / 3.0, RubyMath.ERFC2_COEF));
                if (a < 0.0) {
                    result2 = 2.0 - result2;
                }
                if (a < 0.0) {
                    result2 = 2.0 - result2;
                }
                if (a < 0.0) {
                    result2 = 2.0 - result2;
                }
                return result2;
            }
            double result3 = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie(8.0 / ysq - 1.0, RubyMath.ERFCC_COEF));
            if (a < 0.0) {
                result3 = 2.0 - result3;
            }
            return result3;
        }
    }

    @CoreMethod(names={"erf"}, isModuleFunction=true, required=1)
    public static abstract class ErfNode
    extends SimpleMonadicMathNode {
        public ErfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ErfNode(ErfNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            double y = Math.abs(a);
            if (y <= 1.49012E-8) {
                return 2.0 * a / 1.772453850905516;
            }
            if (y <= 1.0) {
                return a * (1.0 + RubyMath.chebylevSerie(2.0 * a * a - 1.0, RubyMath.ERFC_COEF));
            }
            if (y < 6.013687357) {
                return RubyMath.sign(1.0 - ErfcNode.erfc(y), a);
            }
            if (Double.isNaN(y)) {
                return Double.NaN;
            }
            return RubyMath.sign(1.0, a);
        }
    }

    @CoreMethod(names={"cosh"}, isModuleFunction=true, required=1)
    public static abstract class CosHNode
    extends SimpleMonadicMathNode {
        public CosHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CosHNode(CosHNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.cosh(a);
        }
    }

    @CoreMethod(names={"cos"}, isModuleFunction=true, required=1)
    public static abstract class CosNode
    extends SimpleMonadicMathNode {
        public CosNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CosNode(CosNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.cos(a);
        }
    }

    @CoreMethod(names={"cbrt"}, isModuleFunction=true, required=1)
    public static abstract class CbRtNode
    extends SimpleMonadicMathNode {
        public CbRtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CbRtNode(CbRtNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.cbrt(a);
        }
    }

    @CoreMethod(names={"atanh"}, isModuleFunction=true, required=1)
    public static abstract class ATanHNode
    extends SimpleMonadicMathNode {
        public ATanHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ATanHNode(ATanHNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("atanh", this));
            }
            double y = Math.abs(a);
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (y < 1.82501E-8) {
                return a;
            }
            if (y <= 0.5) {
                return a * (1.0 + RubyMath.chebylevSerie(8.0 * a * a - 1.0, RubyMath.ATANH_COEF));
            }
            if (y < 1.0) {
                return 0.5 * Math.log((1.0 + a) / (1.0 - a));
            }
            if (y == 1.0) {
                return a * Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
    }

    @CoreMethod(names={"atan2"}, isModuleFunction=true, required=2)
    public static abstract class ATan2Node
    extends SimpleDyadicMathNode {
        public ATan2Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ATan2Node(ATan2Node prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a, double b2) {
            return Math.atan2(a, b2);
        }
    }

    @CoreMethod(names={"atan"}, isModuleFunction=true, required=1)
    public static abstract class ATanNode
    extends SimpleMonadicMathNode {
        public ATanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ATanNode(ATanNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            return Math.atan(a);
        }
    }

    @CoreMethod(names={"asinh"}, isModuleFunction=true, required=1)
    public static abstract class ASinHNode
    extends SimpleMonadicMathNode {
        public ASinHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ASinHNode(ASinHNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            double y = Math.abs(a);
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (y <= 1.05367E-8) {
                return a;
            }
            if (y <= 1.0) {
                return a * (1.0 + RubyMath.chebylevSerie(2.0 * a * a - 1.0, RubyMath.ASINH_COEF));
            }
            if (y < 9.490626562E7) {
                return Math.log(a + Math.sqrt(a * a + 1.0));
            }
            double result2 = 0.6931471805599453 + Math.log(y);
            if (a < 0.0) {
                result2 *= -1.0;
            }
            return result2;
        }
    }

    @CoreMethod(names={"asin"}, isModuleFunction=true, required=1)
    public static abstract class ASinNode
    extends SimpleMonadicMathNode {
        public ASinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ASinNode(ASinNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("asin", this));
            }
            return Math.asin(a);
        }
    }

    @CoreMethod(names={"acosh"}, isModuleFunction=true, required=1)
    public static abstract class ACosHNode
    extends SimpleMonadicMathNode {
        public ACosHNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ACosHNode(ACosHNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (a < 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("acosh", this));
            }
            if (a < 9.490626562E7) {
                return Math.log(a + Math.sqrt(a * a - 1.0));
            }
            return 0.6931471805599453 + Math.log(a);
        }
    }

    @CoreMethod(names={"acos"}, isModuleFunction=true, required=1)
    public static abstract class ACosNode
    extends SimpleMonadicMathNode {
        public ACosNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ACosNode(ACosNode prev) {
            super(prev);
        }

        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().mathDomainError("acos", this));
            }
            return Math.acos(a);
        }
    }
}

