/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;

@CoreClass(name="main")
public abstract class MainNodes {

    @CoreMethod(names={"private"}, argumentsAsArray=true, needsSelf=false, visibility=Visibility.PRIVATE)
    public static abstract class PrivateNode
    extends CoreMethodNode {
        @Node.Child
        private ModuleNodes.PrivateNode privateNode;

        public PrivateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.privateNode = ModuleNodesFactory.PrivateNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public PrivateNode(PrivateNode prev) {
            super(prev);
            this.privateNode = prev.privateNode;
        }

        @Specialization
        public RubyModule doPrivate(VirtualFrame frame, Object[] args2) {
            PrivateNode.notDesignedForCompilation();
            RubyClass object = this.getContext().getCoreLibrary().getObjectClass();
            return this.privateNode.executePrivate(frame, object, args2);
        }
    }

    @CoreMethod(names={"public"}, argumentsAsArray=true, needsSelf=false, visibility=Visibility.PRIVATE)
    public static abstract class PublicNode
    extends CoreMethodNode {
        @Node.Child
        private ModuleNodes.PublicNode publicNode;

        public PublicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.publicNode = ModuleNodesFactory.PublicNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public PublicNode(PublicNode prev) {
            super(prev);
            this.publicNode = prev.publicNode;
        }

        @Specialization
        public RubyModule doPublic(VirtualFrame frame, Object[] args2) {
            PublicNode.notDesignedForCompilation();
            RubyClass object = this.getContext().getCoreLibrary().getObjectClass();
            return this.publicNode.executePublic(frame, object, args2);
        }
    }
}

