/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.ToSNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.runtime.RubyContext;

public final class InterpolatedStringNode
extends RubyNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private KernelNodes.TaintedNode taintedNode;
    @Node.Child
    private KernelNodes.TaintNode taintNode;
    private final ConditionProfile taintProfile = ConditionProfile.createCountingProfile();

    public InterpolatedStringNode(RubyContext context, SourceSection sourceSection, ToSNode[] children) {
        super(context, sourceSection);
        this.children = children;
        this.taintedNode = KernelNodesFactory.TaintedNodeFactory.create(context, sourceSection, new RubyNode[0]);
        this.taintNode = KernelNodesFactory.TaintNodeFactory.create(context, sourceSection, new RubyNode[0]);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        org.jruby.truffle.runtime.core.RubyString[] strings = new org.jruby.truffle.runtime.core.RubyString[this.children.length];
        boolean tainted = false;
        for (int n = 0; n < this.children.length; ++n) {
            org.jruby.truffle.runtime.core.RubyString toInterpolate;
            strings[n] = toInterpolate = this.children[n].executeRubyString(frame);
            tainted |= this.taintedNode.tainted(toInterpolate);
        }
        org.jruby.truffle.runtime.core.RubyString string2 = this.concat(strings);
        if (this.taintProfile.profile(tainted)) {
            this.taintNode.taint(string2);
        }
        return string2;
    }

    @CompilerDirectives.TruffleBoundary
    private org.jruby.truffle.runtime.core.RubyString concat(org.jruby.truffle.runtime.core.RubyString[] strings) {
        RubyString builder = null;
        for (org.jruby.truffle.runtime.core.RubyString string2 : strings) {
            if (builder == null) {
                builder = this.getContext().toJRuby(string2);
                continue;
            }
            try {
                builder.append19(this.getContext().toJRuby(string2));
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityErrorIncompatible(builder.getEncoding().getCharsetName(), string2.getBytes().getEncoding().getCharsetName(), this));
            }
        }
        return this.getContext().toTruffle(builder);
    }
}

