/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyRange;

public class FixnumLowerNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenInteger = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenLong = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenIntegerRange = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenLongRange = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenUndefined = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasNeededToLowerLongFixnum = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasNeededToLowerLongFixnumRange = false;

    public FixnumLowerNode(RubyNode child) {
        super(child.getContext(), child.getEncapsulatingSourceSection());
        this.child = child;
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frame) throws UnexpectedResultException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value2 = this.child.execute(frame);
        if (this.hasSeenInteger && value2 instanceof Integer) {
            return value2;
        }
        if (this.hasSeenLong && value2 instanceof Long) {
            if (FixnumLowerNode.canLower((Long)value2)) {
                return FixnumLowerNode.lower((Long)value2);
            }
            return value2;
        }
        if (this.hasSeenIntegerRange && value2 instanceof RubyRange.IntegerFixnumRange) {
            return value2;
        }
        if (this.hasSeenLongRange && value2 instanceof RubyRange.LongFixnumRange) {
            if (FixnumLowerNode.canLower((RubyRange.LongFixnumRange)value2)) {
                return FixnumLowerNode.lower((RubyRange.LongFixnumRange)value2);
            }
            return value2;
        }
        if (this.hasSeenUndefined && value2 instanceof UndefinedPlaceholder) {
            return value2;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (value2 instanceof Integer) {
            this.hasSeenInteger = true;
            return value2;
        }
        if (value2 instanceof Long) {
            this.hasSeenLong = true;
            if (FixnumLowerNode.canLower((Long)value2)) {
                return FixnumLowerNode.lower((Long)value2);
            }
            return value2;
        }
        if (value2 instanceof RubyRange.IntegerFixnumRange) {
            this.hasSeenIntegerRange = true;
            return value2;
        }
        if (value2 instanceof RubyRange.LongFixnumRange) {
            this.hasSeenLongRange = true;
            if (FixnumLowerNode.canLower((RubyRange.LongFixnumRange)value2)) {
                return FixnumLowerNode.lower((RubyRange.LongFixnumRange)value2);
            }
            return value2;
        }
        if (value2 instanceof UndefinedPlaceholder) {
            this.hasSeenUndefined = true;
            return value2;
        }
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(value2, this.getContext().getCoreLibrary().getIntegerClass(), (Node)this));
    }

    @Override
    public int executeIntegerFixnum(VirtualFrame frame) throws UnexpectedResultException {
        try {
            if (this.hasNeededToLowerLongFixnum) {
                long value2 = super.executeLongFixnum(frame);
                if (FixnumLowerNode.canLower(value2)) {
                    return FixnumLowerNode.lower(value2);
                }
                throw new UnexpectedResultException(value2);
            }
            return super.executeIntegerFixnum(frame);
        }
        catch (UnexpectedResultException e) {
            if (e.getResult() instanceof Long && FixnumLowerNode.canLower((Long)e.getResult())) {
                this.hasNeededToLowerLongFixnum = true;
                return FixnumLowerNode.lower((Long)e.getResult());
            }
            if (e.getResult() instanceof RubyRange.LongFixnumRange && FixnumLowerNode.canLower((RubyRange.LongFixnumRange)e.getResult())) {
                this.hasNeededToLowerLongFixnumRange = true;
                throw new UnexpectedResultException(FixnumLowerNode.lower((RubyRange.LongFixnumRange)e.getResult()));
            }
            throw e;
        }
    }

    @Override
    public long executeLongFixnum(VirtualFrame frame) throws UnexpectedResultException {
        throw new RuntimeException();
    }

    @Override
    public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        try {
            if (this.hasNeededToLowerLongFixnumRange) {
                RubyRange.LongFixnumRange range = super.executeLongFixnumRange(frame);
                if (FixnumLowerNode.canLower(range)) {
                    return FixnumLowerNode.lower(range);
                }
                throw new UnexpectedResultException(range);
            }
            return super.executeIntegerFixnumRange(frame);
        }
        catch (UnexpectedResultException e) {
            if (e.getResult() instanceof Long && FixnumLowerNode.canLower((Long)e.getResult())) {
                this.hasNeededToLowerLongFixnum = true;
                throw new UnexpectedResultException(FixnumLowerNode.lower((Long)e.getResult()));
            }
            if (e.getResult() instanceof RubyRange.LongFixnumRange && FixnumLowerNode.canLower((RubyRange.LongFixnumRange)e.getResult())) {
                this.hasNeededToLowerLongFixnumRange = true;
                return FixnumLowerNode.lower((RubyRange.LongFixnumRange)e.getResult());
            }
            throw e;
        }
    }

    @Override
    public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        throw new RuntimeException();
    }

    @Override
    public UndefinedPlaceholder executeUndefinedPlaceholder(VirtualFrame frame) throws UnexpectedResultException {
        try {
            return super.executeUndefinedPlaceholder(frame);
        }
        catch (UnexpectedResultException e) {
            if (e.getResult() instanceof Long && FixnumLowerNode.canLower((Long)e.getResult())) {
                this.hasNeededToLowerLongFixnum = true;
                throw new UnexpectedResultException(FixnumLowerNode.lower((Long)e.getResult()));
            }
            if (e.getResult() instanceof RubyRange.LongFixnumRange && FixnumLowerNode.canLower((RubyRange.LongFixnumRange)e.getResult())) {
                this.hasNeededToLowerLongFixnumRange = true;
                throw new UnexpectedResultException(e.getResult());
            }
            throw e;
        }
    }

    private static boolean canLower(long value2) {
        return CoreLibrary.fitsIntoInteger(value2);
    }

    private static int lower(long value2) {
        assert (FixnumLowerNode.canLower(value2));
        return (int)value2;
    }

    private static boolean canLower(RubyRange.LongFixnumRange range) {
        return FixnumLowerNode.canLower(range.getBegin()) && FixnumLowerNode.canLower(range.getEnd());
    }

    private static RubyRange.IntegerFixnumRange lower(RubyRange.LongFixnumRange range) {
        assert (FixnumLowerNode.canLower(range));
        return new RubyRange.IntegerFixnumRange(range.getContext().getCoreLibrary().getRangeClass(), FixnumLowerNode.lower(range.getBegin()), FixnumLowerNode.lower(range.getEnd()), range.doesExcludeEnd());
    }
}

