/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@CoreClass(name="Comparable")
public abstract class ComparableNodes {

    @CoreMethod(names={"between?"}, required=2)
    public static abstract class BetweenNode
    extends ComparableCoreMethodNode {
        public BetweenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BetweenNode(BetweenNode prev) {
            super(prev);
        }

        @Specialization
        public boolean between(VirtualFrame frame, RubyBasicObject self2, Object min2, Object max2) {
            BetweenNode.notDesignedForCompilation();
            return this.compare(frame, self2, min2) >= 0 && this.compare(frame, self2, max2) <= 0;
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends ComparableCoreMethodNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterNode(GreaterNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greater(VirtualFrame frame, RubyBasicObject self2, Object comparedTo) {
            GreaterNode.notDesignedForCompilation();
            return this.compare(frame, self2, comparedTo) > 0;
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends ComparableCoreMethodNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterEqualNode(GreaterEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greaterEqual(VirtualFrame frame, RubyBasicObject self2, Object comparedTo) {
            GreaterEqualNode.notDesignedForCompilation();
            return this.compare(frame, self2, comparedTo) >= 0;
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends ComparableCoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(VirtualFrame frame, RubyBasicObject self2, Object comparedTo) {
            EqualNode.notDesignedForCompilation();
            if (self2 == comparedTo) {
                return true;
            }
            try {
                return this.compare(frame, self2, comparedTo) == 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends ComparableCoreMethodNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessEqualNode(LessEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lessEqual(VirtualFrame frame, RubyBasicObject self2, Object comparedTo) {
            LessEqualNode.notDesignedForCompilation();
            return this.compare(frame, self2, comparedTo) <= 0;
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends ComparableCoreMethodNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessNode(LessNode prev) {
            super(prev);
        }

        @Specialization
        public boolean less(VirtualFrame frame, RubyBasicObject self2, Object comparedTo) {
            LessNode.notDesignedForCompilation();
            return this.compare(frame, self2, comparedTo) < 0;
        }
    }

    public static abstract class ComparableCoreMethodNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public ComparableCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public ComparableCoreMethodNode(ComparableCoreMethodNode prev) {
            super(prev);
            this.compareNode = prev.compareNode;
        }

        public int compare(VirtualFrame frame, RubyBasicObject receiverObject, Object comparedTo) {
            return (Integer)this.compareNode.call(frame, receiverObject, "<=>", null, comparedTo);
        }
    }
}

