/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.util.ArrayUtils;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArraySliceNode
extends RubyNode {
    final int from;
    final int to;

    public ArraySliceNode(RubyContext context, SourceSection sourceSection, int from, int to) {
        super(context, sourceSection);
        assert (from >= 0);
        assert (to <= 0);
        this.from = from;
        this.to = to;
    }

    public ArraySliceNode(ArraySliceNode prev) {
        super(prev);
        this.from = prev.from;
        this.to = prev.to;
    }

    @Specialization(guards={"isNull"})
    public RubyArray sliceNull(RubyArray array) {
        ArraySliceNode.notDesignedForCompilation();
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
    }

    @Specialization(guards={"isIntegerFixnum"})
    public RubyArray sliceIntegerFixnum(RubyArray array) {
        ArraySliceNode.notDesignedForCompilation();
        int to = array.getSize() + this.to;
        if (this.from >= to) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((int[])array.getStore(), this.from, to), to - this.from);
    }

    @Specialization(guards={"isLongFixnum"})
    public RubyArray sliceLongFixnum(RubyArray array) {
        ArraySliceNode.notDesignedForCompilation();
        int to = array.getSize() + this.to;
        if (this.from >= to) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((long[])array.getStore(), this.from, to), to - this.from);
    }

    @Specialization(guards={"isFloat"})
    public RubyArray sliceFloat(RubyArray array) {
        ArraySliceNode.notDesignedForCompilation();
        int to = array.getSize() + this.to;
        if (this.from >= to) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((double[])array.getStore(), this.from, to), to - this.from);
    }

    @Specialization(guards={"isObject"})
    public RubyArray sliceObject(RubyArray array) {
        ArraySliceNode.notDesignedForCompilation();
        int to = array.getSize() + this.to;
        if (this.from >= to) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((Object[])array.getStore(), this.from, to), to - this.from);
    }
}

