/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ArrayDupNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ArrayDupNode.class)
public final class ArrayDupNodeFactory
extends NodeFactoryBase<ArrayDupNode> {
    private static ArrayDupNodeFactory instance;

    private ArrayDupNodeFactory() {
        super(ArrayDupNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    @Override
    public ArrayDupNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ArrayDupNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayDupNode create(RubyContext context, SourceSection sourceSection, RubyNode array) {
        return ArrayDupUninitializedNode.create0(context, sourceSection, array);
    }

    public static NodeFactory<ArrayDupNode> getInstance() {
        if (instance == null) {
            instance = new ArrayDupNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayDupNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayDupPolymorphicNode
    extends ArrayDupBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;

        ArrayDupPolymorphicNode(ArrayDupBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object arrayValue = this.array.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        @Override
        public RubyArray executeDup(VirtualFrame frameValue, RubyArray arrayValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            return this.next0.executeChained0(frameValue, arrayValue);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDupRubyArray4Node
    extends ArrayDupBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDupRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDupRubyArray4Node(ArrayDupBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isObject(arrayValue)) {
                return super.dupObject(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isObject] failed");
        }

        @Override
        public RubyArray executeDup(VirtualFrame frameValue, RubyArray arrayValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            if (ArrayGuards.isObject(arrayValue)) {
                return super.dupObject(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isObject] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isObject(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.dupObject(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDupNode create0(ArrayDupNode current2) {
            return new ArrayDupRubyArray4Node((ArrayDupBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDupRubyArray3Node
    extends ArrayDupBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDupRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDupRubyArray3Node(ArrayDupBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isFloat(arrayValue)) {
                return super.dupFloat(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isFloat] failed");
        }

        @Override
        public RubyArray executeDup(VirtualFrame frameValue, RubyArray arrayValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            if (ArrayGuards.isFloat(arrayValue)) {
                return super.dupFloat(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isFloat] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isFloat(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.dupFloat(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDupNode create0(ArrayDupNode current2) {
            return new ArrayDupRubyArray3Node((ArrayDupBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDupRubyArray2Node
    extends ArrayDupBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDupRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDupRubyArray2Node(ArrayDupBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isLongFixnum(arrayValue)) {
                return super.dupLongFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isLongFixnum] failed");
        }

        @Override
        public RubyArray executeDup(VirtualFrame frameValue, RubyArray arrayValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            if (ArrayGuards.isLongFixnum(arrayValue)) {
                return super.dupLongFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isLongFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isLongFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.dupLongFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDupNode create0(ArrayDupNode current2) {
            return new ArrayDupRubyArray2Node((ArrayDupBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDupRubyArray1Node
    extends ArrayDupBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDupRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDupRubyArray1Node(ArrayDupBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                return super.dupIntegerFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isIntegerFixnum] failed");
        }

        @Override
        public RubyArray executeDup(VirtualFrame frameValue, RubyArray arrayValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                return super.dupIntegerFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isIntegerFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isIntegerFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.dupIntegerFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDupNode create0(ArrayDupNode current2) {
            return new ArrayDupRubyArray1Node((ArrayDupBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDupRubyArray0Node
    extends ArrayDupBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDupRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDupRubyArray0Node(ArrayDupBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isNull(arrayValue)) {
                return super.dupNull(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isNull] failed");
        }

        @Override
        public RubyArray executeDup(VirtualFrame frameValue, RubyArray arrayValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            if (ArrayGuards.isNull(arrayValue)) {
                return super.dupNull(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isNull] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isNull(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.dupNull(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDupNode create0(ArrayDupNode current2) {
            return new ArrayDupRubyArray0Node((ArrayDupBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayDupUninitializedNode
    extends ArrayDupBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDupUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayDupUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array) {
            super(context, sourceSection, array);
        }

        ArrayDupUninitializedNode(ArrayDupBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        @Override
        public RubyArray executeDup(VirtualFrame frameValue, RubyArray arrayValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arrayValue) {
            ArrayDupBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayDupBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.array}, arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arrayValue);
        }

        static ArrayDupNode create0(RubyContext context, SourceSection sourceSection, RubyNode array) {
            return new ArrayDupUninitializedNode(context, sourceSection, array);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    private static abstract class ArrayDupBaseNode
    extends ArrayDupNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected ArrayDupBaseNode next0;

        ArrayDupBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array) {
            super(context, sourceSection);
            this.array = array;
        }

        ArrayDupBaseNode(ArrayDupBaseNode copy) {
            super(copy);
        }

        protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

        protected final RubyArray rewrite0(VirtualFrame frameValue, Object arrayValue, String reason2) {
            String message2;
            ArrayDupBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayDupBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                newNode = new ArrayDupUninitializedNode(this);
                ((ArrayDupUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ArrayDupBaseNode.createInfo0(reason2, arrayValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new ArrayDupUninitializedNode(this), new ArrayDupPolymorphicNode(this), (ArrayDupBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, arrayValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayDupBaseNode specialize0(Object arrayValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (ArrayGuards.isNull(arrayValueCast)) {
                    return (ArrayDupBaseNode)ArrayDupRubyArray0Node.create0(this);
                }
                if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                    return (ArrayDupBaseNode)ArrayDupRubyArray1Node.create0(this);
                }
                if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                    return (ArrayDupBaseNode)ArrayDupRubyArray2Node.create0(this);
                }
                if (ArrayGuards.isFloat(arrayValueCast)) {
                    return (ArrayDupBaseNode)ArrayDupRubyArray3Node.create0(this);
                }
                if (ArrayGuards.isObject(arrayValueCast)) {
                    return (ArrayDupBaseNode)ArrayDupRubyArray4Node.create0(this);
                }
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.array = other == null ? null : ((ArrayDupBaseNode)other).array;
            this.next0 = newNext == null ? null : (ArrayDupBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object arrayValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

