/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDupNode
extends RubyNode {
    public ArrayDupNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public ArrayDupNode(ArrayDupNode prev) {
        super(prev);
    }

    public abstract RubyArray executeDup(VirtualFrame var1, RubyArray var2);

    @Specialization(guards={"isNull"})
    public RubyArray dupNull(RubyArray from) {
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
    }

    @Specialization(guards={"isIntegerFixnum"})
    public RubyArray dupIntegerFixnum(RubyArray from) {
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((int[])from.getStore(), from.getSize()), from.getSize());
    }

    @Specialization(guards={"isLongFixnum"})
    public RubyArray dupLongFixnum(RubyArray from) {
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((long[])from.getStore(), from.getSize()), from.getSize());
    }

    @Specialization(guards={"isFloat"})
    public RubyArray dupFloat(RubyArray from) {
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((double[])from.getStore(), from.getSize()), from.getSize());
    }

    @Specialization(guards={"isObject"})
    public RubyArray dupObject(RubyArray from) {
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((Object[])from.getStore(), from.getSize()), from.getSize());
    }
}

