/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.control.RescueNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.RetryException;

public class TryNode
extends RubyNode {
    @Node.Child
    private ExceptionTranslatingNode tryPart;
    @Node.Children
    final RescueNode[] rescueParts;
    @Node.Child
    private RubyNode elsePart;
    @Node.Child
    private WriteInstanceVariableNode clearExceptionVariableNode;
    private final BranchProfile elseProfile = BranchProfile.create();
    private final BranchProfile controlFlowProfile = BranchProfile.create();
    private final BranchProfile raiseExceptionProfile = BranchProfile.create();

    public TryNode(RubyContext context, SourceSection sourceSection, ExceptionTranslatingNode tryPart, RescueNode[] rescueParts, RubyNode elsePart) {
        super(context, sourceSection);
        this.tryPart = tryPart;
        this.rescueParts = rescueParts;
        this.elsePart = elsePart;
        this.clearExceptionVariableNode = new WriteInstanceVariableNode(context, sourceSection, "$!", new ObjectLiteralNode(context, sourceSection, context.getCoreLibrary().getGlobalVariablesObject()), new ObjectLiteralNode(context, sourceSection, context.getCoreLibrary().getNilObject()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        Object result2;
        while (true) {
            try {
                result2 = this.tryPart.execute(frame);
            }
            catch (ControlFlowException exception2) {
                this.controlFlowProfile.enter();
                throw exception2;
            }
            catch (RaiseException exception3) {
                this.raiseExceptionProfile.enter();
                try {
                    Object object = this.handleException(frame, exception3);
                    return object;
                }
                catch (RetryException e) {
                    this.getContext().getSafepointManager().poll();
                    continue;
                }
            }
            finally {
                this.clearExceptionVariableNode.execute(frame);
                continue;
            }
            break;
        }
        this.elseProfile.enter();
        this.elsePart.executeVoid(frame);
        return result2;
    }

    @ExplodeLoop
    private Object handleException(VirtualFrame frame, RaiseException exception2) {
        CompilerAsserts.neverPartOfCompilation();
        TryNode.notDesignedForCompilation();
        this.getContext().getCoreLibrary().getGlobalVariablesObject().getOperations().setInstanceVariable(this.getContext().getCoreLibrary().getGlobalVariablesObject(), "$!", exception2.getRubyException());
        for (RescueNode rescue : this.rescueParts) {
            if (!rescue.canHandle(frame, exception2.getRubyException())) continue;
            return rescue.execute(frame);
        }
        throw exception2;
    }
}

