/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.ProcCastNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@GeneratedBy(value=ProcCastNode.class)
public final class ProcCastNodeFactory
extends NodeFactoryBase<ProcCastNode> {
    private static ProcCastNodeFactory instance;

    private ProcCastNodeFactory() {
        super(ProcCastNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    @Override
    public ProcCastNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ProcCastNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ProcCastNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ProcCastUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<ProcCastNode> getInstance() {
        if (instance == null) {
            instance = new ProcCastNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ProcCastNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ProcCastPolymorphicNode
    extends ProcCastBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ProcCastPolymorphicNode(ProcCastBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyNilClass.class ? this.child.executeRubyNilClass(frameValue) : (this.childPolymorphicType == RubyProc.class ? this.child.executeRubyProc(frameValue) : (this.childPolymorphicType == RubyBasicObject.class ? this.child.executeRubyBasicObject(frameValue) : this.child.execute(frameValue)));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ProcCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ProcCastRubyProcRubyBasicObjectNode
    extends ProcCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ProcCastRubyProcRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        ProcCastRubyProcRubyBasicObjectNode(ProcCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyProc value2;
            try {
                value2 = this.executeRubyProc(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyProc(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject"));
            }
            return super.doObject(frameValue, childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                return super.doObject(frameValue, childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ProcCastNode create0(ProcCastNode current2) {
            return new ProcCastRubyProcRubyBasicObjectNode((ProcCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ProcCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ProcCastRubyProcNode
    extends ProcCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ProcCastRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyProc.class}, 0, 0);

        ProcCastRubyProcNode(ProcCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyProc value2;
            try {
                value2 = this.executeRubyProc(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyProc childValue;
            try {
                childValue = this.child.executeRubyProc(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyProc(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyProc"));
            }
            return super.doRubyProc(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyProc(childValue)) {
                RubyProc childValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(childValue);
                return super.doRubyProc(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ProcCastNode create0(ProcCastNode current2) {
            return new ProcCastRubyProcNode((ProcCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ProcCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ProcCastRubyNilClassNode
    extends ProcCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ProcCastRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

        ProcCastRubyNilClassNode(ProcCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyNilClass childValue;
            try {
                childValue = this.child.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyNilClass"));
            }
            return super.doNil(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                RubyNilClass childValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(childValue);
                return super.doNil(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ProcCastNode create0(ProcCastNode current2) {
            return new ProcCastRubyNilClassNode((ProcCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ProcCastNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ProcCastUninitializedNode
    extends ProcCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ProcCastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ProcCastUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ProcCastUninitializedNode(ProcCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ProcCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ProcCastBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.child}, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, childValue);
        }

        static ProcCastNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ProcCastUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=ProcCastNode.class)
    private static abstract class ProcCastBaseNode
    extends ProcCastNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ProcCastBaseNode next0;

        ProcCastBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ProcCastBaseNode(ProcCastBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object childValue, String reason2) {
            String message2;
            ProcCastBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ProcCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ProcCastUninitializedNode(this);
                ((ProcCastUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ProcCastBaseNode.createInfo0(reason2, childValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new ProcCastUninitializedNode(this), new ProcCastPolymorphicNode(this), (ProcCastBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ProcCastBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                return (ProcCastBaseNode)ProcCastRubyNilClassNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyProc(childValue)) {
                return (ProcCastBaseNode)ProcCastRubyProcNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                return (ProcCastBaseNode)ProcCastRubyProcRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ProcCastBaseNode)other).child;
            this.next0 = newNext == null ? null : (ProcCastBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

