/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChild(value="child")
public abstract class HashCastNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toHashNode;

    public HashCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toHashNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
    }

    public HashCastNode(HashCastNode prev) {
        super(prev);
        this.toHashNode = prev.toHashNode;
    }

    protected abstract RubyNode getChild();

    @Specialization
    public RubyNilClass cast(boolean value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(int value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(long value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(double value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(RubyBignum value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyHash cast(RubyHash hash2) {
        return hash2;
    }

    @Specialization
    public RubyNilClass cast(RubyNilClass nil) {
        return nil;
    }

    @Specialization(guards={"!isRubyNilClass", "!isRubyHash"})
    public Object cast(VirtualFrame frame, RubyBasicObject object) {
        HashCastNode.notDesignedForCompilation();
        Object result2 = this.toHashNode.call(frame, object, "to_hash", null, new Object[0]);
        if (result2 == DispatchNode.MISSING) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        if (!(result2 instanceof RubyHash)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorShouldReturn(object.toString(), "to_hash", "HAsh", this));
        }
        return result2;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

