/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.ArrayCastNode;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=ArrayCastNode.class)
public final class ArrayCastNodeFactory
extends NodeFactoryBase<ArrayCastNode> {
    private static ArrayCastNodeFactory instance;

    private ArrayCastNodeFactory() {
        super(ArrayCastNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}, {RubyContext.class, SourceSection.class, SplatCastNode.NilBehavior.class, RubyNode.class}});
    }

    @Override
    public ArrayCastNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ArrayCastNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
        }
        if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof SplatCastNode.NilBehavior) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
            return ArrayCastNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (SplatCastNode.NilBehavior)((Object)arguments[2]), (RubyNode)arguments[3]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayCastNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ArrayCastUninitializedNode.create0(context, sourceSection, child);
    }

    public static ArrayCastNode create(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, RubyNode child) {
        return ArrayCastUninitializedNode.create0(context, sourceSection, nilBehavior, child);
    }

    public static NodeFactory<ArrayCastNode> getInstance() {
        if (instance == null) {
            instance = new ArrayCastNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayCastPolymorphicNode
    extends ArrayCastBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ArrayCastPolymorphicNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.child.executeBoolean(frameValue)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(this.child.executeIntegerFixnum(frameValue)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(this.child.executeLongFixnum(frameValue)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(this.child.executeFloat(frameValue)) : (this.childPolymorphicType == RubyBignum.class ? this.child.executeBignum(frameValue) : (this.childPolymorphicType == RubyArray.class ? this.child.executeArray(frameValue) : (this.childPolymorphicType == RubyNilClass.class ? this.child.executeRubyNilClass(frameValue) : (this.childPolymorphicType == RubyBasicObject.class ? this.child.executeRubyBasicObject(frameValue) : this.child.execute(frameValue))))))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastObjectRubyBasicObjectNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        ArrayCastObjectRubyBasicObjectNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!super.isRubyNilClass(childValue) && !super.isRubyArray(childValue)) {
                return super.cast(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyNilClass, !isRubyArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                if (!super.isRubyNilClass(childValue) && !super.isRubyArray(childValue)) {
                    return super.cast(frameValue, childValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastObjectRubyBasicObjectNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastObjectRubyNilClassNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastObjectRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

        ArrayCastObjectRubyNilClassNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass childValue;
            try {
                childValue = this.child.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyNilClass");
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                RubyNilClass childValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastObjectRubyNilClassNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastRubyArrayNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayCastRubyArrayNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray childValue;
            try {
                childValue = this.child.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyArray"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(childValue)) {
                RubyArray childValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastRubyArrayNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastRubyNilClassRubyBignumNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastRubyNilClassRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

        ArrayCastRubyNilClassRubyBignumNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBignum childValue;
            try {
                childValue = this.child.executeBignum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBignum"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                RubyBignum childValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastRubyNilClassRubyBignumNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastRubyNilClassDoubleNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastRubyNilClassDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        ArrayCastRubyNilClassDoubleNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            double childValue;
            try {
                childValue = this.child.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof double"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                double childValueCast = RubyTypesGen.RUBYTYPES.asDouble(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastRubyNilClassDoubleNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastRubyNilClassLongNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastRubyNilClassLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        ArrayCastRubyNilClassLongNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                long childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastRubyNilClassLongNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastRubyNilClassIntNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastRubyNilClassIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        ArrayCastRubyNilClassIntNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int childValue;
            try {
                childValue = this.child.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof int"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                int childValueCast = RubyTypesGen.RUBYTYPES.asInteger(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastRubyNilClassIntNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayCastRubyNilClassBooleanNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastRubyNilClassBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        ArrayCastRubyNilClassBooleanNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean childValue;
            try {
                childValue = this.child.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof boolean"));
            }
            return super.cast(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                boolean childValueCast = RubyTypesGen.RUBYTYPES.asBoolean(childValue);
                return super.cast(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(ArrayCastNode current2) {
            return new ArrayCastRubyNilClassBooleanNode((ArrayCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayCastUninitializedNode
    extends ArrayCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayCastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayCastUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ArrayCastUninitializedNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, RubyNode child) {
            super(context, sourceSection, nilBehavior, child);
        }

        ArrayCastUninitializedNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ArrayCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayCastBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.child}, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, childValue);
        }

        static ArrayCastNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ArrayCastUninitializedNode(context, sourceSection, child);
        }

        static ArrayCastNode create0(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, RubyNode child) {
            return new ArrayCastUninitializedNode(context, sourceSection, nilBehavior, child);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    private static abstract class ArrayCastBaseNode
    extends ArrayCastNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ArrayCastBaseNode next0;

        ArrayCastBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ArrayCastBaseNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, RubyNode child) {
            super(context, sourceSection, nilBehavior);
            this.child = child;
        }

        ArrayCastBaseNode(ArrayCastBaseNode copy) {
            super(copy);
        }

        @Override
        protected RubyNode getChild() {
            return this.child;
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object childValue, String reason2) {
            String message2;
            ArrayCastBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ArrayCastUninitializedNode(this);
                ((ArrayCastUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ArrayCastBaseNode.createInfo0(reason2, childValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new ArrayCastUninitializedNode(this), new ArrayCastPolymorphicNode(this), (ArrayCastBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayCastBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                return (ArrayCastBaseNode)ArrayCastRubyNilClassBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                return (ArrayCastBaseNode)ArrayCastRubyNilClassIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                return (ArrayCastBaseNode)ArrayCastRubyNilClassLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                return (ArrayCastBaseNode)ArrayCastRubyNilClassDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                return (ArrayCastBaseNode)ArrayCastRubyNilClassRubyBignumNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyArray(childValue)) {
                return (ArrayCastBaseNode)ArrayCastRubyArrayNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                return (ArrayCastBaseNode)ArrayCastObjectRubyNilClassNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue) && !super.isRubyNilClass(childValue) && !super.isRubyArray(childValue)) {
                return (ArrayCastBaseNode)ArrayCastObjectRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ArrayCastBaseNode)other).child;
            this.next0 = newNext == null ? null : (ArrayCastBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

