/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChild(value="child")
public abstract class ArrayCastNode
extends RubyNode {
    private final SplatCastNode.NilBehavior nilBehavior;
    @Node.Child
    private CallDispatchHeadNode toArrayNode;

    public ArrayCastNode(RubyContext context, SourceSection sourceSection) {
        this(context, sourceSection, SplatCastNode.NilBehavior.NIL);
    }

    public ArrayCastNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior) {
        super(context, sourceSection);
        this.toArrayNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        this.nilBehavior = nilBehavior;
    }

    public ArrayCastNode(ArrayCastNode prev) {
        super(prev);
        this.toArrayNode = prev.toArrayNode;
        this.nilBehavior = prev.nilBehavior;
    }

    protected abstract RubyNode getChild();

    @Specialization
    public RubyNilClass cast(boolean value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(int value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(long value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(double value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyNilClass cast(RubyBignum value2) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization
    public RubyArray cast(RubyArray array) {
        return array;
    }

    @Specialization
    public Object cast(RubyNilClass nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            }
            case ARRAY_WITH_NIL: {
                return RubyArray.fromObject(this.getContext().getCoreLibrary().getArrayClass(), this.getContext().getCoreLibrary().getNilObject());
            }
            case NIL: {
                return nil;
            }
        }
        CompilerAsserts.neverPartOfCompilation();
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"!isRubyNilClass", "!isRubyArray"})
    public Object cast(VirtualFrame frame, RubyBasicObject object) {
        ArrayCastNode.notDesignedForCompilation();
        Object result2 = this.toArrayNode.call(frame, object, "to_ary", null, new Object[0]);
        if (result2 == DispatchNode.MISSING) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        if (!(result2 instanceof RubyArray)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorShouldReturn(object.toString(), "to_ary", "Array", this));
        }
        return result2;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

