/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyModule;

public class WriteConstantNode
extends RubyNode {
    private final String name;
    private final LexicalScope lexicalScope;
    @Node.Child
    private RubyNode module;
    @Node.Child
    private RubyNode rhs;

    public WriteConstantNode(RubyContext context, SourceSection sourceSection, String name2, LexicalScope lexicalScope, RubyNode module, RubyNode rhs) {
        super(context, sourceSection);
        this.name = name2;
        this.lexicalScope = lexicalScope;
        this.module = module;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject;
        RubyModule setModule;
        WriteConstantNode.notDesignedForCompilation();
        Object rhsValue = this.rhs.execute(frame);
        if (rhsValue instanceof RubyModule && (setModule = (RubyModule)rhsValue).getName() == null) {
            setModule.setLexicalScope(this.lexicalScope);
            setModule.setName(this.name);
        }
        if (!((receiverObject = this.module.execute(frame)) instanceof RubyModule)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(receiverObject.toString(), "class/module", this));
        }
        RubyModule module = (RubyModule)receiverObject;
        module.setConstant(this, this.name, rhsValue);
        return rhsValue;
    }
}

