/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.ir.IRClosure;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InterpretedIRBlockBody
extends IRBlockBody {
    private static final Logger LOG = LoggerFactory.getLogger("InterpretedIRBlockBody");
    protected final IRClosure closure;
    protected boolean pushScope;
    protected boolean reuseParentScope;
    private boolean displayedCFG = false;

    public InterpretedIRBlockBody(IRClosure closure, Signature signature) {
        super(closure.getStaticScope(), closure.getParameterList(), closure.getFileName(), closure.getLineNumber(), signature);
        this.closure = closure;
        this.pushScope = true;
        this.reuseParentScope = false;
    }

    public InterpreterContext ensureInstrsReady() {
        if (IRRuntimeHelpers.isDebug() && !this.displayedCFG) {
            LOG.info("Executing '" + this.closure + "' (pushScope=" + this.pushScope + ", reuseParentScope=" + this.reuseParentScope, new Object[0]);
            CFG cfg = this.closure.getCFG();
            LOG.info("Graph:\n" + cfg.toStringGraph(), new Object[0]);
            LOG.info("CFG:\n" + cfg.toStringInstrs(), new Object[0]);
            this.displayedCFG = true;
        }
        return this.closure.getInterpreterContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2, Block block) {
        InterpreterContext ic = this.ensureInstrsReady();
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame prevFrame = context.preYieldNoScope(binding2);
        if (self2 == null || this.evalType.get() == EvalType.BINDING_EVAL) {
            self2 = this.useBindingSelf(binding2);
        }
        DynamicScope prevScope = binding2.getDynamicScope();
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(this.getStaticScope(), prevScope, (EvalType)((Object)this.evalType.get())));
        } else if (ic.reuseParentDynScope()) {
            context.pushScope(prevScope);
        }
        this.evalType.set(EvalType.NONE);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_BLOCK(context, self2, ic, args2, binding2.getMethod(), block, type2);
            return iRubyObject;
        }
        finally {
            binding2.getFrame().setVisibility(oldVis);
            if (ic.popDynScope()) {
                context.postYield(binding2, prevFrame);
            } else {
                context.postYieldNoScope(prevFrame);
            }
        }
    }
}

