/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class IRBlockBody
extends ContextAwareBlockBody {
    protected String[] parameterList;
    protected final String fileName;
    protected final int lineNumber;
    protected ThreadLocal<EvalType> evalType;
    protected final Signature signature;

    public IRBlockBody(StaticScope staticScope, String[] parameterList, String fileName, int lineNumber, Signature signature) {
        super(staticScope, signature.arity(), -1);
        this.parameterList = parameterList;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.evalType = new ThreadLocal();
        this.evalType.set(EvalType.NONE);
        this.signature = signature;
    }

    @Override
    public void setEvalType(EvalType evalType) {
        this.evalType.set(evalType);
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public String[] getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(String[] parameterList) {
        this.parameterList = parameterList;
    }

    @Override
    public IRubyObject call(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.call(context, IRubyObject.NULL_ARRAY, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0, arg1}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.call(context, args2, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, this.prepareArgumentsForCall(context, args2, type2), null, binding2, type2, block);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = IRubyObject.NULL_ARRAY;
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        if (arg0 instanceof RubyArray) {
            IRubyObject[] args2 = IRRuntimeHelpers.convertValueIntoArgArray(context, arg0, this.arity, true);
            if (type2 == Block.Type.LAMBDA) {
                this.signature.checkArity(context.runtime, args2);
            }
            return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
        }
        return this.yield(context, arg0, binding2, type2);
    }

    private IRubyObject yieldSpecificMultiArgsCommon(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        int blockArity = this.arity().getValue();
        if (blockArity == 0) {
            args2 = IRubyObject.NULL_ARRAY;
        } else if (blockArity == 1) {
            args2 = new IRubyObject[]{RubyArray.newArrayNoCopy(context.runtime, args2)};
        }
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yieldSpecificMultiArgsCommon(context, new IRubyObject[]{arg0, arg1}, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yieldSpecificMultiArgsCommon(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2);
    }

    @Override
    public IRubyObject doYield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject[] args2;
        int blockArity = this.arity().getValue();
        if (type2 == Block.Type.LAMBDA && this.arity().required() == 1 || blockArity >= -1 && blockArity <= 1) {
            args2 = new IRubyObject[]{value2};
        } else {
            IRubyObject val0 = Helpers.aryToAry(value2);
            if (!(val0 instanceof RubyArray)) {
                throw context.runtime.newTypeError(value2.getType().getName() + "#to_ary should return Array");
            }
            args2 = ((RubyArray)val0).toJavaArray();
        }
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject doYield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        IRubyObject[] iRubyObjectArray = args2 = args2 == null ? IRubyObject.NULL_ARRAY : args2;
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, args2, self2, binding2, type2, Block.NULL_BLOCK);
    }

    protected IRubyObject useBindingSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    protected abstract IRubyObject commonYieldPath(ThreadContext var1, IRubyObject[] var2, IRubyObject var3, Binding var4, Block.Type var5, Block var6);

    protected void blockArgWarning(Ruby ruby2, int length2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)");
    }

    protected IRubyObject[] convertToRubyArray(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] iRubyObjectArray;
        if (args2.length == 0) {
            iRubyObjectArray = context.runtime.getSingleNilArray();
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = context.runtime.newArrayNoCopy(args2);
        }
        return iRubyObjectArray;
    }

    @Override
    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        } else if (args2.length == 1) {
            args2 = IRRuntimeHelpers.convertValueIntoArgArray(context, args2[0], this.arity, type2 == Block.Type.NORMAL && args2[0] instanceof RubyArray);
        } else if (this.arity().getValue() == 1) {
            IRubyObject[] iRubyObjectArray;
            if (args2.length == 0) {
                iRubyObjectArray = context.runtime.getSingleNilArray();
            } else {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray2;
                iRubyObjectArray2[0] = args2[0];
            }
            args2 = iRubyObjectArray;
        }
        return args2;
    }

    @Override
    public String getFile() {
        return this.fileName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }
}

