/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyProc;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock
extends ContextAwareBlockBody {
    protected final CompiledBlockCallback callback;
    protected final boolean hasMultipleArgsHead;

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self2, Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        CompiledBlock body = new CompiledBlock(arity2, scope, callback, hasMultipleArgsHead, argumentType);
        return new Block(body, binding2);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self2, BlockBody body) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        return new Block(body, binding2);
    }

    public static BlockBody newCompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        return new CompiledBlock(arity2, scope, callback, hasMultipleArgsHead, argumentType);
    }

    public CompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        super(scope, arity2, argumentType);
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, null, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1}, null, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1, arg2}, null, binding2, type2);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, self2, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
        IRubyObject self2 = this.prepareSelf(binding2);
        IRubyObject realArg = this.setupBlockArg(context.runtime, value2, self2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, binding2);
        try {
            IRubyObject iRubyObject = this.callback.call(context, self2, realArg, block);
            return iRubyObject;
        }
        catch (JumpException.FlowControlException jump) {
            IRubyObject iRubyObject = Helpers.handleBlockJump(context, jump, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2, Block block) {
        self2 = this.prepareSelf(binding2);
        IRubyObject[] preppedArgs = RubyProc.prepareArgs(context, type2, this, args2);
        RubyArray value2 = context.runtime.newArrayNoCopyLight(preppedArgs);
        IRubyObject realArg = this.setupBlockArgs(context, value2, self2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, binding2);
        try {
            IRubyObject iRubyObject = this.callback.call(context, self2, realArg, block);
            return iRubyObject;
        }
        catch (JumpException.FlowControlException jump) {
            IRubyObject iRubyObject = Helpers.handleBlockJump(context, jump, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    protected IRubyObject setupBlockArgs(ThreadContext context, IRubyObject value2, IRubyObject self2) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return value2;
            }
        }
        return this.defaultArgsLogic(context.runtime, value2);
    }

    private IRubyObject defaultArgsLogic(Ruby ruby2, IRubyObject value2) {
        int length2 = ArgsUtil.arrayLength(value2);
        switch (length2) {
            case 0: {
                return ruby2.getNil();
            }
            case 1: {
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        this.blockArgWarning(ruby2, length2);
        return value2;
    }

    private void blockArgWarning(Ruby ruby2, int length2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)");
    }

    protected IRubyObject setupBlockArg(Ruby ruby2, IRubyObject value2, IRubyObject self2) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return ArgsUtil.convertToRubyArray(ruby2, value2, this.hasMultipleArgsHead);
            }
        }
        return this.defaultArgLogic(ruby2, value2);
    }

    private IRubyObject defaultArgLogic(Ruby ruby2, IRubyObject value2) {
        if (value2 == null) {
            return this.warnMultiReturnNil(ruby2);
        }
        return value2;
    }

    @Override
    public String getFile() {
        return this.callback.getFile();
    }

    @Override
    public int getLine() {
        return this.callback.getLine();
    }

    private IRubyObject warnMultiReturnNil(Ruby ruby2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)");
        return ruby2.getNil();
    }
}

