/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.RubyArray;
import org.jruby.RubyProc;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NodeType;
import org.jruby.common.IRubyWarnings;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.NullBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class BlockBody {
    public static final int ZERO_ARGS = 0;
    public static final int MULTIPLE_ASSIGNMENT = 1;
    public static final int ARRAY = 2;
    public static final int SINGLE_RESTARG = 3;
    public static final String[] EMPTY_PARAMETER_LIST = new String[0];
    protected final int argumentType;
    public static final BlockBody NULL_BODY = new NullBlockBody();

    public BlockBody(int argumentType) {
        this.argumentType = argumentType;
    }

    public void setEvalType(EvalType evalType) {
        System.err.println("setEvalType unimplemented in " + this.getClass().getName());
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2, block);
    }

    public final IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.doYield(context, value2, binding2, type2);
    }

    public final IRubyObject yield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        IRubyObject[] preppedValue = RubyProc.prepareArgs(context, type2, this, args2);
        return this.doYield(context, preppedValue, self2, binding2, type2);
    }

    protected abstract IRubyObject doYield(ThreadContext var1, IRubyObject var2, Binding var3, Block.Type var4);

    protected abstract IRubyObject doYield(ThreadContext var1, IRubyObject[] var2, IRubyObject var3, Binding var4, Block.Type var5);

    public IRubyObject yield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, args2, self2, binding2, type2);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, value2, binding2, type2);
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public IRubyObject call(ThreadContext context, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = IRubyObject.NULL_ARRAY;
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = new IRubyObject[]{arg0};
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, arg0, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = new IRubyObject[]{arg0, arg1};
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, arg0, arg1, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1}, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = new IRubyObject[]{arg0, arg1, arg2};
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, arg0, arg1, arg2, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1, arg2}, null, binding2, type2);
    }

    public abstract StaticScope getStaticScope();

    public abstract void setStaticScope(StaticScope var1);

    public abstract Arity arity();

    public boolean isGiven() {
        return true;
    }

    public abstract String getFile();

    public abstract int getLine();

    public static int asArgumentType(NodeType nodeId) {
        if (nodeId == null) {
            return 0;
        }
        switch (nodeId) {
            case ZEROARGNODE: {
                return 0;
            }
            case MULTIPLEASGNNODE: {
                return 1;
            }
            case SVALUENODE: {
                return 3;
            }
        }
        return 2;
    }

    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        switch (type2) {
            case NORMAL: {
                if (args2.length == 1 && args2[0] instanceof RubyArray) {
                    if (this.argumentType != 1 && this.argumentType != 3) break;
                    args2 = ((RubyArray)args2[0]).toJavaArray();
                    break;
                }
            }
            case PROC: {
                if (args2.length != 1 || !(args2[0] instanceof RubyArray) || this.argumentType != 1 || this.argumentType == 3) break;
                args2 = ((RubyArray)args2[0]).toJavaArray();
                break;
            }
            case LAMBDA: {
                if (this.argumentType == 2 && args2.length != 1) {
                    context.runtime.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + args2.length + " for " + this.arity().getValue() + ")");
                    if (args2.length == 0) {
                        args2 = context.runtime.getSingleNilArray();
                        break;
                    }
                    args2 = new IRubyObject[]{context.runtime.newArrayNoCopy(args2)};
                    break;
                }
                this.arity().checkArity(context.runtime, args2);
            }
        }
        return args2;
    }

    public String[] getParameterList() {
        return EMPTY_PARAMETER_LIST;
    }

    public static NodeType getArgumentTypeWackyHack(IterNode iterNode) {
        MultipleAsgnNode multipleAsgnNode;
        NodeType argsNodeId = null;
        if (iterNode.getVarNode() != null && iterNode.getVarNode().getNodeType() != NodeType.ZEROARGNODE && (argsNodeId = iterNode.getVarNode().getNodeType()) == NodeType.MULTIPLEASGNNODE && (multipleAsgnNode = (MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() == null && multipleAsgnNode.getArgsNode() != null) {
            argsNodeId = NodeType.SVALUENODE;
        }
        return argsNodeId;
    }
}

