/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.InternalJavaProxyHelper;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.GeneratorAdapter;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JavaProxyClassFactory {
    private static final Logger LOG = LoggerFactory.getLogger("JavaProxyClassFactory");
    private static final Type JAVA_LANG_CLASS_TYPE = Type.getType(Class.class);
    private static final Type[] EMPTY_TYPE_ARR = new Type[0];
    private static final org.jruby.org.objectweb.asm.commons.Method HELPER_GET_PROXY_CLASS_METHOD = org.jruby.org.objectweb.asm.commons.Method.getMethod(JavaProxyClass.class.getName() + " initProxyClass(java.lang.Class)");
    private static final org.jruby.org.objectweb.asm.commons.Method CLASS_FORNAME_METHOD = org.jruby.org.objectweb.asm.commons.Method.getMethod("java.lang.Class forName(java.lang.String)");
    private static final String INVOCATION_HANDLER_FIELD_NAME = "__handler";
    private static final String PROXY_CLASS_FIELD_NAME = "__proxy_class";
    private static final Class[] EMPTY_CLASS_ARR = new Class[0];
    private static final Type INVOCATION_HANDLER_TYPE = Type.getType(JavaProxyInvocationHandler.class);
    private static final Type PROXY_METHOD_TYPE = Type.getType(JavaProxyMethod.class);
    private static final Type PROXY_CLASS_TYPE = Type.getType(JavaProxyClass.class);
    private static final org.jruby.org.objectweb.asm.commons.Method INVOCATION_HANDLER_INVOKE_METHOD = org.jruby.org.objectweb.asm.commons.Method.getMethod("java.lang.Object invoke(java.lang.Object, " + PROXY_METHOD_TYPE.getClassName() + ", java.lang.Object[])");
    private static final Type PROXY_HELPER_TYPE = Type.getType(InternalJavaProxyHelper.class);
    private static final org.jruby.org.objectweb.asm.commons.Method PROXY_HELPER_GET_METHOD = org.jruby.org.objectweb.asm.commons.Method.getMethod(PROXY_METHOD_TYPE.getClassName() + " initProxyMethod(" + JavaProxyClass.class.getName() + ",java.lang.String,java.lang.String,boolean)");
    private static final Type JAVA_PROXY_TYPE = Type.getType(InternalJavaProxy.class);
    private static int counter;
    private static Method defineClass_method;
    public static final String PROXY_CLASS_FACTORY;

    private static synchronized int nextId() {
        return counter++;
    }

    public static JavaProxyClassFactory createFactory() {
        JavaProxyClassFactory factory = null;
        if (PROXY_CLASS_FACTORY != null) {
            try {
                Class<?> clazz = Class.forName(PROXY_CLASS_FACTORY);
                Object instance = clazz.newInstance();
                if (instance instanceof JavaProxyClassFactory) {
                    factory = (JavaProxyClassFactory)instance;
                    LOG.info("Created proxy class factory: " + factory, new Object[0]);
                } else {
                    LOG.error("Invalid proxy class factory: " + instance, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error("ClassNotFoundException creating proxy class factory: " + e, new Object[0]);
            }
            catch (InstantiationException e) {
                LOG.error("InstantiationException creating proxy class factory: " + e, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOG.error("IllegalAccessException creating proxy class factory: " + e, new Object[0]);
            }
        }
        if (factory == null) {
            factory = new JavaProxyClassFactory();
        }
        return factory;
    }

    public JavaProxyClass newProxyClass(Ruby runtime, ClassLoader loader, String targetClassName, Class superClass, Class[] interfaces2, Set names2) throws InvocationTargetException {
        Map<Set<?>, JavaProxyClass> proxyCache;
        JavaProxyClass proxyClass;
        if (loader == null) {
            loader = JavaProxyClassFactory.class.getClassLoader();
        }
        if (superClass == null) {
            superClass = Object.class;
        }
        if (interfaces2 == null) {
            interfaces2 = EMPTY_CLASS_ARR;
        }
        HashSet<Class> key2 = new HashSet<Class>();
        key2.add(superClass);
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            key2.add(interfaces2[i2]);
        }
        if (names2 != null) {
            key2.addAll(names2);
        }
        if ((proxyClass = (proxyCache = runtime.getJavaSupport().getJavaProxyClassCache()).get(key2)) == null) {
            if (targetClassName == null) {
                String pkg = JavaProxyClassFactory.proxyPackageName(superClass);
                String fullName = superClass.getName();
                int ix = fullName.lastIndexOf(46);
                String cName = fullName;
                if (ix != -1) {
                    cName = fullName.substring(ix + 1);
                }
                targetClassName = pkg + "." + cName + "$Proxy" + JavaProxyClassFactory.nextId();
            }
            JavaProxyClassFactory.validateArgs(runtime, targetClassName, superClass);
            Type selfType = Type.getType("L" + JavaProxyClassFactory.toInternalClassName(targetClassName) + ";");
            proxyClass = this.generate(loader, targetClassName, superClass, interfaces2, JavaProxyClassFactory.collectMethods(superClass, interfaces2, names2), selfType);
            proxyCache.put(key2, proxyClass);
        }
        return proxyClass;
    }

    private JavaProxyClass generate(ClassLoader loader, String targetClassName, Class superClass, Class[] interfaces2, Map<MethodKey, MethodData> methods2, Type selfType) {
        ClassWriter cw = this.beginProxyClass(targetClassName, superClass, interfaces2);
        GeneratorAdapter clazzInit = this.createClassInitializer(selfType, cw);
        this.generateConstructors(superClass, selfType, cw);
        this.generateGetProxyClass(selfType, cw);
        this.generateGetInvocationHandler(selfType, cw);
        this.generateProxyMethods(superClass, methods2, selfType, cw, clazzInit);
        clazzInit.returnValue();
        clazzInit.endMethod();
        cw.visitEnd();
        Class clazz = this.invokeDefineClass(loader, selfType.getClassName(), cw.toByteArray());
        try {
            Field proxy_class = clazz.getDeclaredField(PROXY_CLASS_FIELD_NAME);
            proxy_class.setAccessible(true);
            return (JavaProxyClass)proxy_class.get(clazz);
        }
        catch (Exception ex) {
            InternalError ie = new InternalError();
            ie.initCause(ex);
            throw ie;
        }
    }

    protected Class invokeDefineClass(ClassLoader loader, String className, byte[] data2) {
        try {
            return (Class)defineClass_method.invoke((Object)loader, className, data2, 0, data2.length, JavaProxyClassFactory.class.getProtectionDomain());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ClassWriter beginProxyClass(String className, Class superClass, Class[] interfaces2) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(47, 49, JavaProxyClassFactory.toInternalClassName(className), null, JavaProxyClassFactory.toInternalClassName(superClass), this.interfaceNamesForProxyClass(interfaces2));
        cw.visitField(2, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE.getDescriptor(), null, null).visitEnd();
        cw.visitField(10, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE.getDescriptor(), null, null).visitEnd();
        return cw;
    }

    private String[] interfaceNamesForProxyClass(Class[] interfaces2) {
        String[] interfaceNames = new String[interfaces2.length + 1];
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            interfaceNames[i2] = JavaProxyClassFactory.toInternalClassName(interfaces2[i2]);
        }
        interfaceNames[interfaces2.length] = JavaProxyClassFactory.toInternalClassName(InternalJavaProxy.class);
        return interfaceNames;
    }

    private void generateProxyMethods(Class superClass, Map<MethodKey, MethodData> methods2, Type selfType, ClassVisitor cw, GeneratorAdapter clazzInit) {
        for (MethodData md : methods2.values()) {
            Type superClassType = Type.getType(superClass);
            this.generateProxyMethod(selfType, superClassType, cw, clazzInit, md);
        }
    }

    private void generateGetInvocationHandler(Type selfType, ClassVisitor cw) {
        GeneratorAdapter gh = new GeneratorAdapter(1, new org.jruby.org.objectweb.asm.commons.Method("___getInvocationHandler", INVOCATION_HANDLER_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, cw);
        gh.loadThis();
        gh.getField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        gh.returnValue();
        gh.endMethod();
    }

    private void generateGetProxyClass(Type selfType, ClassVisitor cw) {
        GeneratorAdapter gpc = new GeneratorAdapter(1, new org.jruby.org.objectweb.asm.commons.Method("___getProxyClass", PROXY_CLASS_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, cw);
        gpc.getStatic(selfType, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        gpc.returnValue();
        gpc.endMethod();
    }

    private void generateConstructors(Class superClass, Type selfType, ClassVisitor cw) {
        Constructor<?>[] cons = superClass.getDeclaredConstructors();
        for (int i2 = 0; i2 < cons.length; ++i2) {
            if (Modifier.isPrivate(cons[i2].getModifiers())) continue;
            this.generateConstructor(selfType, cons[i2], cw);
        }
    }

    private GeneratorAdapter createClassInitializer(Type selfType, ClassVisitor cw) {
        GeneratorAdapter clazzInit = new GeneratorAdapter(10, new org.jruby.org.objectweb.asm.commons.Method("<clinit>", Type.VOID_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, cw);
        clazzInit.visitLdcInsn(selfType.getClassName());
        clazzInit.invokeStatic(JAVA_LANG_CLASS_TYPE, CLASS_FORNAME_METHOD);
        clazzInit.invokeStatic(PROXY_HELPER_TYPE, HELPER_GET_PROXY_CLASS_METHOD);
        clazzInit.dup();
        clazzInit.putStatic(selfType, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        return clazzInit;
    }

    private void generateProxyMethod(Type selfType, Type superType, ClassVisitor cw, GeneratorAdapter clazzInit, MethodData md) {
        if (!md.generateProxyMethod()) {
            return;
        }
        org.jruby.org.objectweb.asm.commons.Method m = md.getMethod();
        Type[] ex = JavaProxyClassFactory.toType(md.getExceptions());
        String field_name = "__mth$" + md.getName() + md.scrambledSignature();
        FieldVisitor fv = cw.visitField(10, field_name, PROXY_METHOD_TYPE.getDescriptor(), null, null);
        fv.visitEnd();
        clazzInit.dup();
        clazzInit.push(m.getName());
        clazzInit.push(m.getDescriptor());
        clazzInit.push(md.isImplemented());
        clazzInit.invokeStatic(PROXY_HELPER_TYPE, PROXY_HELPER_GET_METHOD);
        clazzInit.putStatic(selfType, field_name, PROXY_METHOD_TYPE);
        org.jruby.org.objectweb.asm.commons.Method sm = new org.jruby.org.objectweb.asm.commons.Method("__super$" + m.getName(), m.getReturnType(), m.getArgumentTypes());
        GeneratorAdapter ga = new GeneratorAdapter(1, m, null, ex, cw);
        ga.loadThis();
        ga.getField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        if (md.isImplemented()) {
            ga.dup();
            Label ok = ga.newLabel();
            ga.ifNonNull(ok);
            ga.loadThis();
            ga.loadArgs();
            ga.invokeConstructor(superType, m);
            ga.returnValue();
            ga.mark(ok);
        }
        ga.loadThis();
        ga.getStatic(selfType, field_name, PROXY_METHOD_TYPE);
        if (m.getArgumentTypes().length == 0) {
            ga.getStatic(JAVA_PROXY_TYPE, "NO_ARGS", Type.getType(Object[].class));
        } else {
            ga.loadArgArray();
        }
        Label before = ga.mark();
        ga.invokeInterface(INVOCATION_HANDLER_TYPE, INVOCATION_HANDLER_INVOKE_METHOD);
        Label after = ga.mark();
        ga.unbox(m.getReturnType());
        ga.returnValue();
        Label rethrow = ga.mark();
        ga.visitInsn(191);
        for (int i2 = 0; i2 < ex.length; ++i2) {
            ga.visitTryCatchBlock(before, after, rethrow, ex[i2].getInternalName());
        }
        ga.visitTryCatchBlock(before, after, rethrow, "java/lang/Error");
        ga.visitTryCatchBlock(before, after, rethrow, "java/lang/RuntimeException");
        Type thr = Type.getType(Throwable.class);
        Label handler = ga.mark();
        Type udt = Type.getType(UndeclaredThrowableException.class);
        int loc = ga.newLocal(thr);
        ga.storeLocal(loc, thr);
        ga.newInstance(udt);
        ga.dup();
        ga.loadLocal(loc, thr);
        ga.invokeConstructor(udt, org.jruby.org.objectweb.asm.commons.Method.getMethod("void <init>(java.lang.Throwable)"));
        ga.throwException();
        ga.visitTryCatchBlock(before, after, handler, "java/lang/Throwable");
        ga.endMethod();
        if (md.isImplemented()) {
            GeneratorAdapter ga2 = new GeneratorAdapter(1, sm, null, ex, cw);
            ga2.loadThis();
            ga2.loadArgs();
            ga2.invokeConstructor(superType, m);
            ga2.returnValue();
            ga2.endMethod();
        }
    }

    private Class[] generateConstructor(Type selfType, Constructor constructor2, ClassVisitor cw) {
        Class[] superConstructorParameterTypes = constructor2.getParameterTypes();
        Class[] newConstructorParameterTypes = new Class[superConstructorParameterTypes.length + 1];
        System.arraycopy(superConstructorParameterTypes, 0, newConstructorParameterTypes, 0, superConstructorParameterTypes.length);
        newConstructorParameterTypes[superConstructorParameterTypes.length] = JavaProxyInvocationHandler.class;
        int access = 1;
        String name1 = "<init>";
        String signature = null;
        Class[] superConstructorExceptions = constructor2.getExceptionTypes();
        org.jruby.org.objectweb.asm.commons.Method super_m = new org.jruby.org.objectweb.asm.commons.Method(name1, Type.VOID_TYPE, JavaProxyClassFactory.toType(superConstructorParameterTypes));
        org.jruby.org.objectweb.asm.commons.Method m = new org.jruby.org.objectweb.asm.commons.Method(name1, Type.VOID_TYPE, JavaProxyClassFactory.toType(newConstructorParameterTypes));
        GeneratorAdapter ga = new GeneratorAdapter(access, m, signature, JavaProxyClassFactory.toType(superConstructorExceptions), cw);
        ga.loadThis();
        ga.loadArgs(0, superConstructorParameterTypes.length);
        ga.invokeConstructor(Type.getType(constructor2.getDeclaringClass()), super_m);
        ga.loadThis();
        ga.loadArg(superConstructorParameterTypes.length);
        ga.putField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        ga.returnValue();
        ga.endMethod();
        return newConstructorParameterTypes;
    }

    private static String toInternalClassName(Class clazz) {
        return JavaProxyClassFactory.toInternalClassName(clazz.getName());
    }

    private static String toInternalClassName(String name2) {
        return name2.replace('.', '/');
    }

    private static Type[] toType(Class[] parameterTypes) {
        Type[] result2 = new Type[parameterTypes.length];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = Type.getType(parameterTypes[i2]);
        }
        return result2;
    }

    private static Map<MethodKey, MethodData> collectMethods(Class superClass, Class[] interfaces2, Set names2) {
        HashMap<MethodKey, MethodData> methods2 = new HashMap<MethodKey, MethodData>();
        HashSet allClasses = new HashSet();
        JavaProxyClassFactory.addClass(allClasses, methods2, superClass, names2);
        JavaProxyClassFactory.addInterfaces(allClasses, methods2, interfaces2, names2);
        return methods2;
    }

    private static void addInterfaces(Set allClasses, Map methods2, Class[] interfaces2, Set names2) {
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            JavaProxyClassFactory.addInterface(allClasses, methods2, interfaces2[i2], names2);
        }
    }

    private static void addInterface(Set allClasses, Map methods2, Class interfaze, Set names2) {
        if (allClasses.add(interfaze)) {
            JavaProxyClassFactory.addMethods(methods2, interfaze, names2);
            JavaProxyClassFactory.addInterfaces(allClasses, methods2, interfaze.getInterfaces(), names2);
        }
    }

    private static void addMethods(Map methods2, Class classOrInterface, Set names2) {
        Method[] mths = classOrInterface.getDeclaredMethods();
        for (int i2 = 0; i2 < mths.length; ++i2) {
            if (names2 != null && !names2.contains(mths[i2].getName())) continue;
            JavaProxyClassFactory.addMethod(methods2, mths[i2]);
        }
    }

    private static void addMethod(Map methods2, Method method) {
        int acc = method.getModifiers();
        if (Modifier.isStatic(acc) || Modifier.isPrivate(acc)) {
            return;
        }
        MethodKey mk = new MethodKey(method);
        MethodData md = (MethodData)methods2.get(mk);
        if (md == null) {
            md = new MethodData(method);
            methods2.put(mk, md);
        }
        md.add(method);
    }

    private static void addClass(Set allClasses, Map methods2, Class clazz, Set names2) {
        if (allClasses.add(clazz)) {
            JavaProxyClassFactory.addMethods(methods2, clazz, names2);
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                JavaProxyClassFactory.addClass(allClasses, methods2, superClass, names2);
            }
            JavaProxyClassFactory.addInterfaces(allClasses, methods2, clazz.getInterfaces(), names2);
        }
    }

    private static void validateArgs(Ruby runtime, String targetClassName, Class superClass) {
        if (Modifier.isFinal(superClass.getModifiers())) {
            throw runtime.newTypeError("cannot extend final class " + superClass.getName());
        }
        if (!JavaProxyClassFactory.hasPublicOrProtectedConstructors(superClass)) {
            throw runtime.newTypeError("class " + superClass.getName() + " doesn't have any public or private constructors");
        }
        String targetPackage = JavaProxyClassFactory.packageName(targetClassName);
        String pkg = targetPackage.replace('.', '/');
        if (pkg.startsWith("java")) {
            throw runtime.newTypeError("cannot add classes to package " + pkg);
        }
        Package p2 = Package.getPackage(pkg);
        if (p2 != null && p2.isSealed()) {
            throw runtime.newTypeError("package " + p2 + " is sealed");
        }
    }

    private static boolean hasPublicOrProtectedConstructors(Class superClass) {
        Constructor<?>[] constructors2 = superClass.getDeclaredConstructors();
        boolean hasPublicOrProtectedConstructors = false;
        for (Constructor<?> constructor2 : constructors2) {
            if (!Modifier.isPublic(constructor2.getModifiers()) && !Modifier.isProtected(constructor2.getModifiers())) continue;
            hasPublicOrProtectedConstructors = true;
        }
        return hasPublicOrProtectedConstructors;
    }

    private static String packageName(String clazzName) {
        int idx = clazzName.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return clazzName.substring(0, idx);
    }

    private static String proxyPackageName(Class clazz) {
        String clazzName = clazz.getName();
        int idx = clazzName.lastIndexOf(46);
        if (idx == -1) {
            return "org.jruby.proxy";
        }
        return "org.jruby.proxy." + clazzName.substring(0, idx);
    }

    static {
        PROXY_CLASS_FACTORY = Options.JI_PROXYCLASSFACTORY.load();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    defineClass_method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                defineClass_method.setAccessible(true);
                return null;
            }
        });
    }

    static class MethodKey {
        private String name;
        private Class[] arguments;

        MethodKey(Method m) {
            this.name = m.getName();
            this.arguments = m.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey key2 = (MethodKey)obj;
                return this.name.equals(key2.name) && Arrays.equals(this.arguments, key2.arguments);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    static class MethodData {
        Set methods = new HashSet();
        final Method mostSpecificMethod;
        final Class[] mostSpecificParameterTypes;
        boolean hasPublicDecl = false;

        MethodData(Method method) {
            this.mostSpecificMethod = method;
            this.mostSpecificParameterTypes = this.mostSpecificMethod.getParameterTypes();
            this.hasPublicDecl = method.getDeclaringClass().isInterface() || Modifier.isPublic(method.getModifiers());
        }

        public String scrambledSignature() {
            StringBuilder sb = new StringBuilder();
            Class[] parms = this.getParameterTypes();
            for (int i2 = 0; i2 < parms.length; ++i2) {
                sb.append('$');
                String name2 = parms[i2].getName();
                name2 = name2.replace('[', '1');
                name2 = name2.replace('.', '_');
                name2 = name2.replace(';', '2');
                sb.append(name2);
            }
            return sb.toString();
        }

        public Class getDeclaringClass() {
            return this.mostSpecificMethod.getDeclaringClass();
        }

        public org.jruby.org.objectweb.asm.commons.Method getMethod() {
            return new org.jruby.org.objectweb.asm.commons.Method(this.getName(), Type.getType(this.getReturnType()), this.getType(this.getParameterTypes()));
        }

        private Type[] getType(Class[] parameterTypes) {
            Type[] result2 = new Type[parameterTypes.length];
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                result2[i2] = Type.getType(parameterTypes[i2]);
            }
            return result2;
        }

        private String getName() {
            return this.mostSpecificMethod.getName();
        }

        private Class[] getParameterTypes() {
            return this.mostSpecificParameterTypes;
        }

        public Class[] getExceptions() {
            HashSet all = new HashSet();
            for (Method m : this.methods) {
                Class<?>[] ex = m.getExceptionTypes();
                for (int i2 = 0; i2 < ex.length; ++i2) {
                    Class<?> exx = ex[i2];
                    if (all.contains(exx)) continue;
                    boolean add2 = true;
                    Iterator it2 = all.iterator();
                    while (it2.hasNext()) {
                        Class de = (Class)it2.next();
                        if (de.isAssignableFrom(exx)) {
                            add2 = false;
                            break;
                        }
                        if (!exx.isAssignableFrom(de)) continue;
                        it2.remove();
                        add2 = true;
                    }
                    if (!add2) continue;
                    all.add(exx);
                }
            }
            return all.toArray(new Class[all.size()]);
        }

        public boolean generateProxyMethod() {
            return !this.isFinal() && !this.isPrivate();
        }

        public void add(Method method) {
            this.methods.add(method);
            this.hasPublicDecl |= Modifier.isPublic(method.getModifiers());
        }

        Class getReturnType() {
            return this.mostSpecificMethod.getReturnType();
        }

        boolean isFinal() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int mod = this.mostSpecificMethod.getModifiers();
            return Modifier.isFinal(mod);
        }

        boolean isPrivate() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int mod = this.mostSpecificMethod.getModifiers();
            return Modifier.isPrivate(mod);
        }

        boolean isImplemented() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int mod = this.mostSpecificMethod.getModifiers();
            return !Modifier.isAbstract(mod);
        }
    }
}

