/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.invokers.ConstructorInvoker;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.SingletonMethodInvoker;
import org.jruby.java.invokers.StaticFieldGetter;
import org.jruby.java.invokers.StaticFieldSetter;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Java::JavaClass"}, parent="Java::JavaObject")
public class JavaClass
extends JavaObject {
    private static final Logger LOG = LoggerFactory.getLogger("JavaClass");
    public static final String METHOD_MANGLE = "__method";
    public static final boolean DEBUG_SCALA = false;
    public static final boolean CAN_SET_ACCESSIBLE;
    private static final Map<String, AssignedName> RESERVED_NAMES;
    private static final Map<String, AssignedName> STATIC_RESERVED_NAMES;
    private static final Map<String, AssignedName> INSTANCE_RESERVED_NAMES;
    private final RubyModule JAVA_UTILITIES = this.getRuntime().getJavaSupport().getJavaUtilitiesModule();
    private Map<String, AssignedName> staticAssignedNames;
    private Map<String, AssignedName> instanceAssignedNames;
    private Map<String, NamedInstaller> staticInstallers;
    private Map<String, NamedInstaller> instanceInstallers;
    private ConstructorInvokerInstaller constructorInstaller;
    private List<ConstantField> constantFields;
    private volatile RubyArray constructors;
    private volatile ArrayList<IRubyObject> proxyExtenders;
    private volatile RubyModule proxyModule;
    private volatile RubyClass proxyClass;
    private RubyModule unfinishedProxyModule;
    private RubyClass unfinishedProxyClass;
    private final ReentrantLock proxyLock = new ReentrantLock();
    private final Initializer initializer;
    private static final Initializer DUMMY_INITIALIZER;
    private static final Map<String, String> SCALA_OPERATORS;
    private static Map<String, Class> PRIMITIVE_TO_CLASS;
    private static final int ACC_BRIDGE = 64;

    private void handleScalaSingletons(Class<?> javaClass, InitializerState state2) {
        try {
            ClassLoader cl = javaClass.getClassLoader();
            if (cl == null) {
                return;
            }
            Class<?> companionClass = cl.loadClass(javaClass.getName() + "$");
            Field field2 = companionClass.getField("MODULE$");
            Object singleton = field2.get(null);
            if (singleton != null) {
                Method[] sMethods = JavaClass.getMethods(companionClass);
                for (int j = sMethods.length - 1; j >= 0; --j) {
                    Method method = sMethods[j];
                    String name2 = method.getName();
                    if (name2.indexOf("$") >= 0) {
                        name2 = JavaClass.fixScalaNames(name2);
                    }
                    if (Modifier.isStatic(method.getModifiers())) continue;
                    AssignedName assignedName = state2.staticNames.get(name2);
                    if (INSTANCE_RESERVED_NAMES.containsKey(method.getName())) {
                        this.installSingletonMethods(state2.staticCallbacks, javaClass, singleton, method, name2 + METHOD_MANGLE);
                        continue;
                    }
                    if (assignedName == null) {
                        state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
                    } else {
                        if (Priority.METHOD.lessImportantThan(assignedName)) continue;
                        if (!Priority.METHOD.asImportantAs(assignedName)) {
                            state2.staticCallbacks.remove(name2);
                            state2.staticCallbacks.remove(name2 + '=');
                            state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
                        }
                    }
                    this.installSingletonMethods(state2.staticCallbacks, javaClass, singleton, method, name2);
                }
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public RubyModule getProxyModule() {
        RubyModule proxy2 = this.proxyModule;
        if (proxy2 != null) {
            return proxy2;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyModule;
        }
        return null;
    }

    public RubyClass getProxyClass() {
        RubyClass proxy2 = this.proxyClass;
        if (proxy2 != null) {
            return proxy2;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyClass;
        }
        return null;
    }

    public void lockProxy() {
        this.proxyLock.lock();
    }

    public void unlockProxy() {
        this.proxyLock.unlock();
    }

    private Map<String, AssignedName> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    private Map<String, AssignedName> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    public JavaClass(Ruby runtime, Class<?> javaClass) {
        super(runtime, runtime.getJavaSupport().getJavaClassClass(), javaClass);
        this.initializer = javaClass.isInterface() ? new InterfaceInitializer(javaClass) : (!javaClass.isArray() && !javaClass.isPrimitive() ? new ClassInitializer(javaClass) : DUMMY_INITIALIZER);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaClass && this.getValue() == ((JavaClass)other).getValue();
    }

    @Override
    public int hashCode() {
        return this.javaClass().hashCode();
    }

    public void setupProxy(RubyClass proxy2) {
        assert (this.proxyLock.isHeldByCurrentThread());
        this.initializer.initialize();
        proxy2.addMethod("__jsend!", new JavaMethod.JavaMethodNBlock(proxy2, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                String callName = args2[0].asJavaString();
                DynamicMethod method = self2.getMetaClass().searchMethod(callName);
                int v = method.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
                System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
                if (v < 0 || v == newArgs.length) {
                    return Helpers.invoke(context, self2, callName, newArgs, Block.NULL_BLOCK);
                }
                RubyClass superClass = self2.getMetaClass().getSuperClass();
                return Helpers.invokeAs(context, superClass, self2, callName, newArgs, Block.NULL_BLOCK);
            }
        });
        Class javaClass = this.javaClass();
        if (javaClass.isInterface()) {
            this.setupInterfaceProxy(proxy2);
            return;
        }
        proxy2.setReifiedClass(javaClass);
        assert (this.proxyClass == null);
        this.unfinishedProxyClass = proxy2;
        if (javaClass.isArray() || javaClass.isPrimitive()) {
            this.proxyClass = proxy2;
            this.proxyModule = proxy2;
            return;
        }
        this.installClassFields(proxy2);
        this.installClassMethods(proxy2);
        this.installClassConstructors(proxy2);
        this.installClassClasses(javaClass, proxy2);
        proxy2.setJavaProxy(true);
        proxy2.getSingletonClass().setJavaProxy(true);
        proxy2.setBaseName(javaClass.getSimpleName());
        RubyModule parent = javaClass.getEnclosingClass() != null ? Java.getProxyClass(this.getRuntime(), javaClass.getEnclosingClass()) : Java.getJavaPackageModule(this.getRuntime(), javaClass.getPackage());
        proxy2.setParent(parent);
        this.proxyClass = proxy2;
        this.proxyModule = proxy2;
        this.applyProxyExtenders();
    }

    private static void assignAliases(MethodInstaller installer, Map<String, AssignedName> assignedNames) {
        String name2 = installer.name;
        String rubyCasedName = JavaUtil.getRubyCasedName(name2);
        JavaClass.addUnassignedAlias(rubyCasedName, assignedNames, installer);
        String javaPropertyName = JavaUtil.getJavaPropertyName(name2);
        String rubyPropertyName = null;
        for (Method method : installer.methods) {
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (rubyCasedName.equals("apply")) {
                JavaClass.addUnassignedAlias("[]", assignedNames, installer);
            }
            if (rubyCasedName.equals("update") && argCount == 2) {
                JavaClass.addUnassignedAlias("[]=", assignedNames, installer);
            }
            if (name2.startsWith("$")) {
                JavaClass.addUnassignedAlias(JavaClass.fixScalaNames(name2), assignedNames, installer);
            }
            if (javaPropertyName != null) {
                if (rubyCasedName.startsWith("get_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 0 || argCount == 1 && argTypes[0] == Integer.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("set_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 1 && resultType == Void.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName + '=', assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName + '=', assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("is_")) {
                    rubyPropertyName = rubyCasedName.substring(3);
                    if (resultType == Boolean.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                }
            }
            if (resultType != Boolean.TYPE) continue;
            JavaClass.addUnassignedAlias(rubyCasedName + '?', assignedNames, installer);
            if (rubyPropertyName == null) continue;
            JavaClass.addUnassignedAlias(rubyPropertyName + '?', assignedNames, installer);
        }
    }

    private static void addUnassignedAlias(String name2, Map<String, AssignedName> assignedNames, MethodInstaller installer) {
        if (name2 == null) {
            return;
        }
        AssignedName assignedName = assignedNames.get(name2);
        if (Priority.ALIAS.moreImportantThan(assignedName)) {
            installer.addAlias(name2);
            assignedNames.put(name2, new AssignedName(name2, Priority.ALIAS));
        } else if (Priority.ALIAS.asImportantAs(assignedName)) {
            installer.addAlias(name2);
        }
    }

    private void installClassClasses(Class<?> javaClass, RubyModule proxy2) {
        Class<?>[] classes2 = JavaClass.getDeclaredClasses(javaClass);
        int i2 = classes2.length;
        while (--i2 >= 0) {
            String simpleName;
            Class<?> clazz;
            if (javaClass != classes2[i2].getDeclaringClass() || !Modifier.isPublic((clazz = classes2[i2]).getModifiers()) || (simpleName = JavaClass.getSimpleName(clazz)).length() == 0) continue;
            final IRubyObject innerProxy = Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz));
            if (IdUtil.isConstant(simpleName)) {
                if (proxy2.getConstantAt(simpleName) != null) continue;
                proxy2.const_set(this.getRuntime().newString(simpleName), innerProxy);
                continue;
            }
            if (proxy2.respondsTo(simpleName)) continue;
            proxy2.getSingletonClass().addMethod(simpleName, new JavaMethod.JavaMethodZero(proxy2.getSingletonClass(), Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                    return innerProxy;
                }
            });
        }
    }

    private synchronized void installClassConstructors(RubyClass proxy2) {
        if (this.constructorInstaller != null) {
            this.constructorInstaller.install(proxy2);
            this.constructorInstaller = null;
        }
    }

    private synchronized void installClassFields(RubyClass proxy2) {
        assert (this.constantFields != null);
        for (ConstantField field2 : this.constantFields) {
            field2.install(proxy2);
        }
        this.constantFields = null;
    }

    private synchronized void installClassMethods(RubyClass proxy2) {
        assert (this.staticInstallers != null);
        for (NamedInstaller installer : this.staticInstallers.values()) {
            installer.install(proxy2);
        }
        this.staticInstallers = null;
        assert (this.instanceInstallers != null);
        for (NamedInstaller installer : this.instanceInstallers.values()) {
            installer.install(proxy2);
        }
        this.instanceInstallers = null;
    }

    private void setupClassConstructors(Class<?> javaClass) {
        Constructor[] clsConstructors = JavaClass.getConstructors(javaClass);
        this.constructorInstaller = new ConstructorInvokerInstaller("__jcreate!");
        int i2 = clsConstructors.length;
        while (--i2 >= 0) {
            Constructor ctor = clsConstructors[i2];
            this.constructorInstaller.addConstructor(ctor, javaClass);
        }
    }

    private void addField(Map<String, NamedInstaller> callbacks, Map<String, AssignedName> names2, Field field2, boolean isFinal, boolean isStatic) {
        String name2 = field2.getName();
        if (Priority.FIELD.lessImportantThan(names2.get(name2))) {
            return;
        }
        names2.put(name2, new AssignedName(name2, Priority.FIELD));
        callbacks.put(name2, isStatic ? new StaticFieldGetterInstaller(name2, field2) : new InstanceFieldGetterInstaller(name2, field2));
        if (!isFinal) {
            String setName = name2 + '=';
            callbacks.put(setName, isStatic ? new StaticFieldSetterInstaller(setName, field2) : new InstanceFieldSetterInstaller(setName, field2));
        }
    }

    private void setupClassFields(Class<?> javaClass, InitializerState state2) {
        Field[] fields2 = JavaClass.getFields(javaClass);
        int i2 = fields2.length;
        while (--i2 >= 0) {
            Field field2 = fields2[i2];
            if (javaClass != field2.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field2)) {
                state2.constantFields.add(new ConstantField(field2));
                continue;
            }
            int modifiers2 = field2.getModifiers();
            if (Modifier.isStatic(modifiers2)) {
                this.addField(state2.staticCallbacks, state2.staticNames, field2, Modifier.isFinal(modifiers2), true);
                continue;
            }
            this.addField(state2.instanceCallbacks, state2.instanceNames, field2, Modifier.isFinal(modifiers2), false);
        }
    }

    private static String fixScalaNames(String name2) {
        String s2 = name2;
        for (Map.Entry<String, String> entry : SCALA_OPERATORS.entrySet()) {
            s2 = s2.replaceAll(entry.getKey(), entry.getValue());
        }
        return s2;
    }

    private void setupClassMethods(Class<?> javaClass, InitializerState state2) {
        Method[] methods2 = JavaClass.getMethods(javaClass);
        int i2 = methods2.length;
        while (--i2 >= 0) {
            Method method = methods2[i2];
            String name2 = method.getName();
            if (Modifier.isStatic(method.getModifiers())) {
                this.prepareStaticMethod(javaClass, state2, method, name2);
                continue;
            }
            this.prepareInstanceMethod(javaClass, state2, method, name2);
        }
        this.handleScalaSingletons(javaClass, state2);
        this.assignStaticAliases(state2);
        this.assignInstanceAliases(state2);
    }

    private void prepareInstanceMethod(Class<?> javaClass, InitializerState state2, Method method, String name2) {
        AssignedName assignedName = state2.instanceNames.get(name2);
        if (INSTANCE_RESERVED_NAMES.containsKey(method.getName())) {
            this.installInstanceMethods(state2.instanceCallbacks, javaClass, method, name2 + METHOD_MANGLE);
            return;
        }
        if (assignedName == null) {
            state2.instanceNames.put(name2, new AssignedName(name2, Priority.METHOD));
        } else {
            if (Priority.METHOD.lessImportantThan(assignedName)) {
                return;
            }
            if (!Priority.METHOD.asImportantAs(assignedName)) {
                state2.instanceCallbacks.remove(name2);
                state2.instanceCallbacks.remove(name2 + '=');
                state2.instanceNames.put(name2, new AssignedName(name2, Priority.METHOD));
            }
        }
        this.installInstanceMethods(state2.instanceCallbacks, javaClass, method, name2);
    }

    private void assignInstanceAliases(InitializerState state2) {
        for (Map.Entry<String, NamedInstaller> entry : state2.instanceCallbacks.entrySet()) {
            if (entry.getValue().type != 4) continue;
            MethodInstaller methodInstaller = (MethodInstaller)entry.getValue();
            if (entry.getKey().endsWith(METHOD_MANGLE)) continue;
            if (methodInstaller.hasLocalMethod()) {
                JavaClass.assignAliases(methodInstaller, state2.instanceNames);
            }
            if (!entry.getKey().equals("equals")) continue;
            methodInstaller.setLocalMethod(true);
            methodInstaller.addAlias("==");
        }
    }

    private void setupInterfaceMethods(Class<?> javaClass, InitializerState state2) {
        Method[] methods2 = JavaClass.getMethods(javaClass);
        int i2 = methods2.length;
        while (--i2 >= 0) {
            Method method = methods2[i2];
            String name2 = method.getName();
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.prepareStaticMethod(javaClass, state2, method, name2);
        }
        this.assignStaticAliases(state2);
    }

    private void assignStaticAliases(InitializerState state2) {
        for (Map.Entry<String, NamedInstaller> entry : state2.staticCallbacks.entrySet()) {
            if (entry.getKey().endsWith(METHOD_MANGLE) || entry.getValue().type != 2 || !entry.getValue().hasLocalMethod()) continue;
            JavaClass.assignAliases((MethodInstaller)entry.getValue(), state2.staticNames);
        }
    }

    private void prepareStaticMethod(Class<?> javaClass, InitializerState state2, Method method, String name2) {
        AssignedName assignedName = state2.staticNames.get(name2);
        if (STATIC_RESERVED_NAMES.containsKey(method.getName())) {
            this.installStaticMethods(state2.staticCallbacks, javaClass, method, name2 + METHOD_MANGLE);
            return;
        }
        if (assignedName == null) {
            state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
        } else {
            if (Priority.METHOD.lessImportantThan(assignedName)) {
                return;
            }
            if (!Priority.METHOD.asImportantAs(assignedName)) {
                state2.staticCallbacks.remove(name2);
                state2.staticCallbacks.remove(name2 + '=');
                state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
            }
        }
        this.installStaticMethods(state2.staticCallbacks, javaClass, method, name2);
    }

    private void installInstanceMethods(Map<String, NamedInstaller> methodCallbacks, Class<?> javaClass, Method method, String name2) {
        MethodInstaller invoker = (MethodInstaller)methodCallbacks.get(name2);
        if (invoker == null) {
            invoker = new InstanceMethodInvokerInstaller(name2);
            methodCallbacks.put(name2, invoker);
        }
        invoker.addMethod(method, javaClass);
    }

    private void installStaticMethods(Map<String, NamedInstaller> methodCallbacks, Class<?> javaClass, Method method, String name2) {
        MethodInstaller invoker = (MethodInstaller)methodCallbacks.get(name2);
        if (invoker == null) {
            invoker = new StaticMethodInvokerInstaller(name2);
            methodCallbacks.put(name2, invoker);
        }
        invoker.addMethod(method, javaClass);
    }

    private void installSingletonMethods(Map<String, NamedInstaller> methodCallbacks, Class<?> javaClass, Object singleton, Method method, String name2) {
        MethodInstaller invoker = (MethodInstaller)methodCallbacks.get(name2);
        if (invoker == null) {
            invoker = new SingletonMethodInvokerInstaller(name2, singleton);
            methodCallbacks.put(name2, invoker);
        }
        invoker.addMethod(method, javaClass);
    }

    private void setupInterfaceProxy(RubyClass proxy2) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyClass == null);
        this.initializer.initialize();
        this.proxyClass = proxy2;
    }

    public void setupInterfaceModule(RubyModule module) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyModule == null);
        this.initializer.initialize();
        this.unfinishedProxyModule = module;
        Class javaClass = this.javaClass();
        for (ConstantField field2 : this.constantFields) {
            field2.install(module);
        }
        for (NamedInstaller installer : this.staticInstallers.values()) {
            installer.install(module);
        }
        this.installClassClasses(javaClass, module);
        module.setJavaProxy(true);
        module.getSingletonClass().setJavaProxy(true);
        this.proxyModule = module;
        this.applyProxyExtenders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyExtender(IRubyObject extender) {
        this.lockProxy();
        try {
            if (!extender.respondsTo("extend_proxy")) {
                throw this.getRuntime().newTypeError("proxy extender must have an extend_proxy method");
            }
            if (this.proxyModule == null) {
                if (this.proxyExtenders == null) {
                    this.proxyExtenders = new ArrayList();
                }
                this.proxyExtenders.add(extender);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.PROXY_EXTENDED_LATE, " proxy extender added after proxy class created for " + this);
                this.extendProxy(extender);
            }
        }
        finally {
            this.unlockProxy();
        }
    }

    private void applyProxyExtenders() {
        ArrayList<IRubyObject> extenders = this.proxyExtenders;
        if (extenders != null) {
            for (IRubyObject extender : extenders) {
                this.extendProxy(extender);
            }
            this.proxyExtenders = null;
        }
    }

    private void extendProxy(IRubyObject extender) {
        extender.callMethod(this.getRuntime().getCurrentContext(), "extend_proxy", this.proxyModule);
    }

    @JRubyMethod(required=1)
    public IRubyObject extend_proxy(IRubyObject extender) {
        this.addProxyExtender(extender);
        return this.getRuntime().getNil();
    }

    public static JavaClass get(Ruby runtime, Class<?> klass) {
        return runtime.getJavaSupport().getJavaClassFromCache(klass);
    }

    public static RubyArray getRubyArray(Ruby runtime, Class<?>[] classes2) {
        IRubyObject[] javaClasses = new IRubyObject[classes2.length];
        int i2 = classes2.length;
        while (--i2 >= 0) {
            javaClasses[i2] = JavaClass.get(runtime, classes2[i2]);
        }
        return runtime.newArrayNoCopy(javaClasses);
    }

    public static RubyClass createJavaClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result2 = javaModule.defineClassUnder("JavaClass", javaModule.getClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result2.includeModule(runtime.getModule("Comparable"));
        result2.defineAnnotatedMethods(JavaClass.class);
        result2.getMetaClass().undefineMethod("new");
        result2.getMetaClass().undefineMethod("allocate");
        return result2;
    }

    public static synchronized JavaClass forNameVerbose(Ruby runtime, String className) {
        Class klass = null;
        if (className.indexOf(".") == -1 && Character.isLowerCase(className.charAt(0))) {
            klass = PRIMITIVE_TO_CLASS.get(className);
        }
        if (klass == null) {
            klass = runtime.getJavaSupport().loadJavaClassVerbose(className);
        }
        return JavaClass.get(runtime, klass);
    }

    public static synchronized JavaClass forNameQuiet(Ruby runtime, String className) {
        Class klass = runtime.getJavaSupport().loadJavaClassQuiet(className);
        return JavaClass.get(runtime, klass);
    }

    @JRubyMethod(name={"for_name"}, required=1, meta=true)
    public static JavaClass for_name(IRubyObject recv2, IRubyObject name2) {
        return JavaClass.forNameVerbose(recv2.getRuntime(), name2.asJavaString());
    }

    @JRubyMethod
    public RubyModule ruby_class() {
        return Java.getProxyClass(this.getRuntime(), this.javaClass());
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"protected?"})
    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    public Class javaClass() {
        return (Class)this.getValue();
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"interface?"})
    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    @JRubyMethod(name={"array?"})
    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    @JRubyMethod(name={"enum?"})
    public RubyBoolean enum_p() {
        return this.getRuntime().newBoolean(this.javaClass().isEnum());
    }

    @JRubyMethod(name={"annotation?"})
    public RubyBoolean annotation_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnnotation());
    }

    @JRubyMethod(name={"anonymous_class?"})
    public RubyBoolean anonymous_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnonymousClass());
    }

    @JRubyMethod(name={"local_class?"})
    public RubyBoolean local_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isLocalClass());
    }

    @JRubyMethod(name={"member_class?"})
    public RubyBoolean member_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isMemberClass());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(this.javaClass().isSynthetic());
    }

    @JRubyMethod(name={"name", "to_s"})
    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    @Override
    @JRubyMethod
    public RubyString inspect() {
        return this.getRuntime().newString("class " + this.javaClass().getName());
    }

    @JRubyMethod
    public IRubyObject canonical_name() {
        String canonicalName = this.javaClass().getCanonicalName();
        if (canonicalName != null) {
            return this.getRuntime().newString(canonicalName);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"package"})
    public IRubyObject get_package() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getPackage());
    }

    @JRubyMethod
    public IRubyObject class_loader() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getClassLoader());
    }

    @JRubyMethod
    public IRubyObject protection_domain() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getProtectionDomain());
    }

    @JRubyMethod(required=1)
    public IRubyObject resource(IRubyObject name2) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResource(name2.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_stream(IRubyObject name2) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResourceAsStream(name2.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_string(IRubyObject name2) {
        InputStream in = this.javaClass().getResourceAsStream(name2.asJavaString());
        if (in == null) {
            return this.getRuntime().getNil();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
        return this.getRuntime().newString(new ByteList(out.toByteArray(), false));
    }

    @JRubyMethod(required=1)
    public IRubyObject annotation(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotation(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"}, required=1)
    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.javaClass().isAnnotationPresent(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(this.javaClass().getModifiers());
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = this.javaClass().getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_class() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnclosingClass());
    }

    @JRubyMethod
    public IRubyObject enclosing_constructor() {
        Constructor<?> ctor = this.javaClass().getEnclosingConstructor();
        if (ctor != null) {
            return new JavaConstructor(this.getRuntime(), ctor);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_method() {
        Method meth = this.javaClass().getEnclosingMethod();
        if (meth != null) {
            return new JavaMethod(this.getRuntime(), meth);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enum_constants() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnumConstants());
    }

    @JRubyMethod
    public IRubyObject generic_interfaces() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericInterfaces());
    }

    @JRubyMethod
    public IRubyObject generic_superclass() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericSuperclass());
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject signers() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getSigners());
    }

    private static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaClass.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int len = className.length();
        int i2 = className.lastIndexOf(36);
        if (i2 != -1) {
            while (++i2 < len && Character.isDigit(className.charAt(i2))) {
            }
            return className.substring(i2);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @JRubyMethod
    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    @JRubyMethod
    public IRubyObject superclass() {
        Class superclass2 = this.javaClass().getSuperclass();
        if (superclass2 == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass2);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject other) {
        ConcreteJavaProxy proxy2;
        Class me = this.javaClass();
        Class them = null;
        if (other instanceof JavaClass) {
            JavaClass otherClass = (JavaClass)other;
            them = otherClass.javaClass();
        } else if (other instanceof ConcreteJavaProxy && (proxy2 = (ConcreteJavaProxy)other).getObject() instanceof Class) {
            them = (Class)proxy2.getObject();
        }
        if (them != null) {
            if (this.javaClass() == them) {
                return this.getRuntime().newFixnum(0);
            }
            if (them.isAssignableFrom(me)) {
                return this.getRuntime().newFixnum(-1);
            }
            if (me.isAssignableFrom(them)) {
                return this.getRuntime().newFixnum(1);
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    @JRubyMethod
    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methods2, boolean isStatic) {
        RubyArray result2 = this.getRuntime().newArray(methods2.length);
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            Method method = methods2[i2];
            if (isStatic != Modifier.isStatic(method.getModifiers())) continue;
            result2.append(JavaMethod.create(this.getRuntime(), method));
        }
        return result2;
    }

    @JRubyMethod
    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    @JRubyMethod
    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod java_method(IRubyObject[] args2) {
        String methodName = args2[0].asJavaString();
        try {
            Class<?>[] argumentTypes = this.buildArgumentTypes(args2);
            return JavaMethod.create(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
        }
        catch (ClassNotFoundException cnfe) {
            throw this.getRuntime().newNameError("undefined method '" + methodName + "' for class '" + this.javaClass().getName() + "'", methodName);
        }
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod declared_method(IRubyObject[] args2) {
        String methodName = args2[0].asJavaString();
        try {
            Class<?>[] argumentTypes = this.buildArgumentTypes(args2);
            return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
        }
        catch (ClassNotFoundException cnfe) {
            throw this.getRuntime().newNameError("undefined method '" + methodName + "' for class '" + this.javaClass().getName() + "'", methodName);
        }
    }

    @JRubyMethod(required=1, rest=true)
    public JavaCallable declared_method_smart(IRubyObject[] args2) {
        String methodName = args2[0].asJavaString();
        try {
            Class<?>[] argumentTypes = this.buildArgumentTypes(args2);
            JavaCallable callable = JavaClass.getMatchingCallable(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
            if (callable != null) {
                return callable;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw this.getRuntime().newNameError("undefined method '" + methodName + "' for class '" + this.javaClass().getName() + "'", methodName);
    }

    public static JavaCallable getMatchingCallable(Ruby runtime, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        if ("<init>".equals(methodName)) {
            return JavaConstructor.getMatchingConstructor(runtime, javaClass, argumentTypes);
        }
        return JavaMethod.getMatchingDeclaredMethod(runtime, javaClass, methodName, argumentTypes);
    }

    private Class<?>[] buildArgumentTypes(IRubyObject[] args2) throws ClassNotFoundException {
        if (args2.length < 1) {
            throw this.getRuntime().newArgumentError(args2.length, 1);
        }
        Class[] argumentTypes = new Class[args2.length - 1];
        for (int i2 = 1; i2 < args2.length; ++i2) {
            JavaClass type2 = args2[i2] instanceof JavaClass ? (JavaClass)args2[i2] : (args2[i2].respondsTo("java_class") ? (JavaClass)args2[i2].callMethod(this.getRuntime().getCurrentContext(), "java_class") : JavaClass.for_name(this, args2[i2]));
            argumentTypes[i2 - 1] = type2.javaClass();
        }
        return argumentTypes;
    }

    @JRubyMethod
    public RubyArray constructors() {
        RubyArray ctors = this.constructors;
        if (ctors != null) {
            return ctors;
        }
        this.constructors = this.buildConstructors(this.javaClass().getConstructors());
        return this.constructors;
    }

    @JRubyMethod
    public RubyArray classes() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getClasses());
    }

    @JRubyMethod
    public RubyArray declared_classes() {
        Ruby runtime = this.getRuntime();
        RubyArray result2 = runtime.newArray();
        Class javaClass = this.javaClass();
        try {
            Class<?>[] classes2 = javaClass.getDeclaredClasses();
            for (int i2 = 0; i2 < classes2.length; ++i2) {
                if (!Modifier.isPublic(classes2[i2].getModifiers())) continue;
                result2.append(JavaClass.get(runtime, classes2[i2]));
            }
        }
        catch (SecurityException e) {
            try {
                Class<?>[] classes3 = javaClass.getClasses();
                for (int i3 = 0; i3 < classes3.length; ++i3) {
                    if (javaClass != classes3[i3].getDeclaringClass()) continue;
                    result2.append(JavaClass.get(runtime, classes3[i3]));
                }
            }
            catch (SecurityException e2) {
                // empty catch block
            }
        }
        return result2;
    }

    @JRubyMethod
    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor<?>[] constructors2) {
        RubyArray result2 = this.getRuntime().newArray(constructors2.length);
        for (int i2 = 0; i2 < constructors2.length; ++i2) {
            result2.append(new JavaConstructor(this.getRuntime(), constructors2[i2]));
        }
        return result2;
    }

    @JRubyMethod(rest=true)
    public JavaConstructor constructor(IRubyObject[] args2) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args2);
            Constructor constructor2 = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor2);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    @JRubyMethod(rest=true)
    public JavaConstructor declared_constructor(IRubyObject[] args2) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args2);
            Constructor constructor2 = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor2);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class<?>[] buildClassArgs(IRubyObject[] args2) {
        Class[] parameterTypes = new Class[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            JavaClass type2 = args2[i2] instanceof JavaClass ? (JavaClass)args2[i2] : (args2[i2].respondsTo("java_class") ? (JavaClass)args2[i2].callMethod(this.getRuntime().getCurrentContext(), "java_class") : JavaClass.for_name(this, args2[i2]));
            parameterTypes[i2] = type2.javaClass();
        }
        return parameterTypes;
    }

    @JRubyMethod
    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    @JRubyMethod(required=1)
    public JavaObject new_array(IRubyObject lengthArgument) {
        if (lengthArgument instanceof RubyInteger) {
            int length2 = (int)((RubyInteger)lengthArgument).getLongValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length2));
        }
        if (lengthArgument instanceof RubyArray) {
            List list2 = ((RubyArray)lengthArgument).getList();
            int length3 = list2.size();
            if (length3 == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] dimensions2 = new int[length3];
            int i2 = length3;
            while (--i2 >= 0) {
                IRubyObject dimensionLength = (IRubyObject)list2.get(i2);
                if (!(dimensionLength instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(dimensionLength, this.getRuntime().getInteger());
                }
                dimensions2[i2] = (int)((RubyInteger)dimensionLength).getLongValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), dimensions2));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    public IRubyObject emptyJavaArray(ThreadContext context) {
        return ArrayUtils.emptyJavaArrayDirect(context, this.javaClass());
    }

    public IRubyObject javaArraySubarray(ThreadContext context, JavaArray fromArray, int index2, int size2) {
        return ArrayUtils.javaArraySubarrayDirect(context, this.getValue(), index2, size2);
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, JavaArray additional) {
        return ArrayUtils.concatArraysDirect(context, original.getValue(), additional.getValue());
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, IRubyObject additional) {
        return ArrayUtils.concatArraysDirect(context, original.getValue(), additional);
    }

    public IRubyObject javaArrayFromRubyArray(ThreadContext context, IRubyObject fromArray) {
        Ruby runtime = context.runtime;
        if (!(fromArray instanceof RubyArray)) {
            throw runtime.newTypeError(fromArray, runtime.getArray());
        }
        Object newArray = this.javaArrayFromRubyArrayDirect(context, fromArray);
        return new ArrayJavaProxy(runtime, Java.getProxyClassForObject(runtime, newArray), newArray, JavaUtil.getJavaConverter(this.javaClass()));
    }

    public Object javaArrayFromRubyArrayDirect(ThreadContext context, IRubyObject fromArray) {
        Ruby runtime = context.runtime;
        if (!(fromArray instanceof RubyArray)) {
            throw runtime.newTypeError(fromArray, runtime.getArray());
        }
        RubyArray rubyArray = (RubyArray)fromArray;
        Object newArray = Array.newInstance(this.javaClass(), rubyArray.size());
        if (this.javaClass().isArray()) {
            for (int i2 = 0; i2 < rubyArray.size(); ++i2) {
                JavaClass componentType = this.component_type();
                Object componentArray = componentType.javaArrayFromRubyArrayDirect(context, rubyArray.eltInternal(i2));
                ArrayUtils.setWithExceptionHandlingDirect(runtime, newArray, i2, componentArray);
            }
        } else {
            ArrayUtils.copyDataToJavaArrayDirect(context, rubyArray, newArray);
        }
        return newArray;
    }

    @JRubyMethod
    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    @JRubyMethod
    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fields2) {
        RubyArray result2 = this.getRuntime().newArray(fields2.length);
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            result2.append(new JavaField(this.getRuntime(), fields2[i2]));
        }
        return result2;
    }

    @JRubyMethod(required=1)
    public JavaField field(ThreadContext context, IRubyObject name2) {
        Class javaClass = this.javaClass();
        Ruby runtime = context.runtime;
        String stringName = name2.asJavaString();
        try {
            return new JavaField(runtime, javaClass.getField(stringName));
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    return new JavaField(runtime, javaClass.getField(newName));
                }
                catch (NoSuchFieldException nsfe2) {
                    // empty catch block
                }
            }
            throw JavaClass.undefinedFieldError(runtime, javaClass.getName(), stringName);
        }
    }

    @JRubyMethod(required=1)
    public JavaField declared_field(ThreadContext context, IRubyObject name2) {
        Class javaClass = this.javaClass();
        Ruby runtime = context.runtime;
        String stringName = name2.asJavaString();
        try {
            return new JavaField(runtime, javaClass.getDeclaredField(stringName));
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    return new JavaField(runtime, javaClass.getDeclaredField(newName));
                }
                catch (NoSuchFieldException nsfe2) {
                    // empty catch block
                }
            }
            throw JavaClass.undefinedFieldError(runtime, javaClass.getName(), stringName);
        }
    }

    public static RaiseException undefinedFieldError(Ruby runtime, String javaClassName, String name2) {
        return runtime.newNameError("undefined field '" + name2 + "' for class '" + javaClassName + "'", name2);
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getInterfaces());
    }

    @JRubyMethod(name={"primitive?"})
    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    @JRubyMethod(name={"assignable_from?"}, required=1)
    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        return JavaClass.assignable(this.javaClass(), otherClass) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public static boolean assignable(Class<?> thisClass, Class<?> otherClass) {
        if (!thisClass.isPrimitive() && otherClass == Void.TYPE || thisClass.isAssignableFrom(otherClass)) {
            return true;
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        if ((thisClass = JavaUtil.primitiveToWrapper(thisClass)).isAssignableFrom(otherClass)) {
            return true;
        }
        if (Number.class.isAssignableFrom(thisClass)) {
            if (Number.class.isAssignableFrom(otherClass)) {
                return true;
            }
            if (otherClass.equals(Character.class)) {
                return true;
            }
        }
        return thisClass.equals(Character.class) && Number.class.isAssignableFrom(otherClass);
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    @JRubyMethod
    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    private static Constructor[] getConstructors(Class<?> javaClass) {
        try {
            return javaClass.getConstructors();
        }
        catch (SecurityException e) {
            return new Constructor[0];
        }
    }

    private static Class<?>[] getDeclaredClasses(Class<?> javaClass) {
        try {
            return javaClass.getDeclaredClasses();
        }
        catch (SecurityException e) {
            return new Class[0];
        }
        catch (NoClassDefFoundError cnfe) {
            return new Class[0];
        }
    }

    private static Class<?>[] getClasses(Class<?> javaClass) {
        try {
            return javaClass.getClasses();
        }
        catch (SecurityException e) {
            return new Class[0];
        }
    }

    public static Field[] getDeclaredFields(Class<?> javaClass) {
        try {
            return javaClass.getDeclaredFields();
        }
        catch (SecurityException e) {
            return JavaClass.getFields(javaClass);
        }
    }

    public static Field[] getFields(Class<?> javaClass) {
        try {
            return javaClass.getFields();
        }
        catch (SecurityException e) {
            return new Field[0];
        }
    }

    private static boolean methodsAreEquivalent(Method child, Method parent) {
        return parent.getDeclaringClass().isAssignableFrom(child.getDeclaringClass()) && child.getReturnType() == parent.getReturnType() && child.isVarArgs() == parent.isVarArgs() && Modifier.isPublic(child.getModifiers()) == Modifier.isPublic(parent.getModifiers()) && Modifier.isProtected(child.getModifiers()) == Modifier.isProtected(parent.getModifiers()) && Modifier.isStatic(child.getModifiers()) == Modifier.isStatic(parent.getModifiers()) && Arrays.equals(child.getParameterTypes(), parent.getParameterTypes());
    }

    private static int addNewMethods(HashMap<String, List<Method>> nameMethods, Method[] methods2, boolean includeStatic, boolean removeDuplicate) {
        int added = 0;
        block0: for (Method m : methods2) {
            if (Modifier.isPrivate(m.getModifiers()) || (m.getModifiers() & 0x40) != 0 || !includeStatic && Modifier.isStatic(m.getModifiers())) continue;
            List<Method> childMethods = nameMethods.get(m.getName());
            if (childMethods == null) {
                childMethods = new ArrayList<Method>(1);
                childMethods.add(m);
                nameMethods.put(m.getName(), childMethods);
                ++added;
                continue;
            }
            ListIterator<Method> iter = childMethods.listIterator();
            while (iter.hasNext()) {
                Method m2 = iter.next();
                if (!JavaClass.methodsAreEquivalent(m2, m)) continue;
                if (!removeDuplicate) continue block0;
                iter.set(m);
                continue block0;
            }
            childMethods.add(m);
            ++added;
        }
        return added;
    }

    public static Method[] getMethods(Class<?> javaClass) {
        HashMap<String, List<Method>> nameMethods = new HashMap<String, List<Method>>(30);
        int total2 = 0;
        for (Class<?> c = javaClass; c != null; c = c.getSuperclass()) {
            if (Modifier.isPublic(c.getModifiers()) || CAN_SET_ACCESSIBLE) {
                try {
                    total2 += JavaClass.addNewMethods(nameMethods, c.getDeclaredMethods(), c == javaClass, true);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            for (Class<?> i2 : c.getInterfaces()) {
                try {
                    total2 += JavaClass.addNewMethods(nameMethods, i2.getMethods(), false, false);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
        }
        ArrayList finalList = new ArrayList(total2);
        for (Map.Entry entry : nameMethods.entrySet()) {
            finalList.addAll((Collection)entry.getValue());
        }
        return finalList.toArray(new Method[finalList.size()]);
    }

    static {
        boolean canSetAccessible = false;
        if (RubyInstanceConfig.CAN_SET_ACCESSIBLE) {
            try {
                AccessController.checkPermission(new ReflectPermission("suppressAccessChecks"));
                canSetAccessible = true;
            }
            catch (Throwable t) {
                if (Options.JI_LOGCANSETACCESSIBLE.load().booleanValue()) {
                    t.printStackTrace();
                }
                canSetAccessible = false;
            }
        }
        CAN_SET_ACCESSIBLE = canSetAccessible;
        RESERVED_NAMES = new HashMap<String, AssignedName>();
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", Priority.RESERVED));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", Priority.RESERVED));
        RESERVED_NAMES.put("instance_of?", new AssignedName("instance_of?", Priority.RESERVED));
        STATIC_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", Priority.RESERVED));
        INSTANCE_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        INSTANCE_RESERVED_NAMES.put("class", new AssignedName("class", Priority.RESERVED));
        INSTANCE_RESERVED_NAMES.put("initialize", new AssignedName("initialize", Priority.RESERVED));
        DUMMY_INITIALIZER = new Initializer(){

            @Override
            public synchronized void initialize() {
            }
        };
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("\\$plus", "+");
        tmp.put("\\$minus", "-");
        tmp.put("\\$colon", ":");
        tmp.put("\\$div", "/");
        tmp.put("\\$eq", "=");
        tmp.put("\\$less", "<");
        tmp.put("\\$greater", ">");
        tmp.put("\\$bslash", "\\\\");
        tmp.put("\\$hash", "#");
        tmp.put("\\$times", "*");
        tmp.put("\\$bang", "!");
        tmp.put("\\$at", "@");
        tmp.put("\\$percent", "%");
        tmp.put("\\$up", "^");
        tmp.put("\\$amp", "&");
        tmp.put("\\$tilde", "~");
        tmp.put("\\$qmark", "?");
        tmp.put("\\$bar", "|");
        SCALA_OPERATORS = Collections.unmodifiableMap(tmp);
        PRIMITIVE_TO_CLASS = new HashMap<String, Class>();
        PRIMITIVE_TO_CLASS.put("byte", Byte.TYPE);
        PRIMITIVE_TO_CLASS.put("boolean", Boolean.TYPE);
        PRIMITIVE_TO_CLASS.put("short", Short.TYPE);
        PRIMITIVE_TO_CLASS.put("char", Character.TYPE);
        PRIMITIVE_TO_CLASS.put("int", Integer.TYPE);
        PRIMITIVE_TO_CLASS.put("long", Long.TYPE);
        PRIMITIVE_TO_CLASS.put("float", Float.TYPE);
        PRIMITIVE_TO_CLASS.put("double", Double.TYPE);
    }

    private static class InitializerState {
        public final Map<String, AssignedName> staticNames;
        public final Map<String, AssignedName> instanceNames;
        public final Map<String, NamedInstaller> staticCallbacks = new HashMap<String, NamedInstaller>();
        public final Map<String, NamedInstaller> instanceCallbacks = new HashMap<String, NamedInstaller>();
        public final List<ConstantField> constantFields = new ArrayList<ConstantField>();

        public InitializerState(Ruby runtime, Class superclass2) {
            if (superclass2 == null) {
                this.staticNames = new HashMap<String, AssignedName>();
                this.instanceNames = new HashMap<String, AssignedName>();
            } else {
                JavaClass superJavaClass = JavaClass.get(runtime, superclass2);
                this.staticNames = new HashMap<String, AssignedName>(superJavaClass.getStaticAssignedNames());
                this.instanceNames = new HashMap<String, AssignedName>(superJavaClass.getInstanceAssignedNames());
            }
            this.staticNames.putAll(STATIC_RESERVED_NAMES);
            this.instanceNames.putAll(INSTANCE_RESERVED_NAMES);
        }
    }

    private class ClassInitializer
    implements Initializer {
        private volatile boolean hasRun = false;
        private final Class javaClass;

        public ClassInitializer(Class<?> javaClass2) {
            this.javaClass = javaClass2;
        }

        @Override
        public synchronized void initialize() {
            if (this.hasRun) {
                return;
            }
            this.hasRun = true;
            Class superclass2 = this.javaClass.getSuperclass();
            InitializerState state2 = new InitializerState(JavaClass.this.getRuntime(), superclass2);
            JavaClass.this.setupClassFields(this.javaClass, state2);
            JavaClass.this.setupClassMethods(this.javaClass, state2);
            JavaClass.this.setupClassConstructors(this.javaClass);
            JavaClass.this.staticAssignedNames = Collections.unmodifiableMap(state2.staticNames);
            JavaClass.this.instanceAssignedNames = Collections.unmodifiableMap(state2.instanceNames);
            JavaClass.this.staticInstallers = Collections.unmodifiableMap(state2.staticCallbacks);
            JavaClass.this.instanceInstallers = Collections.unmodifiableMap(state2.instanceCallbacks);
            JavaClass.this.constantFields = Collections.unmodifiableList(state2.constantFields);
        }
    }

    private class InterfaceInitializer
    implements Initializer {
        private volatile boolean hasRun = false;
        private final Class javaClass;

        public InterfaceInitializer(Class<?> javaClass2) {
            this.javaClass = javaClass2;
        }

        @Override
        public synchronized void initialize() {
            if (this.hasRun) {
                return;
            }
            this.hasRun = true;
            InitializerState state2 = new InitializerState(JavaClass.this.getRuntime(), null);
            Field[] fields2 = JavaClass.getDeclaredFields(this.javaClass);
            int i2 = fields2.length;
            while (--i2 >= 0) {
                int modifiers2;
                Field field2 = fields2[i2];
                if (this.javaClass != field2.getDeclaringClass()) continue;
                if (ConstantField.isConstant(field2)) {
                    state2.constantFields.add(new ConstantField(field2));
                }
                if (!Modifier.isStatic(modifiers2 = field2.getModifiers())) continue;
                JavaClass.this.addField(state2.staticCallbacks, state2.staticNames, field2, Modifier.isFinal(modifiers2), true);
            }
            JavaClass.this.setupInterfaceMethods(this.javaClass, state2);
            JavaClass.this.handleScalaSingletons(this.javaClass, state2);
            for (Map.Entry<String, NamedInstaller> entry : state2.staticCallbacks.entrySet()) {
                if (entry.getValue().type != 2 || !entry.getValue().hasLocalMethod()) continue;
                JavaClass.assignAliases((MethodInstaller)entry.getValue(), state2.staticNames);
            }
            JavaClass.this.staticAssignedNames = Collections.unmodifiableMap(state2.staticNames);
            JavaClass.this.staticInstallers = Collections.unmodifiableMap(state2.staticCallbacks);
            JavaClass.this.constantFields = Collections.unmodifiableList(state2.constantFields);
        }
    }

    private static interface Initializer {
        public void initialize();
    }

    private static class ConstantField {
        static final int CONSTANT = 25;
        final Field field;

        ConstantField(Field field2) {
            this.field = field2;
        }

        void install(RubyModule proxy2) {
            if (proxy2.getConstantAt(this.field.getName()) == null) {
                try {
                    proxy2.setConstant(this.field.getName(), JavaUtil.convertJavaToUsableRubyObject(proxy2.getRuntime(), this.field.get(null)));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }

        static boolean isConstant(Field field2) {
            return (field2.getModifiers() & 0x19) == 25 && Character.isUpperCase(field2.getName().charAt(0));
        }
    }

    private static class InstanceMethodInvokerInstaller
    extends MethodInstaller {
        InstanceMethodInvokerInstaller(String name2) {
            super(name2, 4);
        }

        @Override
        void install(RubyModule proxy2) {
            if (this.hasLocalMethod()) {
                InstanceMethodInvoker method = new InstanceMethodInvoker(proxy2, this.methods);
                proxy2.addMethod(this.name, method);
                if (this.aliases != null && this.isPublic()) {
                    proxy2.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }
    }

    private static class SingletonMethodInvokerInstaller
    extends StaticMethodInvokerInstaller {
        private Object singleton;

        SingletonMethodInvokerInstaller(String name2, Object singleton) {
            super(name2);
            this.singleton = singleton;
        }

        @Override
        void install(RubyModule proxy2) {
            RubyClass rubySingleton = proxy2.getSingletonClass();
            SingletonMethodInvoker method = new SingletonMethodInvoker(this.singleton, rubySingleton, this.methods);
            rubySingleton.addMethod(this.name, method);
            if (this.aliases != null && this.isPublic()) {
                rubySingleton.defineAliases(this.aliases, this.name);
                this.aliases = null;
            }
        }
    }

    private static class StaticMethodInvokerInstaller
    extends MethodInstaller {
        StaticMethodInvokerInstaller(String name2) {
            super(name2, 2);
        }

        @Override
        void install(RubyModule proxy2) {
            if (this.hasLocalMethod()) {
                RubyClass singleton = proxy2.getSingletonClass();
                StaticMethodInvoker method = new StaticMethodInvoker(singleton, (List<Method>)this.methods);
                singleton.addMethod(this.name, method);
                if (this.aliases != null && this.isPublic()) {
                    singleton.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }
    }

    private static class ConstructorInvokerInstaller
    extends MethodInstaller {
        private boolean haveLocalConstructor;
        protected List<Constructor> constructors;

        ConstructorInvokerInstaller(String name2) {
            super(name2, 2);
        }

        void addConstructor(Constructor ctor, Class<?> javaClass) {
            if (this.constructors == null) {
                this.constructors = new ArrayList<Constructor>(4);
            }
            if (!Ruby.isSecurityRestricted()) {
                try {
                    ctor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.constructors.add(ctor);
            this.haveLocalConstructor |= javaClass == ctor.getDeclaringClass();
        }

        @Override
        void install(RubyModule proxy2) {
            if (this.haveLocalConstructor) {
                ConstructorInvoker method = new ConstructorInvoker(proxy2, this.constructors);
                proxy2.addMethod(this.name, method);
            } else {
                proxy2.addMethod(this.name, new org.jruby.internal.runtime.methods.JavaMethod(proxy2, Visibility.PUBLIC){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                        throw context.runtime.newTypeError("no public constructors for " + clazz);
                    }
                });
            }
        }
    }

    private static abstract class MethodInstaller
    extends NamedInstaller {
        private boolean haveLocalMethod;
        protected List<Method> methods;
        protected List<String> aliases;

        MethodInstaller() {
        }

        MethodInstaller(String name2, int type2) {
            super(name2, type2);
        }

        void addMethod(Method method, Class<?> javaClass) {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>(4);
            }
            this.methods.add(method);
            this.haveLocalMethod |= javaClass == method.getDeclaringClass() || method.getDeclaringClass().isInterface();
        }

        void addAlias(String alias2) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>(4);
            }
            if (!this.aliases.contains(alias2)) {
                this.aliases.add(alias2);
            }
        }

        @Override
        boolean hasLocalMethod() {
            return this.haveLocalMethod;
        }

        void setLocalMethod(boolean b2) {
            this.haveLocalMethod = b2;
        }
    }

    private static class InstanceFieldSetterInstaller
    extends FieldInstaller {
        InstanceFieldSetterInstaller() {
        }

        InstanceFieldSetterInstaller(String name2, Field field2) {
            super(name2, 3, field2);
        }

        @Override
        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.addMethod(this.name, new InstanceFieldSetter(this.name, proxy2, this.field));
            }
        }
    }

    private static class InstanceFieldGetterInstaller
    extends FieldInstaller {
        InstanceFieldGetterInstaller() {
        }

        InstanceFieldGetterInstaller(String name2, Field field2) {
            super(name2, 3, field2);
        }

        @Override
        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.addMethod(this.name, new InstanceFieldGetter(this.name, proxy2, this.field));
            }
        }
    }

    private static class StaticFieldSetterInstaller
    extends FieldInstaller {
        StaticFieldSetterInstaller() {
        }

        StaticFieldSetterInstaller(String name2, Field field2) {
            super(name2, 1, field2);
        }

        @Override
        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.getSingletonClass().addMethod(this.name, new StaticFieldSetter(this.name, proxy2, this.field));
            }
        }
    }

    private static class StaticFieldGetterInstaller
    extends FieldInstaller {
        StaticFieldGetterInstaller() {
        }

        StaticFieldGetterInstaller(String name2, Field field2) {
            super(name2, 1, field2);
        }

        @Override
        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.getSingletonClass().addMethod(this.name, new StaticFieldGetter(this.name, proxy2, this.field));
            }
        }
    }

    private static abstract class FieldInstaller
    extends NamedInstaller {
        Field field;

        FieldInstaller() {
        }

        FieldInstaller(String name2, int type2, Field field2) {
            super(name2, type2);
            this.field = field2;
        }
    }

    private static abstract class NamedInstaller {
        static final int STATIC_FIELD = 1;
        static final int STATIC_METHOD = 2;
        static final int INSTANCE_FIELD = 3;
        static final int INSTANCE_METHOD = 4;
        static final int CONSTRUCTOR = 5;
        String name;
        int type;
        Visibility visibility = Visibility.PUBLIC;

        NamedInstaller() {
        }

        NamedInstaller(String name2, int type2) {
            this.name = name2;
            this.type = type2;
        }

        abstract void install(RubyModule var1);

        boolean hasLocalMethod() {
            return true;
        }

        boolean isPublic() {
            return this.visibility == Visibility.PUBLIC;
        }

        boolean isProtected() {
            return this.visibility == Visibility.PROTECTED;
        }
    }

    private static class AssignedName {
        String name;
        Priority type;

        AssignedName() {
        }

        AssignedName(String name2, Priority type2) {
            this.name = name2;
            this.type = type2;
        }
    }

    private static enum Priority {
        RESERVED(0),
        METHOD(1),
        FIELD(2),
        PROTECTED_METHOD(3),
        WEAKLY_RESERVED(4),
        ALIAS(5),
        PROTECTED_FIELD(6);

        private int value;

        private Priority(int value2) {
            this.value = value2;
        }

        public boolean asImportantAs(AssignedName other) {
            return other != null && other.type.value == this.value;
        }

        public boolean lessImportantThan(AssignedName other) {
            return other != null && other.type.value < this.value;
        }

        public boolean moreImportantThan(AssignedName other) {
            return other == null || other.type.value > this.value;
        }
    }
}

