/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import org.jruby.RubyInstanceConfig;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.GetInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.Match2Instr;
import org.jruby.ir.instructions.Match3Instr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.OneOperandBranchInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.PutInstr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.TwoOperandBranchInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRWriterEncoder;

public class InstrEncoderMap {
    private final IRWriterEncoder e;

    public InstrEncoderMap(IRWriterEncoder encoder) {
        this.e = encoder;
    }

    public void encode(Instr instr) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Instr(" + (Object)((Object)instr.getOperation()) + "): " + instr);
        }
        this.e.encode(instr.getOperation());
        if (instr instanceof ResultInstr) {
            this.e.encode(((ResultInstr)((Object)instr)).getResult());
        }
        switch (instr.getOperation()) {
            case ALIAS: {
                this.encodeAliasInstr((AliasInstr)instr);
                break;
            }
            case ATTR_ASSIGN: {
                this.encodeAttrAssignInstr((AttrAssignInstr)instr);
                break;
            }
            case BEQ: {
                this.encodeBEQInstr((BEQInstr)instr);
                break;
            }
            case BINDING_LOAD: {
                this.encodeLoadLocalVarInstr((LoadLocalVarInstr)instr);
                break;
            }
            case BINDING_STORE: {
                this.encodeStoreLocalVarInstr((StoreLocalVarInstr)instr);
                break;
            }
            case BLOCK_GIVEN: {
                this.encodeBlockGivenInstr((BlockGivenInstr)instr);
                break;
            }
            case BNE: {
                this.encodeBNEInstr((BNEInstr)instr);
                break;
            }
            case BREAK: {
                this.encodeBreakInstr((BreakInstr)instr);
                break;
            }
            case B_FALSE: {
                this.encodeBFalseInstr((BFalseInstr)instr);
                break;
            }
            case B_NIL: {
                this.encodeBNilInstr((BNilInstr)instr);
                break;
            }
            case B_TRUE: {
                this.encodeBTrueInstr((BTrueInstr)instr);
                break;
            }
            case B_UNDEF: {
                this.encodeBUndefInstr((BUndefInstr)instr);
                break;
            }
            case CALL: {
                this.encodeCallBaseInstr((CallInstr)instr);
                break;
            }
            case CHECK_ARGS_ARRAY_ARITY: {
                this.encodeCheckArgsArrayArityInstr((CheckArgsArrayArityInstr)instr);
                break;
            }
            case CHECK_ARITY: {
                this.encodeCheckArityInstr((CheckArityInstr)instr);
                break;
            }
            case CLASS_VAR_MODULE: {
                this.encodeGetClassVarContainerModuleInstr((GetClassVarContainerModuleInstr)instr);
                break;
            }
            case CONST_MISSING: {
                this.encodeConstMissingInstr((ConstMissingInstr)instr);
                break;
            }
            case COPY: {
                this.encodeCopyInstr((CopyInstr)instr);
                break;
            }
            case DEF_CLASS: {
                this.encodeDefineClassInstr((DefineClassInstr)instr);
                break;
            }
            case DEF_CLASS_METH: {
                this.encodeDefineClassMethodInstr((DefineClassMethodInstr)instr);
                break;
            }
            case DEF_INST_METH: {
                this.encodeDefineInstanceMethodInstr((DefineInstanceMethodInstr)instr);
                break;
            }
            case DEF_META_CLASS: {
                this.encodeDefineMetaClassInstr((DefineMetaClassInstr)instr);
                break;
            }
            case DEF_MODULE: {
                this.encodeDefineModuleInstr((DefineModuleInstr)instr);
                break;
            }
            case EQQ: {
                this.encodeEQQInstr((EQQInstr)instr);
                break;
            }
            case EXC_REGION_END: {
                break;
            }
            case EXC_REGION_START: {
                this.encodeExceptionRegionStartMarkerInstr((ExceptionRegionStartMarkerInstr)instr);
                break;
            }
            case GET_CVAR: {
                this.encodeGetClassVariableInstr((GetClassVariableInstr)instr);
                break;
            }
            case GET_ENCODING: {
                this.encodeGetEncodingInstr((GetEncodingInstr)instr);
                break;
            }
            case GET_ERROR_INFO: {
                break;
            }
            case GET_FIELD: {
                this.encodeGetFieldInstr((GetFieldInstr)instr);
                break;
            }
            case GET_GLOBAL_VAR: {
                this.encodeGetGlobalVariableInstr((GetGlobalVariableInstr)instr);
                break;
            }
            case GVAR_ALIAS: {
                this.encodeGVarAliasInstr((GVarAliasInstr)instr);
                break;
            }
            case INHERITANCE_SEARCH_CONST: {
                this.encodeInheritanceSearchConstInstr((InheritanceSearchConstInstr)instr);
                break;
            }
            case JUMP: {
                this.encodeJumpInstr((JumpInstr)instr);
                break;
            }
            case LABEL: {
                this.encodeLabelInstr((LabelInstr)instr);
                break;
            }
            case LAMBDA: {
                this.encodeBuildLambdaInstr((BuildLambdaInstr)instr);
                break;
            }
            case LEXICAL_SEARCH_CONST: {
                this.encodeLexicalSearchConstInstr((LexicalSearchConstInstr)instr);
                break;
            }
            case LINE_NUM: {
                this.encodeLineNumberInstr((LineNumberInstr)instr);
                break;
            }
            case MASGN_OPT: {
                this.encodeOptArgMultipleAsgnInstr((OptArgMultipleAsgnInstr)instr);
                break;
            }
            case MASGN_REQD: {
                this.encodeReqdArgMultipleAsgnInstr((ReqdArgMultipleAsgnInstr)instr);
                break;
            }
            case MASGN_REST: {
                this.encodeRestArgMultipleAsgnInstr((RestArgMultipleAsgnInstr)instr);
                break;
            }
            case MATCH: {
                this.encodeMatchInstr((MatchInstr)instr);
                break;
            }
            case MATCH2: {
                this.encodeMatch2Instr((Match2Instr)instr);
                break;
            }
            case MATCH3: {
                this.encodeMatch3Instr((Match3Instr)instr);
                break;
            }
            case NONLOCAL_RETURN: {
                this.encodeNonlocalReturnInstr((NonlocalReturnInstr)instr);
                break;
            }
            case NOP: {
                break;
            }
            case NORESULT_CALL: {
                this.encodeCallBaseInstr((NoResultCallInstr)instr);
                break;
            }
            case POP_BINDING: {
                break;
            }
            case POP_FRAME: {
                break;
            }
            case PROCESS_MODULE_BODY: {
                this.encodeProcessModuleBodyInstr((ProcessModuleBodyInstr)instr);
                break;
            }
            case PUSH_BINDING: {
                break;
            }
            case PUSH_FRAME: {
                break;
            }
            case PUT_CONST: {
                this.encodePutConstInstr((PutConstInstr)instr);
                break;
            }
            case PUT_CVAR: {
                this.encodePutClassVariableInstr((PutClassVariableInstr)instr);
                break;
            }
            case PUT_FIELD: {
                this.encodePutFieldInstr((PutFieldInstr)instr);
                break;
            }
            case PUT_GLOBAL_VAR: {
                this.encodePutGlobalVarInstr((PutGlobalVarInstr)instr);
                break;
            }
            case RAISE_ARGUMENT_ERROR: {
                this.encodeRaiseArgumentErrorInstr((RaiseArgumentErrorInstr)instr);
                break;
            }
            case RECORD_END_BLOCK: {
                this.encodeRecordEndBlockInstr((RecordEndBlockInstr)instr);
                break;
            }
            case REIFY_CLOSURE: {
                this.encodeReifyClosureInstr((ReifyClosureInstr)instr);
                break;
            }
            case RECV_RUBY_EXC: {
                this.encodeReceiveRubyExceptionInstr((ReceiveRubyExceptionInstr)instr);
                break;
            }
            case RECV_JRUBY_EXC: {
                this.encodeReceiveJRubyExceptionInstr((ReceiveJRubyExceptionInstr)instr);
                break;
            }
            case RECV_KW_ARG: {
                this.encodeReceiveKeywordArgInstr((ReceiveKeywordArgInstr)instr);
                break;
            }
            case RECV_KW_REST_ARG: {
                this.encodeReceiveKeywordRestArgInstr((ReceiveKeywordRestArgInstr)instr);
                break;
            }
            case RECV_OPT_ARG: {
                this.encodeReceiveOptArgInstr((ReceiveOptArgInstr)instr);
                break;
            }
            case RECV_POST_REQD_ARG: {
                this.encodeReceivePostReqdArgInstr((ReceivePostReqdArgInstr)instr);
                break;
            }
            case RECV_PRE_REQD_ARG: {
                this.encodeReceivePreReqdArgInstr((ReceivePreReqdArgInstr)instr);
                break;
            }
            case RECV_REST_ARG: {
                this.encodeReceiveRestArgInstr((ReceiveRestArgInstr)instr);
                break;
            }
            case RECV_SELF: {
                break;
            }
            case RESCUE_EQQ: {
                this.encodeRescueEQQInstr((RescueEQQInstr)instr);
                break;
            }
            case RESTORE_ERROR_INFO: {
                this.encodeRestoreErrorInfoInstr((RestoreErrorInfoInstr)instr);
                break;
            }
            case RETURN: {
                this.encodeReturnInstr((ReturnInstr)instr);
                break;
            }
            case RUNTIME_HELPER: {
                this.encodeRuntimeHelperCall((RuntimeHelperCall)instr);
                break;
            }
            case SEARCH_CONST: {
                this.encodeSearchConstInstr((SearchConstInstr)instr);
                break;
            }
            case CLASS_SUPER: {
                this.encodeClassSuperInstr((ClassSuperInstr)instr);
                break;
            }
            case INSTANCE_SUPER: {
                this.encodeInstanceSuperInstr((InstanceSuperInstr)instr);
                break;
            }
            case UNRESOLVED_SUPER: {
                this.encodeUnresolvedSuperInstr((UnresolvedSuperInstr)instr);
                break;
            }
            case THREAD_POLL: {
                this.encodeThreadPollInstr((ThreadPollInstr)instr);
                break;
            }
            case THROW: {
                this.encodeThrowExceptionInstr((ThrowExceptionInstr)instr);
                break;
            }
            case TO_ARY: {
                this.encodeToAryInstr((ToAryInstr)instr);
                break;
            }
            case UNDEF_METHOD: {
                this.encodeUndefMethodInstr((UndefMethodInstr)instr);
                break;
            }
            case YIELD: {
                this.encodeYieldInstr((YieldInstr)instr);
                break;
            }
            case ZSUPER: {
                this.encodeZSuperInstr((ZSuperInstr)instr);
                break;
            }
            default: {
                throw new IllegalArgumentException("Whoa what am I encoding: " + instr);
            }
        }
    }

    private void encodeAliasInstr(AliasInstr instr) {
        this.e.encode(instr.getNewName());
        this.e.encode(instr.getOldName());
    }

    private void encodeAttrAssignInstr(AttrAssignInstr instr) {
        this.e.encode(instr.getReceiver());
        this.e.encode(instr.getName());
        Operand[] args2 = instr.getCallArgs();
        this.e.encode(args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.e.encode(args2[i2]);
        }
    }

    private void encodeBEQInstr(BEQInstr instr) {
        this.encodeTwoOperandBranchInstr(instr);
    }

    private void encodeLoadLocalVarInstr(LoadLocalVarInstr instr) {
        this.e.encode(instr.getScope());
        this.e.encode(instr.getLocalVar());
    }

    private void encodeStoreLocalVarInstr(StoreLocalVarInstr instr) {
        this.e.encode(instr.getScope());
        this.e.encode(instr.getLocalVar());
        this.e.encode(instr.getValue());
    }

    private void encodeBlockGivenInstr(BlockGivenInstr instr) {
        this.e.encode(instr.getBlockArg());
    }

    private void encodeBNEInstr(BNEInstr instr) {
        this.encodeTwoOperandBranchInstr(instr);
    }

    private void encodeBreakInstr(BreakInstr instr) {
        this.e.encode(instr.getReturnValue());
        this.e.encode(instr.getScopeName());
    }

    private void encodeBFalseInstr(BFalseInstr instr) {
        this.encodeOneOperandBranchInstr(instr);
    }

    private void encodeBNilInstr(BNilInstr instr) {
        this.encodeOneOperandBranchInstr(instr);
    }

    private void encodeBTrueInstr(BTrueInstr instr) {
        this.encodeOneOperandBranchInstr(instr);
    }

    private void encodeBUndefInstr(BUndefInstr instr) {
        this.encodeOneOperandBranchInstr(instr);
    }

    private void encodeCheckArgsArrayArityInstr(CheckArgsArrayArityInstr instr) {
        this.e.encode(instr.getArgsArray());
        this.e.encode(instr.required);
        this.e.encode(instr.opt);
        this.e.encode(instr.rest);
    }

    private void encodeCheckArityInstr(CheckArityInstr instr) {
        this.e.encode(instr.required);
        this.e.encode(instr.opt);
        this.e.encode(instr.rest);
        this.e.encode(instr.receivesKeywords);
    }

    private void encodeGetClassVarContainerModuleInstr(GetClassVarContainerModuleInstr instr) {
        this.e.encode(instr.getStartingScope());
        this.e.encode(instr.getObject());
    }

    private void encodeConstMissingInstr(ConstMissingInstr instr) {
        this.e.encode(instr.getReceiver());
        this.e.encode(instr.getMissingConst());
    }

    private void encodeCopyInstr(CopyInstr instr) {
        this.e.encode(instr.getSource());
    }

    private void encodeDefineClassInstr(DefineClassInstr instr) {
        this.e.encode(instr.getNewIRClassBody());
        this.e.encode(instr.getContainer());
        this.e.encode(instr.getSuperClass());
    }

    private void encodeDefineClassMethodInstr(DefineClassMethodInstr instr) {
        this.e.encode(instr.getContainer());
        this.e.encode(instr.getMethod());
    }

    private void encodeDefineInstanceMethodInstr(DefineInstanceMethodInstr instr) {
        this.e.encode(instr.getMethod());
    }

    private void encodeDefineMetaClassInstr(DefineMetaClassInstr instr) {
        this.e.encode(instr.getObject());
        this.e.encode(instr.getMetaClassBody());
    }

    private void encodeDefineModuleInstr(DefineModuleInstr instr) {
        this.e.encode(instr.getNewIRModuleBody());
        this.e.encode(instr.getContainer());
    }

    private void encodeEQQInstr(EQQInstr instr) {
        this.e.encode(instr.getArg1());
        this.e.encode(instr.getArg2());
    }

    private void encodeExceptionRegionStartMarkerInstr(ExceptionRegionStartMarkerInstr instr) {
        this.e.encode(instr.getFirstRescueBlockLabel());
    }

    private void encodeGetClassVariableInstr(GetClassVariableInstr instr) {
        this.encodeGetInstr(instr);
    }

    private void encodeGetEncodingInstr(GetEncodingInstr instr) {
        this.e.encode(instr.getEncoding().toString());
    }

    private void encodeGetFieldInstr(GetFieldInstr instr) {
        this.encodeGetInstr(instr);
    }

    private void encodeGetGlobalVariableInstr(GetGlobalVariableInstr instr) {
        this.e.encode(((GlobalVariable)instr.getSource()).getName());
    }

    private void encodeGVarAliasInstr(GVarAliasInstr instr) {
        this.e.encode(instr.getNewName());
        this.e.encode(instr.getOldName());
    }

    private void encodeInheritanceSearchConstInstr(InheritanceSearchConstInstr instr) {
        this.e.encode(instr.getCurrentModule());
        this.e.encode(instr.getConstName());
        this.e.encode(instr.isNoPrivateConsts());
    }

    private void encodeJumpInstr(JumpInstr instr) {
        this.e.encode(instr.getJumpTarget());
    }

    private void encodeLabelInstr(LabelInstr instr) {
        this.e.encode(instr.getLabel());
    }

    private void encodeBuildLambdaInstr(BuildLambdaInstr instr) {
        this.e.encode(instr.getLambdaBodyName());
        this.e.encode(instr.getPosition().getFile());
        this.e.encode(instr.getPosition().getLine());
    }

    private void encodeLexicalSearchConstInstr(LexicalSearchConstInstr instr) {
        this.e.encode(instr.getDefiningScope());
        this.e.encode(instr.getConstName());
    }

    private void encodeLineNumberInstr(LineNumberInstr instr) {
        this.e.encode(instr.getLineNumber());
    }

    private void encodeOptArgMultipleAsgnInstr(OptArgMultipleAsgnInstr instr) {
        this.e.encode(instr.getArray());
        this.e.encode(instr.getIndex());
        this.e.encode(instr.getMinArgsLength());
    }

    private void encodeReqdArgMultipleAsgnInstr(ReqdArgMultipleAsgnInstr instr) {
        this.e.encode(instr.getArray());
        this.e.encode(instr.getPreArgsCount());
        this.e.encode(instr.getPostArgsCount());
        this.e.encode(instr.getIndex());
    }

    private void encodeRestArgMultipleAsgnInstr(RestArgMultipleAsgnInstr instr) {
        this.e.encode(instr.getArray());
        this.e.encode(instr.getPreArgsCount());
        this.e.encode(instr.getPostArgsCount());
        this.e.encode(instr.getIndex());
    }

    private void encodeMatchInstr(MatchInstr instr) {
        this.e.encode(instr.getReceiver());
    }

    private void encodeMatch2Instr(Match2Instr instr) {
        this.e.encode(instr.getReceiver());
        this.e.encode(instr.getArg());
    }

    private void encodeMatch3Instr(Match3Instr instr) {
        this.e.encode(instr.getReceiver());
        this.e.encode(instr.getArg());
    }

    private void encodeNonlocalReturnInstr(NonlocalReturnInstr instr) {
        this.e.encode(instr.getReturnValue());
        this.e.encode(instr.methodName);
    }

    private void encodeCallBaseInstr(CallBase instr) {
        boolean hasClosure = instr.getClosureArg(null) != null;
        this.e.encode(instr.getCallType().ordinal());
        this.e.encode(instr.getName());
        this.e.encode(instr.getReceiver());
        this.e.encode(this.calculateArity(instr.getCallArgs(), hasClosure));
        for (Operand arg2 : instr.getCallArgs()) {
            this.e.encode(arg2);
        }
        if (hasClosure) {
            this.e.encode(instr.getClosureArg(null));
        }
    }

    private void encodeProcessModuleBodyInstr(ProcessModuleBodyInstr instr) {
        this.e.encode(instr.getModuleBody());
        this.e.encode(instr.getBlock());
    }

    private void encodePutConstInstr(PutConstInstr instr) {
        this.encodePutInstr(instr);
    }

    private void encodePutClassVariableInstr(PutClassVariableInstr instr) {
        this.encodePutInstr(instr);
    }

    private void encodePutFieldInstr(PutFieldInstr instr) {
        this.encodePutInstr(instr);
    }

    private void encodePutGlobalVarInstr(PutGlobalVarInstr instr) {
        this.e.encode(((GlobalVariable)instr.getTarget()).getName());
        this.e.encode(instr.getValue());
    }

    private void encodeRaiseArgumentErrorInstr(RaiseArgumentErrorInstr instr) {
        this.e.encode(instr.getRequired());
        this.e.encode(instr.getOpt());
        this.e.encode(instr.getRest());
        this.e.encode(instr.getNumArgs());
    }

    private void encodeRecordEndBlockInstr(RecordEndBlockInstr instr) {
        this.e.encode(instr.getDeclaringScope());
        this.e.encode(instr.getEndBlockClosure());
    }

    private void encodeReifyClosureInstr(ReifyClosureInstr instr) {
        this.e.encode(instr.getSource());
        this.e.encode(instr.getResult());
    }

    private void encodeReceiveRubyExceptionInstr(ReceiveRubyExceptionInstr instr) {
    }

    private void encodeReceiveJRubyExceptionInstr(ReceiveJRubyExceptionInstr instr) {
    }

    private void encodeReceiveKeywordArgInstr(ReceiveKeywordArgInstr instr) {
        this.e.encode(instr.argName);
        this.e.encode(instr.required);
    }

    private void encodeReceiveKeywordRestArgInstr(ReceiveKeywordRestArgInstr instr) {
        this.e.encode(instr.required);
    }

    private void encodeReceiveOptArgInstr(ReceiveOptArgInstr instr) {
        this.e.encode(instr.requiredArgs);
        this.e.encode(instr.getPreArgs());
        this.e.encode(instr.getArgIndex());
    }

    private void encodeReceivePostReqdArgInstr(ReceivePostReqdArgInstr instr) {
        this.e.encode(instr.getArgIndex());
        this.e.encode(instr.preReqdArgsCount);
        this.e.encode(instr.postReqdArgsCount);
    }

    private void encodeReceivePreReqdArgInstr(ReceivePreReqdArgInstr instr) {
        this.e.encode(instr.getArgIndex());
    }

    private void encodeReceiveRestArgInstr(ReceiveRestArgInstr instr) {
        this.e.encode(instr.required);
        this.e.encode(instr.getArgIndex());
    }

    private void encodeRescueEQQInstr(RescueEQQInstr instr) {
        this.e.encode(instr.getArg1());
        this.e.encode(instr.getArg2());
    }

    private void encodeRestoreErrorInfoInstr(RestoreErrorInfoInstr instr) {
        this.e.encode(instr.getArg());
    }

    private void encodeReturnInstr(ReturnInstr instr) {
        this.e.encode(instr.getReturnValue());
    }

    private void encodeSearchConstInstr(SearchConstInstr instr) {
        this.e.encode(instr.getConstName());
        this.e.encode(instr.getStartingScope());
        this.e.encode(instr.isNoPrivateConsts());
    }

    private void encodeClassSuperInstr(ClassSuperInstr instr) {
        this.encodeCallBaseInstr(instr);
    }

    private void encodeInstanceSuperInstr(InstanceSuperInstr instr) {
        this.encodeCallBaseInstr(instr);
    }

    private void encodeUnresolvedSuperInstr(UnresolvedSuperInstr instr) {
        boolean hasClosure = instr.getClosureArg(null) != null;
        this.e.encode(instr.getCallType().ordinal());
        this.e.encode(instr.getReceiver());
        this.e.encode(this.calculateArity(instr.getCallArgs(), hasClosure));
        for (Operand arg2 : instr.getCallArgs()) {
            this.e.encode(arg2);
        }
        if (hasClosure) {
            this.e.encode(instr.getClosureArg(null));
        }
    }

    private void encodeThreadPollInstr(ThreadPollInstr instr) {
        this.e.encode(instr.onBackEdge);
    }

    private void encodeThrowExceptionInstr(ThrowExceptionInstr instr) {
        this.e.encode(instr.getException());
    }

    private void encodeToAryInstr(ToAryInstr instr) {
        this.e.encode(instr.getArray());
    }

    private void encodeUndefMethodInstr(UndefMethodInstr instr) {
        this.e.encode(instr.getMethodName());
    }

    private void encodeYieldInstr(YieldInstr instr) {
        this.e.encode(instr.getBlockArg());
        this.e.encode(instr.getYieldArg());
        this.e.encode(instr.isUnwrapArray());
    }

    private void encodeZSuperInstr(ZSuperInstr instr) {
        this.e.encode(instr.getReceiver());
        Operand closure = instr.getClosureArg(null);
        boolean hasClosure = closure != null;
        this.e.encode(hasClosure);
        if (hasClosure) {
            this.e.encode(closure);
        }
        this.e.encode(instr.getCallArgs().length);
        for (Operand arg2 : instr.getCallArgs()) {
            this.e.encode(arg2);
        }
    }

    private void encodeTwoOperandBranchInstr(TwoOperandBranchInstr instr) {
        this.e.encode(instr.getArg1());
        this.e.encode(instr.getArg2());
        this.e.encode(instr.getJumpTarget());
    }

    private void encodeOneOperandBranchInstr(OneOperandBranchInstr instr) {
        this.e.encode(instr.getArg1());
        this.e.encode(instr.getJumpTarget());
    }

    private void encodeGetInstr(GetInstr instr) {
        this.e.encode(instr.getSource());
        this.e.encode(instr.getRef());
    }

    private void encodePutInstr(PutInstr instr) {
        this.e.encode(instr.getTarget());
        this.e.encode(instr.getRef());
        this.e.encode(instr.getValue());
    }

    private int calculateArity(Operand[] arguments, boolean hasClosure) {
        return hasClosure ? -1 * (arguments.length + 1) : arguments.length;
    }

    private void encodeRuntimeHelperCall(RuntimeHelperCall instr) {
        this.e.encode(instr.getHelperMethod().ordinal());
        Operand[] args2 = instr.getArgs();
        this.e.encode(args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.e.encode(args2[i2]);
        }
    }
}

