/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRWriter;
import org.jruby.ir.persistence.IRWriterAnalzer;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.persistence.InstrEncoderMap;
import org.jruby.ir.persistence.OperandEncoderMap;
import org.jruby.parser.StaticScope;

public class IRWriterFile
implements IRWriterEncoder,
IRPersistenceValues {
    private static final int VERSION = 0;
    private final Map<IRScope, Integer> scopeInstructionOffsets = new HashMap<IRScope, Integer>();
    private final ByteBuffer buf = ByteBuffer.allocate(0x200000);
    private final File file;
    private final OperandEncoderMap operandEncoder;
    private final InstrEncoderMap instrEncoder;
    private final IRWriterAnalzer analyzer;
    int headersOffset = -1;
    int poolOffset = -1;

    public IRWriterFile(File file2) throws FileNotFoundException {
        this.file = file2;
        this.operandEncoder = new OperandEncoderMap(this);
        this.instrEncoder = new InstrEncoderMap(this);
        this.analyzer = new IRWriterAnalzer();
    }

    public void addScopeInstructionOffset(IRScope scope) {
        this.scopeInstructionOffsets.put(scope, this.offset());
    }

    private int offset() {
        return this.buf.position() + 8;
    }

    public int getScopeInstructionOffset(IRScope scope) {
        return this.scopeInstructionOffsets.get(scope);
    }

    @Override
    public void encode(boolean value2) {
        this.buf.put(value2 ? (byte)116 : 102);
    }

    @Override
    public void encode(byte value2) {
        this.buf.put(value2);
    }

    @Override
    public void encode(char value2) {
        this.buf.putChar(value2);
    }

    @Override
    public void encode(int value2) {
        if (value2 >= 0 && value2 <= 127) {
            this.buf.put((byte)value2);
        } else {
            this.buf.put((byte)-1);
            this.buf.putInt(value2);
        }
    }

    @Override
    public void encode(long value2) {
        if (value2 >= 0L && value2 <= 127L) {
            this.encode((byte)value2);
        } else {
            this.buf.put((byte)-1);
            this.buf.putLong(value2);
        }
    }

    @Override
    public void encode(float value2) {
        this.buf.putFloat(value2);
    }

    @Override
    public void encode(double value2) {
        this.buf.putDouble(value2);
    }

    @Override
    public void encode(String value2) {
        this.encode(value2.length());
        this.buf.put(value2.getBytes());
    }

    @Override
    public void encode(String[] values2) {
        if (values2 == null) {
            this.encode(0);
            return;
        }
        this.encode(values2.length);
        for (String value2 : values2) {
            this.encode(value2.length());
            this.buf.put(value2.getBytes());
        }
    }

    @Override
    public void encode(Operand operand) {
        this.operandEncoder.encode(operand);
    }

    @Override
    public void encode(Instr instr) {
        this.instrEncoder.encode(instr);
    }

    @Override
    public void encode(IRScope value2) {
        this.encode(this.analyzer.getScopeID(value2));
    }

    @Override
    public void encode(IRScopeType value2) {
        this.encode((byte)value2.ordinal());
    }

    @Override
    public void encode(StaticScope.Type value2) {
        this.encode((byte)value2.ordinal());
    }

    @Override
    public void encode(Operation value2) {
        this.encode((byte)value2.ordinal());
    }

    @Override
    public void encode(OperandType value2) {
        this.encode((byte)value2.ordinal());
    }

    @Override
    public void startEncodingScopeHeader(IRScope scope) {
    }

    @Override
    public void endEncodingScopeHeader(IRScope scope) {
        this.encode(this.getScopeInstructionOffset(scope));
    }

    @Override
    public void startEncodingScopeInstrs(IRScope scope) {
        this.addScopeInstructionOffset(scope);
        this.encode(scope.getInstrs().size());
    }

    @Override
    public void endEncodingScopeInstrs(IRScope scope) {
    }

    @Override
    public void startEncodingScopeHeaders(IRScope script) {
        this.headersOffset = this.offset();
        this.encode(this.analyzer.getScopeCount());
    }

    @Override
    public void endEncodingScopeHeaders(IRScope script) {
    }

    @Override
    public void startEncoding(IRScope script) {
        try {
            IRWriter.persist(this.analyzer, script);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void endEncoding(IRScope script) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file);
            fos.write(ByteBuffer.allocate(4).putInt(this.headersOffset).array());
            fos.write(ByteBuffer.allocate(4).putInt(this.poolOffset).array());
            this.buf.flip();
            fos.getChannel().write(this.buf);
            fos.close();
        }
        catch (IOException e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }
}

