/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;

public class OptimizeTempVarsPass
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Temporary Variable Reduction";
    }

    @Override
    public Object execute(IRScope s2, Object ... data2) {
        for (IRClosure c : s2.getClosures()) {
            this.run(c, false, true);
        }
        OptimizeTempVarsPass.optimizeTmpVars(s2);
        return null;
    }

    @Override
    public boolean invalidate(IRScope s2) {
        return false;
    }

    private static void allocVar(Operand oldVar, IRScope s2, List<TemporaryVariable> freeVarsList, Map<Operand, Operand> newVarMap) {
        if (newVarMap.get(oldVar) == null) {
            newVarMap.put(oldVar, freeVarsList.isEmpty() ? s2.createTemporaryVariable() : freeVarsList.remove(0));
        }
    }

    private static void freeVar(TemporaryVariable newVar, List<TemporaryVariable> freeVarsList) {
        if (!freeVarsList.contains(newVar)) {
            freeVarsList.add(0, newVar);
        }
    }

    private static void optimizeTmpVars(IRScope s2) {
        Variable v;
        if (s2.getCFG() != null) {
            return;
        }
        HashMap<TemporaryVariable, Instr> tmpVarUses = new HashMap<TemporaryVariable, Instr>();
        HashMap<TemporaryVariable, Instr> tmpVarDefs = new HashMap<TemporaryVariable, Instr>();
        for (Instr i2 : s2.getInstrs()) {
            for (Variable v2 : i2.getUsedVariables()) {
                if (!(v2 instanceof TemporaryVariable)) continue;
                TemporaryVariable tv = (TemporaryVariable)v2;
                Instr use = (Instr)tmpVarUses.get(tv);
                if (use == null) {
                    tmpVarUses.put(tv, i2);
                    continue;
                }
                if (use == NopInstr.NOP) continue;
                tmpVarUses.put(tv, NopInstr.NOP);
            }
            if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof TemporaryVariable)) continue;
            TemporaryVariable tv = (TemporaryVariable)v;
            Instr defs = (Instr)tmpVarDefs.get(tv);
            if (defs == null) {
                tmpVarDefs.put(tv, i2);
                continue;
            }
            if (defs == NopInstr.NOP) continue;
            tmpVarDefs.put(tv, NopInstr.NOP);
        }
        ListIterator<Instr> instrs = s2.getInstrs().listIterator();
        while (instrs.hasNext()) {
            CopyInstr ci;
            Operand src;
            Instr i2;
            i2 = instrs.next();
            if (!(i2 instanceof ResultInstr)) continue;
            v = ((ResultInstr)((Object)i2)).getResult();
            if (v instanceof TemporaryVariable) {
                Instr use = (Instr)tmpVarUses.get(v);
                Instr def = (Instr)tmpVarDefs.get(v);
                if (use == null) {
                    if (i2 instanceof CopyInstr) {
                        i2.markDead();
                        instrs.remove();
                        continue;
                    }
                    if (!(i2 instanceof CallInstr)) continue;
                    instrs.set(((CallInstr)i2).discardResult());
                    continue;
                }
                if (use == NopInstr.NOP || def == null || def == NopInstr.NOP || !(i2 instanceof CopyInstr) || use instanceof ReturnInstr) continue;
                CopyInstr ci2 = (CopyInstr)i2;
                Operand src2 = ci2.getSource();
                i2.markDead();
                instrs.remove();
                HashMap<Operand, Operand> copyMap = new HashMap<Operand, Operand>();
                copyMap.put(v, src2);
                use.simplifyOperands(copyMap, true);
                continue;
            }
            if (!(i2 instanceof CopyInstr) || !((src = (ci = (CopyInstr)i2).getSource()) instanceof TemporaryVariable)) continue;
            TemporaryVariable vsrc = (TemporaryVariable)src;
            Instr use = (Instr)tmpVarUses.get(vsrc);
            Instr def = (Instr)tmpVarDefs.get(vsrc);
            if (use == null || use == NopInstr.NOP || def == null || def == NopInstr.NOP || def.isDead()) continue;
            ((ResultInstr)((Object)def)).updateResult(ci.getResult());
            ci.markDead();
            instrs.remove();
        }
        HashMap<TemporaryVariable, Integer> lastVarUseOrDef = new HashMap<TemporaryVariable, Integer>();
        int iCount = -1;
        for (Instr i3 : s2.getInstrs()) {
            Variable v3;
            ++iCount;
            if (i3 instanceof ResultInstr && (v3 = ((ResultInstr)((Object)i3)).getResult()) instanceof TemporaryVariable) {
                lastVarUseOrDef.put((TemporaryVariable)v3, iCount);
            }
            for (Variable v4 : i3.getUsedVariables()) {
                if (!(v4 instanceof TemporaryVariable)) continue;
                lastVarUseOrDef.put((TemporaryVariable)v4, iCount);
            }
        }
        lastVarUseOrDef.put(s2.getYieldClosureVariable(), iCount);
        if (s2.hasLoops()) {
            lastVarUseOrDef.put((TemporaryVariable)s2.getCurrentScopeVariable(), iCount);
            lastVarUseOrDef.put((TemporaryVariable)s2.getCurrentModuleVariable(), iCount);
        }
        HashMap<Operand, Operand> newVarMap = new HashMap<Operand, Operand>();
        ArrayList<TemporaryVariable> freeVarsList = new ArrayList<TemporaryVariable>();
        iCount = -1;
        s2.resetTemporaryVariables();
        for (Instr i4 : s2.getInstrs()) {
            ++iCount;
            Variable result2 = null;
            if (i4 instanceof ResultInstr && (result2 = ((ResultInstr)((Object)i4)).getResult()) instanceof TemporaryVariable) {
                OptimizeTempVarsPass.allocVar(result2, s2, freeVarsList, newVarMap);
            }
            for (Variable v5 : i4.getUsedVariables()) {
                if (!(v5 instanceof TemporaryVariable)) continue;
                OptimizeTempVarsPass.allocVar(v5, s2, freeVarsList, newVarMap);
            }
            if (result2 instanceof TemporaryVariable && (Integer)lastVarUseOrDef.get((TemporaryVariable)result2) == iCount) {
                OptimizeTempVarsPass.freeVar((TemporaryVariable)newVarMap.get(result2), freeVarsList);
            }
            for (Variable v5 : i4.getUsedVariables()) {
                TemporaryVariable tv;
                if (!(v5 instanceof TemporaryVariable) || (Integer)lastVarUseOrDef.get(tv = (TemporaryVariable)v5) != iCount) continue;
                OptimizeTempVarsPass.freeVar((TemporaryVariable)newVarMap.get(tv), freeVarsList);
            }
            i4.renameVars(newVarMap);
        }
    }
}

